/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSInventory;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Date;

@Entity
public class POSInventoryLine
extends AbsPOSInventoryLine {
    @JoinColumn(name="inventory_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSInventory inventory;

    public POSInventoryLine() {
    }

    public POSInventoryLine(String paymentWay, BigDecimal value) {
        super(paymentWay, value);
    }

    public POSInventory getInventory() {
        this.inventory = POSPersister.materialize(POSInventory.class, this.inventory);
        return this.inventory;
    }

    public void setInventory(POSInventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public POSMasterFile origin() {
        return this.inventory;
    }

    @Override
    public String getShiftCode() {
        return this.inventory.getShiftCode();
    }

    @Override
    public Date fetchValueDate() {
        return this.inventory.getShiftDate();
    }
}

