/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.supplychain.contracts.details.DTOInvoiceFreeItemLine;
import com.namasoft.modules.supplychain.contracts.entities.DTOSalesOffers;
import com.namasoft.pos.application.IPOSHasDims;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.details.IPOSFreeItemOfferLine;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSSalesOffers;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSFreeItemData;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@Entity
public class POSInvoiceFreeItemLine
implements POSSavable,
IPOSHasDims,
IPOSFreeItemOfferLine {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    private Boolean ignoreOtherOffers;
    @Column(precision=20, scale=10)
    private BigDecimal minInvoiceValue;
    @Column(precision=20, scale=10)
    private BigDecimal maxInvoiceValue;
    private Boolean stopOtherDiscounts;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier1 priceClassifier1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier2 priceClassifier2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier3 priceClassifier3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier4 priceClassifier4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier5 priceClassifier5;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="legalEntityId")), @AttributeOverride(name="code", column=@Column(name="legalEntityCode"))})
    private POSDimInfo legalEntity;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="sectorId")), @AttributeOverride(name="code", column=@Column(name="sectorCode"))})
    private POSDimInfo sector;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="branchId")), @AttributeOverride(name="code", column=@Column(name="branchCode"))})
    private POSDimInfo branch;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="departmentId")), @AttributeOverride(name="code", column=@Column(name="departmentCode"))})
    private POSDimInfo department;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="analysisSetId")), @AttributeOverride(name="code", column=@Column(name="analysisSetCode"))})
    private POSDimInfo analysisSet;
    @Column(length=16)
    private UUID refId;
    private Date fromDate;
    private Date toDate;
    @Column(length=16)
    private UUID targetId;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSInvoiceClassification invoiceClassification;
    @Column(length=16)
    private UUID subsidiaryId;
    private String subsidiaryType;
    @Embedded
    private POSFreeItemData freeItemData;
    @JoinColumn(name="salesOffer_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesOffers salesOffer;

    public UUID getSubsidiaryId() {
        return this.subsidiaryId;
    }

    public void setSubsidiaryId(UUID subsidiaryId) {
        this.subsidiaryId = subsidiaryId;
    }

    @Override
    public String getSubsidiaryType() {
        return this.subsidiaryType;
    }

    public void setSubsidiaryType(String subsidiaryType) {
        this.subsidiaryType = subsidiaryType;
    }

    public UUID getTargetId() {
        return this.targetId;
    }

    public void setTargetId(UUID targetId) {
        this.targetId = targetId;
    }

    public POSInvoiceClassification getInvoiceClassification() {
        this.invoiceClassification = POSPersister.materialize(POSInvoiceClassification.class, this.invoiceClassification);
        return this.invoiceClassification;
    }

    public void setInvoiceClassification(POSInvoiceClassification invoiceClassification) {
        this.invoiceClassification = invoiceClassification;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    @Override
    public UUID getRefId() {
        return this.refId;
    }

    public void setRefId(UUID refId) {
        this.refId = refId;
    }

    public POSSalesPriceClassifier1 getPriceClassifier1() {
        this.priceClassifier1 = POSPersister.materialize(POSSalesPriceClassifier1.class, this.priceClassifier1);
        return this.priceClassifier1;
    }

    public void setPriceClassifier1(POSSalesPriceClassifier1 priceClassifier1) {
        this.priceClassifier1 = priceClassifier1;
    }

    public POSSalesPriceClassifier2 getPriceClassifier2() {
        this.priceClassifier2 = POSPersister.materialize(POSSalesPriceClassifier2.class, this.priceClassifier2);
        return this.priceClassifier2;
    }

    public void setPriceClassifier2(POSSalesPriceClassifier2 priceClassifier2) {
        this.priceClassifier2 = priceClassifier2;
    }

    public POSSalesPriceClassifier3 getPriceClassifier3() {
        this.priceClassifier3 = POSPersister.materialize(POSSalesPriceClassifier3.class, this.priceClassifier3);
        return this.priceClassifier3;
    }

    public void setPriceClassifier3(POSSalesPriceClassifier3 priceClassifier3) {
        this.priceClassifier3 = priceClassifier3;
    }

    public POSSalesPriceClassifier4 getPriceClassifier4() {
        this.priceClassifier4 = POSPersister.materialize(POSSalesPriceClassifier4.class, this.priceClassifier4);
        return this.priceClassifier4;
    }

    public void setPriceClassifier4(POSSalesPriceClassifier4 priceClassifier4) {
        this.priceClassifier4 = priceClassifier4;
    }

    public POSSalesPriceClassifier5 getPriceClassifier5() {
        this.priceClassifier5 = POSPersister.materialize(POSSalesPriceClassifier5.class, this.priceClassifier5);
        return this.priceClassifier5;
    }

    public void setPriceClassifier5(POSSalesPriceClassifier5 priceClassifier5) {
        this.priceClassifier5 = priceClassifier5;
    }

    public POSSalesOffers getSalesOffer() {
        this.salesOffer = POSPersister.materialize(POSSalesOffers.class, this.salesOffer);
        return this.salesOffer;
    }

    public void setSalesOffer(POSSalesOffers salesOffer) {
        this.salesOffer = salesOffer;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public Boolean getIgnoreOtherOffers() {
        return this.ignoreOtherOffers;
    }

    public void setIgnoreOtherOffers(Boolean ignoreOtherOffers) {
        this.ignoreOtherOffers = ignoreOtherOffers;
    }

    public BigDecimal getMinInvoiceValue() {
        return this.minInvoiceValue;
    }

    public void setMinInvoiceValue(BigDecimal minInvoiceValue) {
        this.minInvoiceValue = minInvoiceValue;
    }

    @Override
    public Boolean getStopOtherDiscounts() {
        return this.stopOtherDiscounts;
    }

    public void setStopOtherDiscounts(Boolean stopOtherDiscounts) {
        this.stopOtherDiscounts = stopOtherDiscounts;
    }

    @Override
    public POSFreeItemData getFreeItemData() {
        return this.freeItemData;
    }

    public void setFreeItemData(POSFreeItemData freeItemData) {
        this.freeItemData = freeItemData;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public void updateDate(DTOInvoiceFreeItemLine dtoInvoiceFreeItemLine, DTOSalesOffers dtoSalesOffer) {
        this.setId(UUID.fromString(dtoInvoiceFreeItemLine.getId()));
        this.setFreeItemData(POSFreeItemData.fromDTO(dtoInvoiceFreeItemLine.getFreeItemData(), this));
        this.setStopOtherDiscounts(dtoInvoiceFreeItemLine.getStopOtherDiscounts());
        this.setIgnoreOtherOffers(dtoInvoiceFreeItemLine.getIgnoreOtherOffers());
        this.setMinInvoiceValue(dtoInvoiceFreeItemLine.getMinInvoiceValue());
        this.setPriceClassifier1((POSSalesPriceClassifier1)this.fromReference(dtoInvoiceFreeItemLine.getPriceClassifier1()));
        this.setPriceClassifier2((POSSalesPriceClassifier2)this.fromReference(dtoInvoiceFreeItemLine.getPriceClassifier2()));
        this.setPriceClassifier3((POSSalesPriceClassifier3)this.fromReference(dtoInvoiceFreeItemLine.getPriceClassifier3()));
        this.setPriceClassifier4((POSSalesPriceClassifier4)this.fromReference(dtoInvoiceFreeItemLine.getPriceClassifier4()));
        this.setPriceClassifier5((POSSalesPriceClassifier5)this.fromReference(dtoInvoiceFreeItemLine.getPriceClassifier5()));
        this.setRefId(ServerStringUtils.strToUUID((String)dtoSalesOffer.getId()));
        this.setFromDate(dtoSalesOffer.getFromDate());
        this.setToDate(dtoSalesOffer.getToDate());
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoSalesOffer.getCustomer())) {
            this.setTargetId(UUID.fromString(dtoSalesOffer.getCustomer().getId()));
        } else {
            this.setTargetId(null);
        }
        this.setInvoiceClassification((POSInvoiceClassification)this.fromReference(dtoSalesOffer.getInvoiceClassification()));
        this.setMaxInvoiceValue(dtoInvoiceFreeItemLine.getMaxInvoiceValue());
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoInvoiceFreeItemLine.getSubsidiary())) {
            this.setSubsidiaryType(dtoInvoiceFreeItemLine.getSubsidiary().getEntityType());
            this.setSubsidiaryId(ServerStringUtils.strToUUID((String)dtoInvoiceFreeItemLine.getSubsidiary().getId()));
        } else {
            this.setSubsidiaryType(null);
            this.setSubsidiaryId(null);
        }
    }

    @Override
    public POSDimInfo getLegalEntity() {
        return this.legalEntity;
    }

    @Override
    public POSGenericDims fetchGenericDims() {
        return new POSGenericDims(this.getLegalEntity(), this.getSector(), this.getBranch(), this.getDepartment(), this.getAnalysisSet());
    }

    @Override
    public void setLegalEntity(POSDimInfo legalEntity) {
        this.legalEntity = legalEntity;
    }

    @Override
    public POSDimInfo getSector() {
        return this.sector;
    }

    @Override
    public void setSector(POSDimInfo sector) {
        this.sector = sector;
    }

    @Override
    public POSDimInfo getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(POSDimInfo branch) {
        this.branch = branch;
    }

    @Override
    public POSDimInfo getDepartment() {
        return this.department;
    }

    @Override
    public void setDepartment(POSDimInfo department) {
        this.department = department;
    }

    @Override
    public POSDimInfo getAnalysisSet() {
        return this.analysisSet;
    }

    @Override
    public void setAnalysisSet(POSDimInfo analysisSet) {
        this.analysisSet = analysisSet;
    }

    @Override
    public BigDecimal fetchPerValue() {
        return this.getMinInvoiceValue();
    }

    public BigDecimal getMaxInvoiceValue() {
        return this.maxInvoiceValue;
    }

    public void setMaxInvoiceValue(BigDecimal maxInvoiceValue) {
        this.maxInvoiceValue = maxInvoiceValue;
    }
}

