/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.supplychain.contracts.details.DTOItemDiscountLine;
import com.namasoft.modules.supplychain.contracts.entities.DTOSalesOffers;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsSCPriceListSysLine;
import com.namasoft.pos.domain.details.POSSalesPriceListLine;
import com.namasoft.pos.domain.entities.IHasPOSItemClasses;
import com.namasoft.pos.domain.entities.IPOSOfferSysLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemBrand;
import com.namasoft.pos.domain.entities.POSItemCategory;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass10;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemClass3;
import com.namasoft.pos.domain.entities.POSItemClass4;
import com.namasoft.pos.domain.entities.POSItemClass5;
import com.namasoft.pos.domain.entities.POSItemClass6;
import com.namasoft.pos.domain.entities.POSItemClass7;
import com.namasoft.pos.domain.entities.POSItemClass8;
import com.namasoft.pos.domain.entities.POSItemClass9;
import com.namasoft.pos.domain.entities.POSItemSection;
import com.namasoft.pos.domain.entities.POSSalesOffers;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.valueobjects.POSEntityRefData;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.util.IHasMaxQty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@Entity
public class POSItemDiscountLine
extends AbsSCPriceListSysLine
implements IHasPOSItemClasses,
IPOSOfferSysLine,
IHasMaxQty {
    @JoinColumn(name="salesOffer_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesOffers salesOffer;
    @Column(precision=20, scale=10)
    private BigDecimal discountDefaultValue;
    @Column(precision=20, scale=10)
    private BigDecimal discountMaxValue;
    @Column(precision=20, scale=10)
    private BigDecimal discountMinValue;
    private Boolean specialDiscount;
    private Boolean stopOtherDiscounts;
    private String relatedItems;
    private Long priority;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemBrand brand;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category5;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass1 itemClass1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass2 itemClass2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass3 itemClass3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass4 itemClass4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass5 itemClass5;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass6 itemClass6;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass7 itemClass7;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass8 itemClass8;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass9 itemClass9;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass10 itemClass10;
    private Boolean deactivateEmpDiscValidations;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItem item;
    private String discountLocation;
    private String valueOrPercent;
    private Boolean stopSameTypeOtherDiscounts;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemSection section;
    @Column(precision=20, scale=10)
    private BigDecimal minItemValueToApplyDiscount;
    @Column(precision=20, scale=10)
    private BigDecimal maxItemValueToApplyDiscount;
    @Column(precision=20, scale=10)
    private BigDecimal minInvValueToApplyDiscount;
    @Column(precision=20, scale=10)
    private BigDecimal maxInvValueToApplyDiscount;
    private Date fromTime;
    private Date toTime;
    @Column(precision=20, scale=10)
    private BigDecimal maxQty;

    public Date getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(Date fromTime) {
        this.fromTime = fromTime;
    }

    public Date getToTime() {
        return this.toTime;
    }

    public void setToTime(Date toTime) {
        this.toTime = toTime;
    }

    public BigDecimal getMinInvValueToApplyDiscount() {
        return this.minInvValueToApplyDiscount;
    }

    public void setMinInvValueToApplyDiscount(BigDecimal minInvValueToApplyDiscount) {
        this.minInvValueToApplyDiscount = minInvValueToApplyDiscount;
    }

    public BigDecimal getMaxInvValueToApplyDiscount() {
        return this.maxInvValueToApplyDiscount;
    }

    public void setMaxInvValueToApplyDiscount(BigDecimal maxInvValueToApplyDiscount) {
        this.maxInvValueToApplyDiscount = maxInvValueToApplyDiscount;
    }

    public POSItemSection getSection() {
        this.section = POSPersister.materialize(POSItemSection.class, this.section);
        return this.section;
    }

    public void setSection(POSItemSection section) {
        this.section = section;
    }

    public BigDecimal getMinItemValueToApplyDiscount() {
        return this.minItemValueToApplyDiscount;
    }

    public void setMinItemValueToApplyDiscount(BigDecimal minItemValueToApplyDiscount) {
        this.minItemValueToApplyDiscount = minItemValueToApplyDiscount;
    }

    public BigDecimal getMaxItemValueToApplyDiscount() {
        return this.maxItemValueToApplyDiscount;
    }

    public void setMaxItemValueToApplyDiscount(BigDecimal maxItemValueToApplyDiscount) {
        this.maxItemValueToApplyDiscount = maxItemValueToApplyDiscount;
    }

    public Boolean getStopSameTypeOtherDiscounts() {
        return this.stopSameTypeOtherDiscounts;
    }

    public void setStopSameTypeOtherDiscounts(Boolean stopSameTypeOtherDiscounts) {
        this.stopSameTypeOtherDiscounts = stopSameTypeOtherDiscounts;
    }

    @Override
    public POSItemClass1 getItemClass1() {
        this.itemClass1 = POSPersister.materialize(POSItemClass1.class, this.itemClass1);
        return this.itemClass1;
    }

    public void setItemClass1(POSItemClass1 itemClass1) {
        this.itemClass1 = itemClass1;
    }

    @Override
    public POSItemClass2 getItemClass2() {
        this.itemClass2 = POSPersister.materialize(POSItemClass2.class, this.itemClass2);
        return this.itemClass2;
    }

    public void setItemClass2(POSItemClass2 itemClass2) {
        this.itemClass2 = itemClass2;
    }

    @Override
    public POSItemClass3 getItemClass3() {
        this.itemClass3 = POSPersister.materialize(POSItemClass3.class, this.itemClass3);
        return this.itemClass3;
    }

    public void setItemClass3(POSItemClass3 itemClass3) {
        this.itemClass3 = itemClass3;
    }

    @Override
    public POSItemClass4 getItemClass4() {
        this.itemClass4 = POSPersister.materialize(POSItemClass4.class, this.itemClass4);
        return this.itemClass4;
    }

    public void setItemClass4(POSItemClass4 itemClass4) {
        this.itemClass4 = itemClass4;
    }

    @Override
    public POSItemClass5 getItemClass5() {
        this.itemClass5 = POSPersister.materialize(POSItemClass5.class, this.itemClass5);
        return this.itemClass5;
    }

    public void setItemClass5(POSItemClass5 itemClass5) {
        this.itemClass5 = itemClass5;
    }

    @Override
    public POSItemClass6 getItemClass6() {
        this.itemClass6 = POSPersister.materialize(POSItemClass6.class, this.itemClass6);
        return this.itemClass6;
    }

    public void setItemClass6(POSItemClass6 itemClass6) {
        this.itemClass6 = itemClass6;
    }

    @Override
    public POSItemClass7 getItemClass7() {
        this.itemClass7 = POSPersister.materialize(POSItemClass7.class, this.itemClass7);
        return this.itemClass7;
    }

    public void setItemClass7(POSItemClass7 itemClass7) {
        this.itemClass7 = itemClass7;
    }

    @Override
    public POSItemClass8 getItemClass8() {
        this.itemClass8 = POSPersister.materialize(POSItemClass8.class, this.itemClass8);
        return this.itemClass8;
    }

    public void setItemClass8(POSItemClass8 itemClass8) {
        this.itemClass8 = itemClass8;
    }

    @Override
    public POSItemClass9 getItemClass9() {
        this.itemClass9 = POSPersister.materialize(POSItemClass9.class, this.itemClass9);
        return this.itemClass9;
    }

    public void setItemClass9(POSItemClass9 itemClass9) {
        this.itemClass9 = itemClass9;
    }

    @Override
    public POSItemClass10 getItemClass10() {
        this.itemClass10 = POSPersister.materialize(POSItemClass10.class, this.itemClass10);
        return this.itemClass10;
    }

    public void setItemClass10(POSItemClass10 itemClass10) {
        this.itemClass10 = itemClass10;
    }

    public BigDecimal getDiscountDefaultValue() {
        return this.discountDefaultValue;
    }

    public void setDiscountDefaultValue(BigDecimal discountDefaultValue) {
        this.discountDefaultValue = discountDefaultValue;
    }

    public BigDecimal getDiscountMaxValue() {
        return this.discountMaxValue;
    }

    public void setDiscountMaxValue(BigDecimal discountMaxValue) {
        this.discountMaxValue = discountMaxValue;
    }

    public BigDecimal getDiscountMinValue() {
        return this.discountMinValue;
    }

    public void setDiscountMinValue(BigDecimal discountMinValue) {
        this.discountMinValue = discountMinValue;
    }

    public Boolean getSpecialDiscount() {
        return this.specialDiscount;
    }

    public void setSpecialDiscount(Boolean specialDiscount) {
        this.specialDiscount = specialDiscount;
    }

    public POSItem getItem() {
        this.item = POSPersister.materialize(POSItem.class, this.item);
        return this.item;
    }

    public void setItem(POSItem item) {
        this.item = item;
    }

    public String getDiscountLocation() {
        return this.discountLocation;
    }

    public void setDiscountLocation(String discountLocation) {
        this.discountLocation = discountLocation;
    }

    public String getValueOrPercent() {
        return this.valueOrPercent;
    }

    public void setValueOrPercent(String valueOrPercent) {
        this.valueOrPercent = valueOrPercent;
    }

    public POSSalesOffers getSalesOffer() {
        this.salesOffer = POSPersister.materialize(POSSalesOffers.class, this.salesOffer);
        return this.salesOffer;
    }

    public void setSalesOffer(POSSalesOffers offer) {
        this.salesOffer = offer;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public void updateData(DTOItemDiscountLine dtoItemDiscountSysLine, DTOSalesOffers offer, int i) {
        this.setId(UUID.fromString(dtoItemDiscountSysLine.getId()));
        this.setItem((POSItem)this.fromReference(dtoItemDiscountSysLine.getItem()));
        this.setDiscountDefaultValue(dtoItemDiscountSysLine.getDiscountDefaultValue());
        this.setDiscountLocation(dtoItemDiscountSysLine.getDiscountLocation());
        this.setDiscountMaxValue(dtoItemDiscountSysLine.getDiscountMaxValue());
        this.setDiscountMinValue(dtoItemDiscountSysLine.getDiscountMinValue());
        this.setFromDate(dtoItemDiscountSysLine.getFromDate());
        this.setToDate(dtoItemDiscountSysLine.getToDate());
        this.setSpecialDiscount(dtoItemDiscountSysLine.getSpecialDiscount());
        this.setValueOrPercent(dtoItemDiscountSysLine.getValueOrPercent());
        this.setQty(POSQuantity.fromDTORawQuantity(dtoItemDiscountSysLine.getQty(), this));
        this.setMaxQty(dtoItemDiscountSysLine.getMaxQty());
        this.setDiscountDefaultValue(dtoItemDiscountSysLine.getDiscountDefaultValue());
        this.setDiscountMaxValue(dtoItemDiscountSysLine.getDiscountMaxValue());
        this.setDiscountMinValue(dtoItemDiscountSysLine.getDiscountMinValue());
        this.setDiscountLocation(dtoItemDiscountSysLine.getDiscountLocation());
        this.setSpecialDiscount(dtoItemDiscountSysLine.getSpecialDiscount());
        this.setStopOtherDiscounts(offer.getStopOtherDiscounts());
        this.setValueOrPercent(dtoItemDiscountSysLine.getValueOrPercent());
        this.setCategory1((POSItemCategory)this.fromReference(dtoItemDiscountSysLine.getCategory1()));
        this.setCategory2((POSItemCategory)this.fromReference(dtoItemDiscountSysLine.getCategory2()));
        this.setCategory3((POSItemCategory)this.fromReference(dtoItemDiscountSysLine.getCategory3()));
        this.setCategory4((POSItemCategory)this.fromReference(dtoItemDiscountSysLine.getCategory4()));
        this.setCategory5((POSItemCategory)this.fromReference(dtoItemDiscountSysLine.getCategory5()));
        this.setPriority(offer.getPriority());
        this.setBrand((POSItemBrand)this.fromReference(dtoItemDiscountSysLine.getBrand()));
        this.setRelatedItems(ObjectChecker.isNotEmptyOrNull((Object)dtoItemDiscountSysLine.getRelatedItems()) ? dtoItemDiscountSysLine.getRelatedItems().getId() : "");
        this.setDeactivateEmpDiscValidations(ObjectChecker.isEmptyOrNull((Object)offer.getDeactivateEmpDiscValidations()) ? false : offer.getDeactivateEmpDiscValidations());
        this.setCurrency((POSCurrency)this.fromReference(offer.getCurrency()));
        this.setItemID(ObjectChecker.isEmptyOrNull((Object)dtoItemDiscountSysLine.getItem()) ? null : ServerStringUtils.strToUUID((String)dtoItemDiscountSysLine.getItem().getId()));
        this.setItemDimensions(POSItemSpecificDimensions.fromDTOItemSpecificDimensions(dtoItemDiscountSysLine.getItemDimensions()));
        this.setLineNumber(i);
        this.setRefId(ServerStringUtils.strToUUID((String)offer.getId()));
        this.setInvoiceClassification((POSInvoiceClassification)this.fromReference(offer.getInvoiceClassification()));
        if (ObjectChecker.isNotEmptyOrNull((Object)offer.getCustomer())) {
            this.setTargetId(UUID.fromString(offer.getCustomer().getId()));
            this.setTargetType(offer.getCustomer().getEntityType());
        } else {
            this.setTargetId(null);
            this.setTargetType(null);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)offer.getEmployee())) {
            this.setEmpTargetId(UUID.fromString(offer.getEmployee().getId()));
            this.setEmpTargetType(offer.getEmployee().getEntityType());
        } else {
            this.setEmpTargetId(null);
            this.setEmpTargetType(null);
        }
        this.setPriceClassifier1((POSSalesPriceClassifier1)this.fromReference(dtoItemDiscountSysLine.getPriceClassifier1()));
        this.setPriceClassifier2((POSSalesPriceClassifier2)this.fromReference(dtoItemDiscountSysLine.getPriceClassifier2()));
        this.setPriceClassifier3((POSSalesPriceClassifier3)this.fromReference(dtoItemDiscountSysLine.getPriceClassifier3()));
        this.setPriceClassifier4((POSSalesPriceClassifier4)this.fromReference(dtoItemDiscountSysLine.getPriceClassifier4()));
        this.setPriceClassifier5((POSSalesPriceClassifier5)this.fromReference(dtoItemDiscountSysLine.getPriceClassifier5()));
        this.setItemClass1((POSItemClass1)this.fromReference(dtoItemDiscountSysLine.getItemClass1()));
        this.setItemClass2((POSItemClass2)this.fromReference(dtoItemDiscountSysLine.getItemClass2()));
        this.setItemClass3((POSItemClass3)this.fromReference(dtoItemDiscountSysLine.getItemClass3()));
        this.setItemClass4((POSItemClass4)this.fromReference(dtoItemDiscountSysLine.getItemClass4()));
        this.setItemClass5((POSItemClass5)this.fromReference(dtoItemDiscountSysLine.getItemClass5()));
        this.setItemClass6((POSItemClass6)this.fromReference(dtoItemDiscountSysLine.getItemClass6()));
        this.setItemClass7((POSItemClass7)this.fromReference(dtoItemDiscountSysLine.getItemClass7()));
        this.setItemClass8((POSItemClass8)this.fromReference(dtoItemDiscountSysLine.getItemClass8()));
        this.setItemClass9((POSItemClass9)this.fromReference(dtoItemDiscountSysLine.getItemClass9()));
        this.setItemClass10((POSItemClass10)this.fromReference(dtoItemDiscountSysLine.getItemClass10()));
        POSSalesPriceListLine.updatePOSLineDimensions(this, dtoItemDiscountSysLine.getDimensions());
        this.setStopSameTypeOtherDiscounts(dtoItemDiscountSysLine.getStopSameTypeOtherDiscounts());
        this.setSection((POSItemSection)this.fromReference(dtoItemDiscountSysLine.getSection()));
        this.setMinItemValueToApplyDiscount(dtoItemDiscountSysLine.getMinItemValueToApplyDiscount());
        this.setMaxItemValueToApplyDiscount(dtoItemDiscountSysLine.getMaxItemValueToApplyDiscount());
        this.setMinInvValueToApplyDiscount(dtoItemDiscountSysLine.getMinInvValueToApplyDiscount());
        this.setMaxInvValueToApplyDiscount(dtoItemDiscountSysLine.getMaxInvValueToApplyDiscount());
        this.setNegateQtyInBaseUOM(ObjectChecker.toZeroIfNull((BigDecimal)dtoItemDiscountSysLine.getQtyInBaseUOM()).negate());
        this.setFromTime(dtoItemDiscountSysLine.getFromTime());
        this.setToTime(dtoItemDiscountSysLine.getToTime());
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoItemDiscountSysLine.getSubsidiary())) {
            this.setSubsidiaryType(dtoItemDiscountSysLine.getSubsidiary().getEntityType());
            this.setSubsidiaryId(ServerStringUtils.strToUUID((String)dtoItemDiscountSysLine.getSubsidiary().getId()));
        } else {
            this.setSubsidiaryType(null);
            this.setSubsidiaryId(null);
        }
        this.setApplyOnlyIfItemInInvoice((POSFreeItemGroup)this.fromReference(dtoItemDiscountSysLine.getApplyOnlyIfItemInInvoice()));
        this.setApplyOnItems(POSEntityRefData.fromEntityRefData(dtoItemDiscountSysLine.getApplyOnItems()));
    }

    @Override
    public Boolean getStopOtherDiscounts() {
        return this.stopOtherDiscounts;
    }

    public void setStopOtherDiscounts(Boolean stopOtherDiscounts) {
        this.stopOtherDiscounts = stopOtherDiscounts;
    }

    public String getRelatedItems() {
        return this.relatedItems;
    }

    public void setRelatedItems(String relatedItems) {
        this.relatedItems = relatedItems;
    }

    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public POSItemBrand getBrand() {
        this.brand = POSPersister.materialize(POSItemBrand.class, this.brand);
        return this.brand;
    }

    public void setBrand(POSItemBrand brand) {
        this.brand = brand;
    }

    public POSItemCategory getCategory1() {
        this.category1 = POSPersister.materialize(POSItemCategory.class, this.category1);
        return this.category1;
    }

    public void setCategory1(POSItemCategory category1) {
        this.category1 = category1;
    }

    public POSItemCategory getCategory2() {
        this.category2 = POSPersister.materialize(POSItemCategory.class, this.category2);
        return this.category2;
    }

    public void setCategory2(POSItemCategory category2) {
        this.category2 = category2;
    }

    public POSItemCategory getCategory3() {
        this.category3 = POSPersister.materialize(POSItemCategory.class, this.category3);
        return this.category3;
    }

    public void setCategory3(POSItemCategory category3) {
        this.category3 = category3;
    }

    public POSItemCategory getCategory4() {
        this.category4 = POSPersister.materialize(POSItemCategory.class, this.category4);
        return this.category4;
    }

    public void setCategory4(POSItemCategory category4) {
        this.category4 = category4;
    }

    public POSItemCategory getCategory5() {
        this.category5 = POSPersister.materialize(POSItemCategory.class, this.category5);
        return this.category5;
    }

    public void setCategory5(POSItemCategory category5) {
        this.category5 = category5;
    }

    public BigDecimal getMaxQty() {
        return this.maxQty;
    }

    public void setMaxQty(BigDecimal maxQty) {
        this.maxQty = maxQty;
    }

    public Boolean getDeactivateEmpDiscValidations() {
        return this.deactivateEmpDiscValidations;
    }

    public void setDeactivateEmpDiscValidations(Boolean deactivateEmpDiscValidations) {
        this.deactivateEmpDiscValidations = deactivateEmpDiscValidations;
    }

    @Override
    public Boolean fetchStopSameTypeOtherDiscounts() {
        return this.getStopSameTypeOtherDiscounts();
    }

    @Override
    public String fetchDiscountLocation() {
        return this.getDiscountLocation();
    }

    @Override
    public Long fetchPriority() {
        return ObjectChecker.toZeroIfNull((Long)this.getPriority());
    }

    @Override
    public BigDecimal fetchMaxQty() {
        return this.getMaxQty();
    }
}

