/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.details.AbsPOSSpecialItemCode;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSUnit;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlTransient;
import java.math.BigDecimal;

@Entity
public class POSItemUnit
extends AbsPOSSpecialItemCode {
    @ManyToOne(fetch=FetchType.LAZY)
    private POSUnit unit;
    @Column(precision=20, scale=10)
    private BigDecimal rateToBase;
    @Column(precision=20, scale=10)
    private BigDecimal defaultPrice;
    @Column(precision=20, scale=10)
    private BigDecimal minPrice;
    @Column(precision=20, scale=10)
    private BigDecimal maxPrice;

    @Override
    @XmlTransient
    @JsonIgnore
    public POSItem getPosItem() {
        return this.getPosItem();
    }

    public POSUnit getUnit() {
        this.unit = POSPersister.materialize(POSUnit.class, this.unit);
        return this.unit;
    }

    public void setUnit(POSUnit unit) {
        this.unit = unit;
    }

    public BigDecimal getReteToBase() {
        return this.rateToBase;
    }

    public void setReteToBase(BigDecimal reteToBase) {
        this.rateToBase = reteToBase;
    }

    public BigDecimal getDefaultPrice() {
        return this.defaultPrice;
    }

    public void setDefaultPrice(BigDecimal defaultPrice) {
        this.defaultPrice = defaultPrice;
    }

    public BigDecimal getMinPrice() {
        return this.minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public BigDecimal getMaxPrice() {
        return this.maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }
}

