/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSTaxPlan;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@Entity
public class POSLegalEntityTax {
    @JoinColumn(name="posTax")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSTaxPlan posTax;
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="legalEntityId")), @AttributeOverride(name="code", column=@Column(name="legalEntityCode"))})
    private POSDimInfo legalEntity;
    @Column(precision=20, scale=10)
    private BigDecimal tax1;
    @Column(precision=20, scale=10)
    private BigDecimal tax2;
    private Date effectiveFrom;
    private Date effectiveTo;
    private String entityType;
    private String entityTypeList;

    public POSTaxPlan getPosTax() {
        this.posTax = POSPersister.materialize(POSTaxPlan.class, this.posTax);
        return this.posTax;
    }

    public void setPosTax(POSTaxPlan posTax) {
        this.posTax = posTax;
    }

    public POSDimInfo getLegalEntity() {
        return this.legalEntity;
    }

    public void setLegalEntity(POSDimInfo legalEntity) {
        this.legalEntity = legalEntity;
    }

    public BigDecimal getTax1() {
        return this.tax1;
    }

    public void setTax1(BigDecimal tax1) {
        this.tax1 = tax1;
    }

    public BigDecimal getTax2() {
        return this.tax2;
    }

    public void setTax2(BigDecimal tax2) {
        this.tax2 = tax2;
    }

    public Date getEffectiveFrom() {
        return this.effectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
    }

    public Date getEffectiveTo() {
        return this.effectiveTo;
    }

    public void setEffectiveTo(Date effectiveTo) {
        this.effectiveTo = effectiveTo;
    }

    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getEntityTypeList() {
        return this.entityTypeList;
    }

    public void setEntityTypeList(String entityTypeList) {
        this.entityTypeList = entityTypeList;
    }
}

