/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.supplychain.contracts.details.DTOOfferOnItemsCountLine;
import com.namasoft.modules.supplychain.contracts.entities.DTOSalesOffers;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.IHasPOSItemClasses;
import com.namasoft.pos.domain.entities.IPOSOfferSysLine;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItemBrand;
import com.namasoft.pos.domain.entities.POSItemCategory;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass10;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemClass3;
import com.namasoft.pos.domain.entities.POSItemClass4;
import com.namasoft.pos.domain.entities.POSItemClass5;
import com.namasoft.pos.domain.entities.POSItemClass6;
import com.namasoft.pos.domain.entities.POSItemClass7;
import com.namasoft.pos.domain.entities.POSItemClass8;
import com.namasoft.pos.domain.entities.POSItemClass9;
import com.namasoft.pos.domain.entities.POSItemSection;
import com.namasoft.pos.domain.entities.POSSalesOffers;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@Entity
public class POSOfferOnItemsCountLine
implements POSSavable,
IHasPOSItemClasses,
IPOSOfferSysLine {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    private Boolean ignoreOtherOffers;
    private Date fromDate;
    private Date toDate;
    private Integer numOfInvoiceItems;
    private String freeItemClassification;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSFreeItemGroup freeItemGroup;
    private Long priority;
    private String freePolicy;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category5;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemBrand brand;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemSection section;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSFreeItemGroup itemsGroup;
    private String itemsCountMechanism;
    private String multiplePolicyMechanism;
    @JoinColumn(name="salesOffer_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesOffers salesOffer;
    private Integer multiplies;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass1 itemClass1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass2 itemClass2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass3 itemClass3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass4 itemClass4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass5 itemClass5;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass6 itemClass6;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass7 itemClass7;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass8 itemClass8;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass9 itemClass9;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass10 itemClass10;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier1 priceClassifier1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier2 priceClassifier2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier3 priceClassifier3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier4 priceClassifier4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier5 priceClassifier5;
    @Column(length=16)
    private UUID targetId;
    private String targetType;
    @Column(length=16)
    private UUID empTargetId;
    private String empTargetType;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSInvoiceClassification invoiceClassification;
    private Boolean stopOtherDiscounts;
    @Column(length=16)
    private UUID refId;
    @Column(precision=20, scale=10)
    private BigDecimal freeItemQty;
    @Lob
    private String srcLinesNumbers;
    private Boolean notFreeButDiscount;
    private String discLocation;
    @Column(precision=20, scale=10)
    private BigDecimal discountPercentage;
    private Boolean ignoreMatchedItemToBeFreeQty;
    @Column(length=16)
    private UUID subsidiaryId;
    private String subsidiaryType;

    public UUID getSubsidiaryId() {
        return this.subsidiaryId;
    }

    public void setSubsidiaryId(UUID subsidiaryId) {
        this.subsidiaryId = subsidiaryId;
    }

    @Override
    public String getSubsidiaryType() {
        return this.subsidiaryType;
    }

    public void setSubsidiaryType(String subsidiaryType) {
        this.subsidiaryType = subsidiaryType;
    }

    public Boolean getIgnoreMatchedItemToBeFreeQty() {
        return this.ignoreMatchedItemToBeFreeQty;
    }

    public void setIgnoreMatchedItemToBeFreeQty(Boolean ignoreMatchedItemToBeFreeQty) {
        this.ignoreMatchedItemToBeFreeQty = ignoreMatchedItemToBeFreeQty;
    }

    public Boolean getNotFreeButDiscount() {
        return this.notFreeButDiscount;
    }

    public void setNotFreeButDiscount(Boolean notFreeButDiscount) {
        this.notFreeButDiscount = notFreeButDiscount;
    }

    public String getDiscLocation() {
        return this.discLocation;
    }

    public void setDiscLocation(String discLocation) {
        this.discLocation = discLocation;
    }

    public BigDecimal getDiscountPercentage() {
        return this.discountPercentage;
    }

    public void setDiscountPercentage(BigDecimal discountPercentage) {
        this.discountPercentage = discountPercentage;
    }

    public String getSrcLinesNumbers() {
        return this.srcLinesNumbers;
    }

    public void setSrcLinesNumbers(String srcLinesNumbers) {
        this.srcLinesNumbers = srcLinesNumbers;
    }

    public BigDecimal getFreeItemQty() {
        return this.freeItemQty;
    }

    public void setFreeItemQty(BigDecimal freeItemQty) {
        this.freeItemQty = freeItemQty;
    }

    public UUID getTargetId() {
        return this.targetId;
    }

    public void setTargetId(UUID targetId) {
        this.targetId = targetId;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public UUID getEmpTargetId() {
        return this.empTargetId;
    }

    public void setEmpTargetId(UUID empTargetId) {
        this.empTargetId = empTargetId;
    }

    public String getEmpTargetType() {
        return this.empTargetType;
    }

    public void setEmpTargetType(String empTargetType) {
        this.empTargetType = empTargetType;
    }

    public POSInvoiceClassification getInvoiceClassification() {
        this.invoiceClassification = POSPersister.materialize(POSInvoiceClassification.class, this.invoiceClassification);
        return this.invoiceClassification;
    }

    public void setInvoiceClassification(POSInvoiceClassification invoiceClassification) {
        this.invoiceClassification = invoiceClassification;
    }

    public POSSalesPriceClassifier1 getPriceClassifier1() {
        this.priceClassifier1 = POSPersister.materialize(POSSalesPriceClassifier1.class, this.priceClassifier1);
        return this.priceClassifier1;
    }

    public void setPriceClassifier1(POSSalesPriceClassifier1 priceClassifier1) {
        this.priceClassifier1 = priceClassifier1;
    }

    public POSSalesPriceClassifier2 getPriceClassifier2() {
        this.priceClassifier2 = POSPersister.materialize(POSSalesPriceClassifier2.class, this.priceClassifier2);
        return this.priceClassifier2;
    }

    public void setPriceClassifier2(POSSalesPriceClassifier2 priceClassifier2) {
        this.priceClassifier2 = priceClassifier2;
    }

    public POSSalesPriceClassifier3 getPriceClassifier3() {
        this.priceClassifier3 = POSPersister.materialize(POSSalesPriceClassifier3.class, this.priceClassifier3);
        return this.priceClassifier3;
    }

    public void setPriceClassifier3(POSSalesPriceClassifier3 priceClassifier3) {
        this.priceClassifier3 = priceClassifier3;
    }

    public POSSalesPriceClassifier4 getPriceClassifier4() {
        this.priceClassifier4 = POSPersister.materialize(POSSalesPriceClassifier4.class, this.priceClassifier4);
        return this.priceClassifier4;
    }

    public void setPriceClassifier4(POSSalesPriceClassifier4 priceClassifier4) {
        this.priceClassifier4 = priceClassifier4;
    }

    public POSSalesPriceClassifier5 getPriceClassifier5() {
        this.priceClassifier5 = POSPersister.materialize(POSSalesPriceClassifier5.class, this.priceClassifier5);
        return this.priceClassifier5;
    }

    public void setPriceClassifier5(POSSalesPriceClassifier5 priceClassifier5) {
        this.priceClassifier5 = priceClassifier5;
    }

    @Override
    public POSItemClass1 getItemClass1() {
        this.itemClass1 = POSPersister.materialize(POSItemClass1.class, this.itemClass1);
        return this.itemClass1;
    }

    public void setItemClass1(POSItemClass1 itemClass1) {
        this.itemClass1 = itemClass1;
    }

    @Override
    public POSItemClass2 getItemClass2() {
        this.itemClass2 = POSPersister.materialize(POSItemClass2.class, this.itemClass2);
        return this.itemClass2;
    }

    public void setItemClass2(POSItemClass2 itemClass2) {
        this.itemClass2 = itemClass2;
    }

    @Override
    public POSItemClass3 getItemClass3() {
        this.itemClass3 = POSPersister.materialize(POSItemClass3.class, this.itemClass3);
        return this.itemClass3;
    }

    public void setItemClass3(POSItemClass3 itemClass3) {
        this.itemClass3 = itemClass3;
    }

    @Override
    public POSItemClass4 getItemClass4() {
        this.itemClass4 = POSPersister.materialize(POSItemClass4.class, this.itemClass4);
        return this.itemClass4;
    }

    public void setItemClass4(POSItemClass4 itemClass4) {
        this.itemClass4 = itemClass4;
    }

    @Override
    public POSItemClass5 getItemClass5() {
        this.itemClass5 = POSPersister.materialize(POSItemClass5.class, this.itemClass5);
        return this.itemClass5;
    }

    public void setItemClass5(POSItemClass5 itemClass5) {
        this.itemClass5 = itemClass5;
    }

    @Override
    public POSItemClass6 getItemClass6() {
        this.itemClass6 = POSPersister.materialize(POSItemClass6.class, this.itemClass6);
        return this.itemClass6;
    }

    public void setItemClass6(POSItemClass6 itemClass6) {
        this.itemClass6 = itemClass6;
    }

    @Override
    public POSItemClass7 getItemClass7() {
        this.itemClass7 = POSPersister.materialize(POSItemClass7.class, this.itemClass7);
        return this.itemClass7;
    }

    public void setItemClass7(POSItemClass7 itemClass7) {
        this.itemClass7 = itemClass7;
    }

    @Override
    public POSItemClass8 getItemClass8() {
        this.itemClass8 = POSPersister.materialize(POSItemClass8.class, this.itemClass8);
        return this.itemClass8;
    }

    public void setItemClass8(POSItemClass8 itemClass8) {
        this.itemClass8 = itemClass8;
    }

    @Override
    public POSItemClass9 getItemClass9() {
        this.itemClass9 = POSPersister.materialize(POSItemClass9.class, this.itemClass9);
        return this.itemClass9;
    }

    public void setItemClass9(POSItemClass9 itemClass9) {
        this.itemClass9 = itemClass9;
    }

    @Override
    public POSItemClass10 getItemClass10() {
        this.itemClass10 = POSPersister.materialize(POSItemClass10.class, this.itemClass10);
        return this.itemClass10;
    }

    public void setItemClass10(POSItemClass10 itemClass10) {
        this.itemClass10 = itemClass10;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public Boolean getIgnoreOtherOffers() {
        return this.ignoreOtherOffers;
    }

    public void setIgnoreOtherOffers(Boolean ignoreOtherOffers) {
        this.ignoreOtherOffers = ignoreOtherOffers;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Integer getNumOfInvoiceItems() {
        return this.numOfInvoiceItems;
    }

    public void setNumOfInvoiceItems(Integer numOfInvoiceItems) {
        this.numOfInvoiceItems = numOfInvoiceItems;
    }

    public String getFreeItemClassification() {
        return this.freeItemClassification;
    }

    public void setFreeItemClassification(String freeItemClassification) {
        this.freeItemClassification = freeItemClassification;
    }

    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public String getFreePolicy() {
        return this.freePolicy;
    }

    public void setFreePolicy(String freePolicy) {
        this.freePolicy = freePolicy;
    }

    public POSItemCategory getCategory1() {
        this.category1 = POSPersister.materialize(POSItemCategory.class, this.category1);
        return this.category1;
    }

    public void setCategory1(POSItemCategory category1) {
        this.category1 = category1;
    }

    public POSItemCategory getCategory2() {
        this.category2 = POSPersister.materialize(POSItemCategory.class, this.category2);
        return this.category2;
    }

    public void setCategory2(POSItemCategory category2) {
        this.category2 = category2;
    }

    public POSItemCategory getCategory3() {
        this.category3 = POSPersister.materialize(POSItemCategory.class, this.category3);
        return this.category3;
    }

    public void setCategory3(POSItemCategory category3) {
        this.category3 = category3;
    }

    public POSItemCategory getCategory4() {
        this.category4 = POSPersister.materialize(POSItemCategory.class, this.category4);
        return this.category4;
    }

    public void setCategory4(POSItemCategory category4) {
        this.category4 = category4;
    }

    public POSItemCategory getCategory5() {
        this.category5 = POSPersister.materialize(POSItemCategory.class, this.category5);
        return this.category5;
    }

    public void setCategory5(POSItemCategory category5) {
        this.category5 = category5;
    }

    public POSItemBrand getBrand() {
        this.brand = POSPersister.materialize(POSItemBrand.class, this.brand);
        return this.brand;
    }

    public void setBrand(POSItemBrand brand) {
        this.brand = brand;
    }

    public POSItemSection getSection() {
        this.section = POSPersister.materialize(POSItemSection.class, this.section);
        return this.section;
    }

    public void setSection(POSItemSection section) {
        this.section = section;
    }

    public POSFreeItemGroup getItemsGroup() {
        this.itemsGroup = POSPersister.materialize(POSFreeItemGroup.class, this.itemsGroup);
        return this.itemsGroup;
    }

    public void setItemsGroup(POSFreeItemGroup itemsGroup) {
        this.itemsGroup = itemsGroup;
    }

    public String getItemsCountMechanism() {
        return this.itemsCountMechanism;
    }

    public void setItemsCountMechanism(String itemsCountMechanism) {
        this.itemsCountMechanism = itemsCountMechanism;
    }

    public void setMultiplePolicyMechanism(String multiplePolicyMechanism) {
        this.multiplePolicyMechanism = multiplePolicyMechanism;
    }

    public POSSalesOffers getSalesOffer() {
        this.salesOffer = POSPersister.materialize(POSSalesOffers.class, this.salesOffer);
        return this.salesOffer;
    }

    public void setSalesOffer(POSSalesOffers salesOffer) {
        this.salesOffer = salesOffer;
    }

    public void updateData(DTOOfferOnItemsCountLine offerLine, DTOSalesOffers offer) {
        this.setId(UUID.fromString(offerLine.getId()));
        this.setBrand((POSItemBrand)this.fromReference(offerLine.getBrand()));
        this.setCategory1((POSItemCategory)this.fromReference(offerLine.getCategory1()));
        this.setCategory2((POSItemCategory)this.fromReference(offerLine.getCategory2()));
        this.setCategory3((POSItemCategory)this.fromReference(offerLine.getCategory3()));
        this.setCategory4((POSItemCategory)this.fromReference(offerLine.getCategory4()));
        this.setCategory5((POSItemCategory)this.fromReference(offerLine.getCategory5()));
        this.setFreeItemClassification(offerLine.getFreeItemClassification());
        this.setFreePolicy(offerLine.getFreePolicy());
        this.setIgnoreOtherOffers(offerLine.getIgnoreOtherOffers());
        this.setFromDate(offerLine.getFromDate());
        this.setItemsCountMechanism(offerLine.getItemsCountMechanism());
        this.setItemsGroup((POSFreeItemGroup)this.fromReference(offerLine.getItemsGroup()));
        this.setMultiplePolicyMechanism(offerLine.getMultiplePolicyMechanism());
        this.setNumOfInvoiceItems(offerLine.getNumOfInvoiceItems());
        this.setPriority(offerLine.getPriority());
        this.setSection((POSItemSection)this.fromReference(offerLine.getSection()));
        this.setToDate(offerLine.getToDate());
        this.setItemClass1((POSItemClass1)this.fromReference(offerLine.getItemClass1()));
        this.setItemClass2((POSItemClass2)this.fromReference(offerLine.getItemClass2()));
        this.setItemClass3((POSItemClass3)this.fromReference(offerLine.getItemClass3()));
        this.setItemClass4((POSItemClass4)this.fromReference(offerLine.getItemClass4()));
        this.setItemClass5((POSItemClass5)this.fromReference(offerLine.getItemClass5()));
        this.setItemClass6((POSItemClass6)this.fromReference(offerLine.getItemClass6()));
        this.setItemClass7((POSItemClass7)this.fromReference(offerLine.getItemClass7()));
        this.setItemClass8((POSItemClass8)this.fromReference(offerLine.getItemClass8()));
        this.setItemClass9((POSItemClass9)this.fromReference(offerLine.getItemClass9()));
        this.setItemClass10((POSItemClass10)this.fromReference(offerLine.getItemClass10()));
        this.setPriceClassifier1((POSSalesPriceClassifier1)this.fromReference(offerLine.getPriceClassifier1()));
        this.setPriceClassifier2((POSSalesPriceClassifier2)this.fromReference(offerLine.getPriceClassifier2()));
        this.setPriceClassifier3((POSSalesPriceClassifier3)this.fromReference(offerLine.getPriceClassifier3()));
        this.setPriceClassifier4((POSSalesPriceClassifier4)this.fromReference(offerLine.getPriceClassifier4()));
        this.setPriceClassifier5((POSSalesPriceClassifier5)this.fromReference(offerLine.getPriceClassifier5()));
        this.setFreeItemGroup((POSFreeItemGroup)this.fromReference(offerLine.getFreeItemGroup()));
        this.setStopOtherDiscounts(offerLine.getStopOtherDiscounts());
        if (ObjectChecker.isNotEmptyOrNull((Object)offer.getCustomer())) {
            this.setTargetId(UUID.fromString(offer.getCustomer().getId()));
            this.setTargetType(offer.getCustomer().getEntityType());
        } else {
            this.setTargetId(null);
            this.setTargetType(null);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)offer.getEmployee())) {
            this.setEmpTargetId(UUID.fromString(offer.getEmployee().getId()));
            this.setEmpTargetType(offer.getEmployee().getEntityType());
        } else {
            this.setEmpTargetId(null);
            this.setEmpTargetType(null);
        }
        this.setInvoiceClassification((POSInvoiceClassification)this.fromReference(offer.getInvoiceClassification()));
        this.setRefId(ServerStringUtils.strToUUID((String)offer.getId()));
        this.setFreeItemQty(offerLine.getFreeItemQty());
        this.setNotFreeButDiscount(offerLine.getNotFreeButDiscount());
        this.setDiscLocation(offerLine.getDiscLocation());
        this.setDiscountPercentage(offerLine.getDiscountPercentage());
        this.setIgnoreMatchedItemToBeFreeQty(offerLine.getIgnoreMatchedItemToBeFreeQty());
        if (ObjectChecker.isNotEmptyOrNull((Object)offerLine.getSubsidiary())) {
            this.setSubsidiaryType(offerLine.getSubsidiary().getEntityType());
            this.setSubsidiaryId(ServerStringUtils.strToUUID((String)offerLine.getSubsidiary().getId()));
        } else {
            this.setSubsidiaryType(null);
            this.setSubsidiaryId(null);
        }
    }

    public Integer getMultiplies() {
        return this.multiplies;
    }

    public void setMultiplies(Integer multiplies) {
        this.multiplies = multiplies;
    }

    public POSFreeItemGroup getFreeItemGroup() {
        this.freeItemGroup = POSPersister.materialize(POSFreeItemGroup.class, this.freeItemGroup);
        return this.freeItemGroup;
    }

    public void setFreeItemGroup(POSFreeItemGroup freeItemGroup) {
        this.freeItemGroup = freeItemGroup;
    }

    @Override
    public Boolean getStopOtherDiscounts() {
        return this.stopOtherDiscounts;
    }

    public void setStopOtherDiscounts(Boolean stopOtherDiscounts) {
        this.stopOtherDiscounts = stopOtherDiscounts;
    }

    @Override
    public UUID getRefId() {
        return this.refId;
    }

    public void setRefId(UUID refId) {
        this.refId = refId;
    }
}

