/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.details.DTOPOSFavouriteItemLine;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSRegistery;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.UUID;

@Entity
public class POSRegisteryFavouriteLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="register_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSRegistery register;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItem item;
    @Column(length=16)
    private UUID favouritesLevel1Id;
    private String favouritesLevel1EntityType;
    private String favouritesLevel2;
    private String favouritesLevel3;
    private String favouritesLevel4;
    private String favouritesLevel5;

    public UUID getFavouritesLevel1Id() {
        return this.favouritesLevel1Id;
    }

    public void setFavouritesLevel1Id(UUID favouritesLevel1Id) {
        this.favouritesLevel1Id = favouritesLevel1Id;
    }

    public String getFavouritesLevel1EntityType() {
        return this.favouritesLevel1EntityType;
    }

    public void setFavouritesLevel1EntityType(String favouritesLevel1EntityType) {
        this.favouritesLevel1EntityType = favouritesLevel1EntityType;
    }

    public String getFavouritesLevel2() {
        return this.favouritesLevel2;
    }

    public void setFavouritesLevel2(String favouritesLevel2) {
        this.favouritesLevel2 = favouritesLevel2;
    }

    public String getFavouritesLevel3() {
        return this.favouritesLevel3;
    }

    public void setFavouritesLevel3(String favouritesLevel3) {
        this.favouritesLevel3 = favouritesLevel3;
    }

    public String getFavouritesLevel4() {
        return this.favouritesLevel4;
    }

    public void setFavouritesLevel4(String favouritesLevel4) {
        this.favouritesLevel4 = favouritesLevel4;
    }

    public String getFavouritesLevel5() {
        return this.favouritesLevel5;
    }

    public void setFavouritesLevel5(String favouritesLevel5) {
        this.favouritesLevel5 = favouritesLevel5;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    public POSRegisteryFavouriteLine() {
    }

    public POSRegisteryFavouriteLine(DTOPOSFavouriteItemLine object) {
        this.setItem((POSItem)this.fromReference(object.getInvItem()));
        EntityReferenceData favouritesLevel1 = object.getFavouritesLevel1();
        if (ObjectChecker.isNotEmptyOrNull((Object)favouritesLevel1)) {
            this.setFavouritesLevel1Id(UUID.fromString(favouritesLevel1.getId()));
            this.setFavouritesLevel1EntityType(favouritesLevel1.getEntityType());
        }
        this.setFavouritesLevel2(object.getFavouritesLevel2());
        this.setFavouritesLevel3(object.getFavouritesLevel3());
        this.setFavouritesLevel4(object.getFavouritesLevel4());
        this.setFavouritesLevel5(object.getFavouritesLevel5());
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public POSRegistery getRegister() {
        this.register = POSPersister.materialize(POSRegistery.class, this.register);
        return this.register;
    }

    public void setRegister(POSRegistery register) {
        this.register = register;
    }

    public POSItem getItem() {
        this.item = POSPersister.materialize(POSItem.class, this.item);
        return this.item;
    }

    public void setItem(POSItem item) {
        this.item = item;
    }

    @Override
    public void assignIds() {
        this.getId();
    }
}

