/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import java.sql.Blob;
import java.util.UUID;

@Entity
public class POSReportResource
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="mainReport_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSReportDefinition mainReport;
    private String resourceId;
    private Blob resourceFile;
    @Lob
    private String reportContent;
    private String reportFileName;

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public POSReportDefinition getMainReport() {
        this.mainReport = POSPersister.materialize(POSReportDefinition.class, this.mainReport);
        return this.mainReport;
    }

    public void setMainReport(POSReportDefinition mainReport) {
        this.mainReport = mainReport;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public Blob getResourceFile() {
        return this.resourceFile;
    }

    public void setResourceFile(Blob resourceFile) {
        this.resourceFile = resourceFile;
    }

    public String getReportContent() {
        return this.reportContent;
    }

    public void setReportContent(String reportContent) {
        this.reportContent = reportContent;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }
}

