/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.tablecells.POSSalesTableFields;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoiceLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSReturnReason;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.valueobjects.POSDiscountTax;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.util.POSSecurityUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlTransient;
import java.math.BigDecimal;
import java.util.UUID;

@Entity
public class POSSalesReturnLine
extends AbsPOSSalesLine
implements IPOSDocFromInvoiceLine {
    @JoinColumn(name="invoice_id")
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesReturn invoice;
    @Column(name="invoiceLineId", length=16)
    private UUID invoiceLineId;
    @JoinColumn(name="returnReason_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSReturnReason returnReason;

    @XmlTransient
    public POSSalesReturn getInvoice() {
        this.invoice = POSPersister.materialize(POSSalesReturn.class, this.invoice);
        return this.invoice;
    }

    public void setInvoice(POSSalesReturn invoice) {
        this.invoice = invoice;
    }

    public POSSalesReturnLine() {
        this.setItemDimensions(new POSItemSpecificDimensions());
    }

    public POSSalesReturnLine(POSQuantity qty, BigDecimal unitPrice, BigDecimal totalPrice, POSItem item, String itemCode, POSDiscountTax discount1, POSDiscountTax discount2, POSDiscountTax tax1, POSDiscountTax tax2, BigDecimal netPrice, POSDiscountTax discount3, POSDiscountTax discount4, POSDiscountTax discount5, POSDiscountTax discount6, POSDiscountTax discount7, POSDiscountTax discount8) {
        this.setCommonValues(qty, unitPrice, totalPrice, item, itemCode, discount1, discount2, tax1, tax2, netPrice, discount3, discount4, discount5, discount6, discount7, discount8);
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public void updateInvoice(AbsPOSSales invoice) {
        this.setInvoice((POSSalesReturn)invoice);
    }

    @Override
    public UUID getInvoiceLineId() {
        return this.invoiceLineId;
    }

    @Override
    public void setInvoiceLineId(UUID invoiceLineId) {
        this.invoiceLineId = invoiceLineId;
    }

    @Override
    public POSReturnReason getReturnReason() {
        this.returnReason = POSPersister.materialize(POSReturnReason.class, this.returnReason);
        return this.returnReason;
    }

    @Override
    public void setReturnReason(POSReturnReason returnReason) {
        this.returnReason = returnReason;
    }

    @Override
    public AbsPOSSales fetchSalesDoc() {
        return this.getInvoice();
    }

    @Override
    public Boolean mustBeDisable(String fieldId) {
        if (ObjectChecker.isAnyEqualToFirst((Object)fieldId, (Object[])new String[]{POSSalesTableFields.Qty_Col, POSSalesTableFields.ReturnReason_Col})) {
            return false;
        }
        if (ObjectChecker.areEqual((Object)fieldId, (Object)POSSalesTableFields.Unit_Price_Col) && POSSecurityUtil.userCan(POSSecurityCapability.CanEditReturnUnitPrice).isSucceeded().booleanValue()) {
            return false;
        }
        if (ObjectChecker.isAnyEqualToFirst((Object)fieldId, (Object[])new String[]{POSSalesTableFields.Disc1_Percent_Col, POSSalesTableFields.Disc2_Percent_Col, POSSalesTableFields.Disc1_Val_Col, POSSalesTableFields.Disc2_Val_Col, POSSalesTableFields.Tax1_Percent_Col, POSSalesTableFields.Tax2_Percent_Col, POSSalesTableFields.Tax1_Val_Col, POSSalesTableFields.Tax2_Val_Col}) && POSSecurityUtil.userCan(POSSecurityCapability.CanEditReturnDiscOrTax).isSucceeded().booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean disabledInFromDocLines() {
        if (this.getInvoiceLineId() != null) {
            return true;
        }
        return false;
    }
}

