/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSSavingSettings;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.UUID;

@Entity
public class POSSavingSettingsLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @ManyToOne
    @JoinColumn(name="settings_id")
    private POSSavingSettings settings;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSInvoiceClassification posInvoiceClassification;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCustomer customer;
    private String documentType;
    private UUID subsidiaryID;
    private String subsidiaryType;
    private String subsidiaryNamaType;

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public POSSavingSettings getSettings() {
        this.settings = POSPersister.materialize(POSSavingSettings.class, this.settings);
        return this.settings;
    }

    public void setSettings(POSSavingSettings settings) {
        this.settings = settings;
    }

    @Override
    public POSInvoiceClassification getPosInvoiceClassification() {
        this.posInvoiceClassification = POSPersister.materialize(POSInvoiceClassification.class, this.posInvoiceClassification);
        return this.posInvoiceClassification;
    }

    public void setPosInvoiceClassification(POSInvoiceClassification posInvoiceClassification) {
        this.posInvoiceClassification = posInvoiceClassification;
    }

    @Override
    public POSCustomer getCustomer() {
        this.customer = POSPersister.materialize(POSCustomer.class, this.customer);
        return this.customer;
    }

    public void setCustomer(POSCustomer customer) {
        this.customer = customer;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String docType) {
        this.documentType = docType;
    }

    @Override
    public UUID getSubsidiaryID() {
        return this.subsidiaryID;
    }

    public void setSubsidiaryID(UUID subsidiaryID) {
        this.subsidiaryID = subsidiaryID;
    }

    @Override
    public String getSubsidiaryType() {
        return this.subsidiaryType;
    }

    public void setSubsidiaryType(String subsidiaryType) {
        this.subsidiaryType = subsidiaryType;
    }

    @Override
    public String getSubsidiaryNamaType() {
        return this.subsidiaryNamaType;
    }

    public void setSubsidiaryNamaType(String subsidiaryNamaType) {
        this.subsidiaryNamaType = subsidiaryNamaType;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public boolean matchesDocument(POSSavable doc) {
        if (this.areNotMatched(this.getPosInvoiceClassification(), doc.getPosInvoiceClassification())) {
            return false;
        }
        if (this.areNotMatched(this.getDocumentType(), doc.calcNamaEntityType())) {
            return false;
        }
        if (this.areNotMatched(this.getSubsidiaryType(), doc.getSubsidiaryType())) {
            return false;
        }
        if (this.areNotMatched(this.getCustomer(), doc.getCustomer())) {
            return false;
        }
        if (this.areNotMatched(this.getSubsidiaryID(), doc.getSubsidiaryID())) {
            return false;
        }
        return !this.areNotMatched(this.getSubsidiaryNamaType(), doc.getSubsidiaryNamaType());
    }

    private <T> boolean areNotMatched(T myValue, T invoiceValue) {
        if (ObjectChecker.isEmptyOrNull(myValue)) {
            return false;
        }
        return ObjectChecker.areNotEqual(myValue, invoiceValue);
    }
}

