/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSScrapDoc;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlTransient;
import java.math.BigDecimal;

@Entity
public class POSScrapDocRemovedLine
extends AbsPOSSalesLine {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="scrap_id")
    @JsonIgnore
    private POSScrapDoc scrap;
    @Column(precision=20, scale=10)
    private BigDecimal returnedQty;

    @XmlTransient
    public POSScrapDoc getScrap() {
        this.scrap = POSPersister.materialize(POSScrapDoc.class, this.scrap);
        return this.scrap;
    }

    public void setScrap(POSScrapDoc scrap) {
        this.scrap = scrap;
    }

    public BigDecimal getReturnedQty() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.returnedQty)) {
            return BigDecimal.ZERO;
        }
        return this.returnedQty;
    }

    public void setReturnedQty(BigDecimal returnedQty) {
        this.returnedQty = returnedQty;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public void updateInvoice(AbsPOSSales scrap) {
        this.setScrap((POSScrapDoc)scrap);
    }

    @Override
    public AbsPOSSales fetchSalesDoc() {
        return this.getScrap();
    }
}

