/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSShiftClose;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Date;

@Entity
public class POSShiftCloseLine
extends AbsPOSInventoryLine {
    @JoinColumn(name="shift_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSShiftClose shift;

    public POSShiftClose getShift() {
        this.shift = POSPersister.materialize(POSShiftClose.class, this.shift);
        return this.shift;
    }

    public void setShift(POSShiftClose shift) {
        this.shift = shift;
    }

    @Override
    public POSMasterFile origin() {
        return this.shift;
    }

    @Override
    public String getShiftCode() {
        return this.shift.getCode();
    }

    @Override
    public BigDecimal getAmount() {
        if (this.isCash().booleanValue() && ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getShiftCloseResetCash())) {
            return this.getDifference();
        }
        return this.getAccountantRemaining().negate();
    }

    @Override
    public Date fetchValueDate() {
        return this.shift.getShiftDate();
    }

    @Override
    public Date fetchValueTime() {
        return this.shift.fetchTime();
    }
}

