/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSShift;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Date;

@Entity
public class POSShiftLine
extends AbsPOSInventoryLine {
    @JoinColumn(name="shift_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSShift shift;
    private BigDecimal openActualRemaining;
    private BigDecimal openAccountantRemaining;
    private BigDecimal openDifference;

    public BigDecimal getOpenActualRemaining() {
        return this.openActualRemaining;
    }

    public void setOpenActualRemaining(BigDecimal openActualRemaining) {
        this.openActualRemaining = openActualRemaining;
    }

    public BigDecimal getOpenAccountantRemaining() {
        return this.openAccountantRemaining;
    }

    public void setOpenAccountantRemaining(BigDecimal openAccountantRemaining) {
        this.openAccountantRemaining = openAccountantRemaining;
    }

    public BigDecimal getOpenDifference() {
        return this.openDifference;
    }

    public void setOpenDifference(BigDecimal openDifference) {
        this.openDifference = openDifference;
    }

    public POSShiftLine() {
    }

    public POSShiftLine(String paymentWay, BigDecimal value) {
        super(paymentWay, value);
    }

    public POSShift getShift() {
        this.shift = POSPersister.materialize(POSShift.class, this.shift);
        return this.shift;
    }

    public void setShift(POSShift shift) {
        this.shift = shift;
    }

    @Override
    public POSMasterFile origin() {
        return this.shift;
    }

    @Override
    public String getShiftCode() {
        return this.shift.getCode();
    }

    @Override
    public Date fetchValueDate() {
        return this.shift.getShiftDate();
    }

    @Override
    public Date fetchValueTime() {
        return this.shift.fetchTime();
    }
}

