/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSShortfallsDoc;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlTransient;
import java.math.BigDecimal;

@Entity
public class POSShortfallsDocRemovedLine
extends AbsPOSSalesLine {
    @JoinColumn(name="shortfalls_id")
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    private POSShortfallsDoc shortfalls;
    @Column(precision=20, scale=10)
    private BigDecimal returnedQty;

    @XmlTransient
    public POSShortfallsDoc getShortfalls() {
        this.shortfalls = POSPersister.materialize(POSShortfallsDoc.class, this.shortfalls);
        return this.shortfalls;
    }

    public void setShortfalls(POSShortfallsDoc shortfalls) {
        this.shortfalls = shortfalls;
    }

    public BigDecimal getReturnedQty() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.returnedQty)) {
            return BigDecimal.ZERO;
        }
        return this.returnedQty;
    }

    public void setReturnedQty(BigDecimal returnedQty) {
        this.returnedQty = returnedQty;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public void updateInvoice(AbsPOSSales shortfalls) {
        this.setShortfalls((POSShortfallsDoc)shortfalls);
    }

    @Override
    public AbsPOSSales fetchSalesDoc() {
        return this.getShortfalls();
    }
}

