/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSStockTakingLine;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOInvItemRef;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOItemSpecificDimensions;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTORawQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOUserQuantity;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.IPosHasCosts;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSStockTakingDetailsDoc;
import com.namasoft.pos.util.POSMoneyUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Date;

@Entity
public class POSStockTakingDetailsDocLine
extends AbsPOSSalesLine
implements IPosHasCosts {
    @JoinColumn(name="doc_id")
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    private POSStockTakingDetailsDoc doc;
    @Column(precision=20, scale=10)
    private BigDecimal unitCost;
    @Column(precision=20, scale=10)
    private BigDecimal totalCost;
    private Date retestDate;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSEmployee purchasesMan;

    public POSEmployee getPurchasesMan() {
        this.purchasesMan = POSPersister.materialize(POSEmployee.class, this.purchasesMan);
        return this.purchasesMan;
    }

    public void setPurchasesMan(POSEmployee purchasesMan) {
        this.purchasesMan = purchasesMan;
    }

    @Override
    public BigDecimal getUnitCost() {
        return this.unitCost;
    }

    @Override
    public void setUnitCost(BigDecimal unitCost) {
        this.unitCost = unitCost;
    }

    @Override
    public BigDecimal getTotalCost() {
        return this.totalCost;
    }

    @Override
    public void setTotalCost(BigDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public Date getRetestDate() {
        return this.retestDate;
    }

    public void setRetestDate(Date retestDate) {
        this.retestDate = retestDate;
    }

    public POSStockTakingDetailsDoc getDoc() {
        this.doc = POSPersister.materialize(POSStockTakingDetailsDoc.class, this.doc);
        return this.doc;
    }

    public void setDoc(POSStockTakingDetailsDoc doc) {
        this.doc = doc;
    }

    @Override
    public void updateInvoice(AbsPOSSales invoice) {
        this.setDoc((POSStockTakingDetailsDoc)invoice);
    }

    @Override
    public AbsPOSSales fetchSalesDoc() {
        return this.doc;
    }

    public DTONamaPOSStockTakingLine convertToDTO() {
        DTONamaPOSStockTakingLine line = new DTONamaPOSStockTakingLine();
        DTOInvItemRef item = new DTOInvItemRef();
        POSItem theItem = this.getItem();
        if (theItem == null) {
            theItem = (POSItem)POSPersister.findByCode(POSItem.class, this.getItemCode());
        }
        POSItem frontEndItem = POSPersister.findByID(POSItem.class, theItem.getId().toString());
        item.setItem(POSMasterFile.toRef(frontEndItem));
        item.setItemCode(frontEndItem.getCode());
        item.setItemName1(frontEndItem.getName1());
        item.setItemName2(frontEndItem.getName2());
        line.setItem(item);
        DTOUserQuantity userQuantity = new DTOUserQuantity();
        DTOQuantity quantity = new DTOQuantity();
        DTORawQuantity primeQty = new DTORawQuantity();
        primeQty.setUom(POSMasterFile.toRef(this.getQty().getUom()));
        primeQty.setValue(this.getQty().getValue().abs());
        quantity.setPrimeQty(primeQty);
        userQuantity.setQuantity(quantity);
        line.setQuantity(userQuantity);
        line.setSpecificDimensions(new DTOItemSpecificDimensions());
        line.getSpecificDimensions().setColor(this.getItemDimensions().getColor());
        line.getSpecificDimensions().setSize(this.getItemDimensions().getSize());
        line.getSpecificDimensions().setLotId(this.getItemDimensions().getLotId());
        line.getSpecificDimensions().setSerialNumber(this.getItemDimensions().getSerialNumber());
        line.getSpecificDimensions().setRevisionId(this.getItemDimensions().getRevisionId());
        line.setUserUnitCost(this.getUnitCost());
        line.setUserTotalCost(this.getTotalCost());
        line.setRetestDate(this.getRetestDate());
        line.setProductionDate(this.getProductionDate());
        line.setExpiryDate(this.getExpiryDate());
        line.setPurchasesMan(POSMasterFile.toRef(this.getPurchasesMan()));
        return line;
    }

    public static <T extends AbsPOSSalesLine> void unitCostAction(T line) {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)((IPosHasCosts)((Object)line)).getUnitCost())) {
            return;
        }
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)line.getQty().getValue())) {
            ((IPosHasCosts)((Object)line)).setTotalCost(line.getQty().getValue().multiply(((IPosHasCosts)((Object)line)).getUnitCost()));
        }
    }

    public static <T extends AbsPOSSalesLine> void totalCostAction(T line) {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)((IPosHasCosts)((Object)line)).getTotalCost())) {
            return;
        }
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)line.getQty().getValue())) {
            ((IPosHasCosts)((Object)line)).setUnitCost(NaMaMath.divide((BigDecimal)((IPosHasCosts)((Object)line)).getTotalCost(), (BigDecimal)line.getQty().getValue(), (Integer)POSMoneyUtils.fractionalDecimalPlaces));
        }
    }
}

