/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOInvoiceLineMoney;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOMoneyEffectDetails;
import com.namasoft.modules.namapos.contracts.details.DTONamaPosReceiptLine;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOInvItemRef;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOItemSpecificDimensions;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTORawQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOUserQuantity;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSStockReceipt;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.UUID;

@Entity
@XmlRootElement
public class PosStockReceiptLine
extends AbsPOSSalesLine {
    @JoinColumn(name="invoice_id")
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    private POSStockReceipt invoice;
    @Column(length=16)
    private UUID sourceLineId;

    public PosStockReceiptLine() {
        this.setItemDimensions(new POSItemSpecificDimensions());
    }

    @XmlTransient
    public POSStockReceipt getInvoice() {
        this.invoice = POSPersister.materialize(POSStockReceipt.class, this.invoice);
        return this.invoice;
    }

    public void setInvoice(POSStockReceipt invoice) {
        this.invoice = invoice;
    }

    public UUID getSourceLineId() {
        return this.sourceLineId;
    }

    public void setSourceLineId(UUID sourceLineId) {
        this.sourceLineId = sourceLineId;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public void updateInvoice(AbsPOSSales invoice) {
        this.setInvoice((POSStockReceipt)invoice);
    }

    @Override
    public AbsPOSSales fetchSalesDoc() {
        return this.getInvoice();
    }

    public DTONamaPosReceiptLine convertToDTO() {
        DTONamaPosReceiptLine line = new DTONamaPosReceiptLine();
        if (this.getSourceLineId() != null) {
            line.setSourceLineId(this.getSourceLineId().toString());
        }
        DTOInvItemRef item = new DTOInvItemRef();
        POSItem theItem = this.getItem();
        if (theItem == null) {
            theItem = (POSItem)POSPersister.findByCode(POSItem.class, this.getItemCode());
        }
        POSItem frontEndItem = POSPersister.findByID(POSItem.class, theItem.getId().toString());
        item.setItem(POSMasterFile.toRef(frontEndItem));
        item.setItemCode(frontEndItem.getCode());
        item.setItemName1(frontEndItem.getName1());
        item.setItemName2(frontEndItem.getName2());
        line.setItem(item);
        DTOUserQuantity userQuantity = new DTOUserQuantity();
        DTOQuantity quantity = new DTOQuantity();
        DTORawQuantity primeQty = new DTORawQuantity();
        primeQty.setUom(POSMasterFile.toRef(this.getQty().getUom()));
        primeQty.setValue(this.getQty().getValue().abs());
        quantity.setPrimeQty(primeQty);
        userQuantity.setQuantity(quantity);
        line.setQuantity(userQuantity);
        DTOInvoiceLineMoney price = new DTOInvoiceLineMoney();
        price.updateNulls();
        price.setUnitPrice(this.getUnitPrice());
        price.setPrice(this.getTotalPrice());
        DTOMoneyEffectDetails discount1 = new DTOMoneyEffectDetails();
        discount1.setPercentage(this.getDiscount1().getPercentage());
        discount1.setValue(this.getDiscount1().getValue());
        price.setDiscount1(discount1);
        DTOMoneyEffectDetails discount2 = new DTOMoneyEffectDetails();
        discount2.setPercentage(this.getDiscount2().getPercentage());
        discount2.setValue(this.getDiscount2().getValue());
        price.setDiscount2(discount2);
        DTOMoneyEffectDetails tax1 = new DTOMoneyEffectDetails();
        tax1.setMaxNormalPercent(this.getTax1().getPercentage());
        tax1.setValue(this.getTax1().getValue());
        price.setTax1(tax1);
        DTOMoneyEffectDetails tax2 = new DTOMoneyEffectDetails();
        tax2.setMaxNormalPercent(this.getTax2().getPercentage());
        tax2.setValue(this.getTax2().getValue());
        price.setTax2(tax2);
        DTOMoneyEffectDetails discount3 = new DTOMoneyEffectDetails();
        discount3.setPercentage(this.getDiscount3().getPercentage());
        discount3.setValue(this.getDiscount3().getValue());
        price.setDiscount3(discount3);
        DTOMoneyEffectDetails discount4 = new DTOMoneyEffectDetails();
        discount4.setPercentage(this.getDiscount4().getPercentage());
        discount4.setValue(this.getDiscount4().getValue());
        price.setDiscount4(discount4);
        DTOMoneyEffectDetails discount5 = new DTOMoneyEffectDetails();
        discount5.setPercentage(this.getDiscount5().getPercentage());
        discount5.setValue(this.getDiscount5().getValue());
        price.setDiscount5(discount5);
        DTOMoneyEffectDetails discount6 = new DTOMoneyEffectDetails();
        discount6.setPercentage(this.getDiscount6().getPercentage());
        discount6.setValue(this.getDiscount6().getValue());
        price.setDiscount6(discount6);
        DTOMoneyEffectDetails discount7 = new DTOMoneyEffectDetails();
        discount7.setPercentage(this.getDiscount7().getPercentage());
        discount7.setValue(this.getDiscount7().getValue());
        price.setDiscount7(discount7);
        DTOMoneyEffectDetails discount8 = new DTOMoneyEffectDetails();
        discount8.setPercentage(this.getDiscount8().getPercentage());
        discount8.setValue(this.getDiscount8().getValue());
        price.setDiscount8(discount8);
        price.setNetValue(this.getNetPrice());
        line.setPrice(price);
        line.setSpecificDimensions(new DTOItemSpecificDimensions());
        line.getSpecificDimensions().setColor(this.getItemDimensions().getColor());
        line.getSpecificDimensions().setSize(this.getItemDimensions().getSize());
        line.getSpecificDimensions().setLotId(this.getItemDimensions().getLotId());
        line.getSpecificDimensions().setSerialNumber(this.getItemDimensions().getSerialNumber());
        line.getSpecificDimensions().setRevisionId(this.getItemDimensions().getRevisionId());
        line.setProductionDate(this.getProductionDate());
        line.setExpiryDate(this.getExpiryDate());
        return line;
    }

    @Override
    public void updateSourceLineId(UUID sourceLineId) {
        this.setSourceLineId(sourceLineId);
    }
}

