/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.common.DTOPOSErrorSysLine;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.IPOSDocFile;
import com.namasoft.pos.domain.IPOSWritableFile;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.util.POSDataReaderUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import java.util.Date;
import java.util.UUID;

@Entity
public class POSError
extends POSMasterFile
implements IPOSWritableFile<DTOPOSErrorSysLine> {
    @Column(length=16)
    private UUID recordId;
    private String entityType;
    private Date onTime;
    @Lob
    private String failure;
    @Lob
    private String log;
    private Boolean sent = false;
    @Column(length=16)
    private UUID registerUUID;

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public Date getOnTime() {
        return this.onTime;
    }

    public void setOnTime(Date onTime) {
        this.onTime = onTime;
    }

    public String getFailure() {
        return this.failure;
    }

    public void setFailure(String failure) {
        this.failure = failure;
    }

    @Override
    public String calcNamaEntityType() {
        return "";
    }

    public UUID getRecordId() {
        return this.recordId;
    }

    public void setRecordId(UUID recordId) {
        this.recordId = recordId;
    }

    public Boolean getSent() {
        return this.sent;
    }

    @Override
    public void setSent(Boolean sent) {
        this.sent = sent;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public UUID getRegisterUUID() {
        return this.registerUUID;
    }

    public void setRegisterUUID(UUID registerUUID) {
        this.registerUUID = registerUUID;
    }

    @Override
    public DTOPOSErrorSysLine toDTO() {
        Object doc;
        DTOPOSErrorSysLine dtoNamaPOSErrorSysLine = new DTOPOSErrorSysLine();
        dtoNamaPOSErrorSysLine.setEntityType(this.getEntityType());
        dtoNamaPOSErrorSysLine.setEntityCode(this.getCode());
        dtoNamaPOSErrorSysLine.setEntityID(ServerStringUtils.toUUIDStr((Object)this.getRecordId()));
        dtoNamaPOSErrorSysLine.setFailure(this.getFailure());
        dtoNamaPOSErrorSysLine.setOnTime(this.getOnTime());
        POSRegistery posRegistery = POSResourcesUtil.fetchRegisterIgnoringInActiveAndPreventUsage(this.getRegisterUUID());
        if (posRegistery == null) {
            posRegistery = POSResourcesUtil.fetchMainRegister();
        }
        dtoNamaPOSErrorSysLine.setRegisterCode(posRegistery.getCode());
        dtoNamaPOSErrorSysLine.setLog(this.getLog());
        Class klass = POSDataReaderUtil.constructNamaWithPOSTypesMap().get(ObjectChecker.toStringOrEmpty((Object)this.getEntityType()));
        if (ObjectChecker.isNotEmptyOrNull((Object)klass) && IPOSDocFile.class.isAssignableFrom(klass) && (doc = POSPersister.findByID(klass, this.getRecordId())) != null) {
            dtoNamaPOSErrorSysLine.setValueDate(((IPOSDocFile)doc).fetchValueDate());
        }
        return dtoNamaPOSErrorSysLine;
    }
}

