/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSExtraFilterLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSExtraFilter;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSExtraFilterLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.List;

@Entity
public class POSExtraFilter
extends POSMasterFile<DTONamaPOSExtraFilter> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="posExtraFilter_id")
    private List<POSExtraFilterLine> extraFilters;

    public List<POSExtraFilterLine> getExtraFilters() {
        if (this.extraFilters == null) {
            this.extraFilters = new ArrayList<POSExtraFilterLine>();
        }
        return this.extraFilters;
    }

    public void setExtraFilters(List<POSExtraFilterLine> extraFilters) {
        this.extraFilters = extraFilters;
    }

    @Override
    public void updateData(DTONamaPOSExtraFilter object) {
        super.updateData(object);
        CollectionsUtility.makeSecondSameSize((List)object.getExtraFilters(), this.getExtraFilters(), POSExtraFilterLine::new);
        for (DTONamaPOSExtraFilterLine extraFilter : object.getExtraFilters()) {
            POSExtraFilterLine filterLine = this.getExtraFilters().remove(0);
            filterLine.setDocumentType(extraFilter.getDocumentType());
            filterLine.setFieldId(extraFilter.getFieldID());
            filterLine.setFilter(extraFilter.getFilter());
            this.getExtraFilters().add(filterLine);
        }
        POSResourcesUtil.resetExtraFilters();
    }

    @Override
    public void assignIds() {
        super.assignIds();
        this.getExtraFilters().forEach(POSExtraFilterLine::getId);
    }

    @Override
    public void initializeLists() {
        super.initializeLists();
        this.getExtraFilters().size();
    }
}

