/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.supplychain.contracts.details.DTOFreeGroupLine;
import com.namasoft.modules.supplychain.contracts.entities.DTOFreeItemGroup;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSFreeGroupLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Entity
public class POSFreeItemGroup
extends POSMasterFile<DTOFreeItemGroup> {
    private String groupPolicy;
    @Lob
    private String freeIds;
    @Column(precision=20, scale=10)
    private BigDecimal standardPrice;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="itemGroup")
    @OrderColumn(name="lineNumber")
    private List<POSFreeGroupLine> details;

    public String getGroupPolicy() {
        return this.groupPolicy;
    }

    public void setGroupPolicy(String groupPolicy) {
        this.groupPolicy = groupPolicy;
    }

    public String getFreeIds() {
        return this.freeIds;
    }

    public void setFreeIds(String freeIds) {
        this.freeIds = freeIds;
    }

    public BigDecimal getStandardPrice() {
        return this.standardPrice;
    }

    public void setStandardPrice(BigDecimal standardPrice) {
        this.standardPrice = standardPrice;
    }

    public List<POSFreeGroupLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSFreeGroupLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSFreeGroupLine> details) {
        this.details = details;
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    @Override
    public void updateData(DTOFreeItemGroup dtoFreeItemGroup) {
        super.updateData(dtoFreeItemGroup);
        this.setFreeIds(dtoFreeItemGroup.getFreeIds());
        this.setGroupPolicy(dtoFreeItemGroup.getGroupPolicy());
        this.setStandardPrice(dtoFreeItemGroup.getStandardPrice());
        if (this.getDetails() == null) {
            this.setDetails(new ArrayList<POSFreeGroupLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)dtoFreeItemGroup.getDetails(), this.getDetails(), POSFreeGroupLine::new);
        for (int i = 0; i < dtoFreeItemGroup.getDetails().size(); ++i) {
            this.getDetails().get(i).updateData((DTOFreeGroupLine)dtoFreeItemGroup.getDetails().get(i));
            this.getDetails().get(i).setItemGroup(this);
        }
    }

    @Override
    public String calcNamaEntityType() {
        return "FreeItemGroup";
    }
}

