/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSGenericReference;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import java.util.UUID;

@Entity
public class POSGenReference
extends POSMasterFile<DTONamaPOSGenericReference> {
    private String type;
    @Column(name="namaGenRefId", length=16)
    private UUID namaGenRefId;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSGenericReference";
    }

    @Override
    public void updateData(DTONamaPOSGenericReference object) {
        super.updateData(object);
        EntityReferenceData reference = object.getReference();
        this.setCode(reference.getCode());
        this.setType(reference.getEntityType());
        this.setName1(reference.getName1());
        this.setName2(reference.getName2());
        this.setNamaGenRefId(ServerStringUtils.strToUUID((String)reference.getId()));
        this.setGenericDims(POSGenericDims.calcDims((BaseEntityDTO)object));
    }

    public UUID getNamaGenRefId() {
        return this.namaGenRefId;
    }

    public void setNamaGenRefId(UUID namaGenRefId) {
        this.namaGenRefId = namaGenRefId;
    }
}

