/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.basic.contracts.details.DTOExtraCode;
import com.namasoft.modules.basic.contracts.details.DTOFieldFormatLine;
import com.namasoft.modules.basic.contracts.details.DTOMaxPOSFieldLengthInDB;
import com.namasoft.modules.basic.contracts.entities.DTOGenericReferenceOverrider;
import com.namasoft.modules.basic.enums.ParamFieldType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.controllers.MobileInvoicesController;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSExtraCodeLine;
import com.namasoft.pos.domain.details.POSFieldFormatLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;

@Entity
public class POSGenericReferenceOverrider
extends POSMasterFile<DTOGenericReferenceOverrider> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="genRefOverrider")
    @OrderColumn(name="lineNumber")
    private List<POSFieldFormatLine> fieldFormats;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="genRefOverrider")
    @OrderColumn(name="lineNumber")
    private List<POSExtraCodeLine> extraCodes;

    @Override
    public String calcNamaEntityType() {
        return "GenericReferenceOverrider";
    }

    public List<POSFieldFormatLine> getFieldFormats() {
        if (this.fieldFormats == null) {
            this.fieldFormats = new ArrayList<POSFieldFormatLine>();
        }
        return this.fieldFormats;
    }

    public void setFieldFormats(List<POSFieldFormatLine> fieldFormats) {
        this.fieldFormats = fieldFormats;
    }

    public List<POSExtraCodeLine> getExtraCodes() {
        if (this.extraCodes == null) {
            this.extraCodes = new ArrayList<POSExtraCodeLine>();
        }
        return this.extraCodes;
    }

    public void setExtraCodes(List<POSExtraCodeLine> extraCodes) {
        this.extraCodes = extraCodes;
    }

    @Override
    public void updateData(DTOGenericReferenceOverrider object) {
        POSSavable line;
        super.updateData(object);
        List fieldFormats = object.getFieldFormats();
        this.getFieldFormats().clear();
        for (DTOFieldFormatLine formatLine : fieldFormats) {
            if (!this.isRelatedToCustomer(formatLine.getForType(), formatLine.getEntityList())) continue;
            line = new POSFieldFormatLine();
            ((POSFieldFormatLine)line).setGenRefOverrider(this);
            this.getFieldFormats().add((POSFieldFormatLine)line);
            ((POSFieldFormatLine)line).setFieldID(formatLine.getFieldID());
            ((POSFieldFormatLine)line).setMinLength(formatLine.getMinLength());
            ((POSFieldFormatLine)line).setMaxLength(formatLine.getMaxLength());
            ((POSFieldFormatLine)line).setAllowAlpha(formatLine.getAllowAlpha());
            ((POSFieldFormatLine)line).setAllowNumbers(formatLine.getAllowNumbers());
            ((POSFieldFormatLine)line).setLetterCaseType(formatLine.getLetterCaseType());
            ((POSFieldFormatLine)line).setPrefix(formatLine.getPrefix());
            ((POSFieldFormatLine)line).setSuffix(formatLine.getSuffix());
            ((POSFieldFormatLine)line).getId();
        }
        this.getExtraCodes().clear();
        for (DTOExtraCode extraCode : object.getExtraCodes()) {
            if (!this.isRelatedToCustomer(extraCode.getForType(), extraCode.getForTypeList())) continue;
            line = new POSExtraCodeLine(extraCode);
            ((POSExtraCodeLine)line).setGenRefOverrider(this);
            this.getExtraCodes().add((POSExtraCodeLine)line);
        }
        POSGenericReferenceOverrider.alterDBIfNeeded(object);
    }

    private static void alterDBIfNeeded(DTOGenericReferenceOverrider object) {
        if (ObjectChecker.isEmptyOrNull((Object)object.getMaxPOSFieldsLengthInDB())) {
            return;
        }
        for (DTOMaxPOSFieldLengthInDB line : object.getMaxPOSFieldsLengthInDB()) {
            String oql = "alter table " + line.getPosEntityType().substring("POS.".length()) + " alter column " + line.getPosEntityType();
            oql = oql + (ObjectChecker.areEqual((Object)line.getFieldType(), (Object)ParamFieldType.Decimal.name()) ? " numeric(" + line.getMaxLength() + ",10)" : " nvarchar(" + line.getMaxLength() + ")");
            POSPersister.execute(oql);
        }
    }

    private boolean isRelatedToCustomer(String type, EntityReferenceData referenceData) {
        if (ObjectChecker.areEqual((Object)type, (Object)"Customer")) {
            return true;
        }
        if (referenceData == null) {
            return false;
        }
        return ObjectChecker.toStringOrEmpty((Object)referenceData.get("lines.entityType")).contains(",Customer,");
    }

    @Override
    public void initializeLists() {
        this.getFieldFormats().size();
        this.getExtraCodes().size();
    }

    @Override
    public void postCommitAction(Session session) {
        super.postCommitAction(session);
        MobileInvoicesController.resetExtraCodeLines();
    }
}

