/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSInternalMessage;
import com.namasoft.pos.application.POSInternalMsgScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.IPOSWritableFile;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSEmployee;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import java.util.Date;

@Entity
public class POSInternalMessage
extends POSMasterFile<DTONamaPOSInternalMessage>
implements IPOSWritableFile<DTONamaPOSInternalMessage> {
    @ManyToOne(fetch=FetchType.LAZY)
    private POSEmployee toEmp1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSEmployee toEmp2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSEmployee toEmp3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSEmployee toEmp4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSEmployee toEmp5;
    @Lob
    private String messageBody;
    private Boolean sent = false;
    @Transient
    private POSInternalMsgScreen view;
    private Date valueDate;

    public POSInternalMessage() {
    }

    public POSInternalMessage(POSInternalMsgScreen view) {
        this.view = view;
    }

    public POSEmployee getToEmp1() {
        this.toEmp1 = POSPersister.materialize(POSEmployee.class, this.toEmp1);
        return this.toEmp1;
    }

    public void setToEmp1(POSEmployee toEmp1) {
        this.toEmp1 = toEmp1;
    }

    public POSEmployee getToEmp2() {
        this.toEmp2 = POSPersister.materialize(POSEmployee.class, this.toEmp2);
        return this.toEmp2;
    }

    public void setToEmp2(POSEmployee toEmp2) {
        this.toEmp2 = toEmp2;
    }

    public POSEmployee getToEmp3() {
        this.toEmp3 = POSPersister.materialize(POSEmployee.class, this.toEmp3);
        return this.toEmp3;
    }

    public void setToEmp3(POSEmployee toEmp3) {
        this.toEmp3 = toEmp3;
    }

    public POSEmployee getToEmp4() {
        this.toEmp4 = POSPersister.materialize(POSEmployee.class, this.toEmp4);
        return this.toEmp4;
    }

    public void setToEmp4(POSEmployee toEmp4) {
        this.toEmp4 = toEmp4;
    }

    public POSEmployee getToEmp5() {
        this.toEmp5 = POSPersister.materialize(POSEmployee.class, this.toEmp5);
        return this.toEmp5;
    }

    public void setToEmp5(POSEmployee toEmp5) {
        this.toEmp5 = toEmp5;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public void setMessageBody(String messageBody) {
        this.messageBody = messageBody;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSInternalMessage";
    }

    @Override
    public void updateData(DTONamaPOSInternalMessage object) {
        this.setMessageBody(object.getMessageBody());
        this.setToEmp1((POSEmployee)this.fromReference(object.getToEmp1()));
        this.setToEmp2((POSEmployee)this.fromReference(object.getToEmp2()));
        this.setToEmp3((POSEmployee)this.fromReference(object.getToEmp3()));
        this.setToEmp4((POSEmployee)this.fromReference(object.getToEmp4()));
        this.setToEmp5((POSEmployee)this.fromReference(object.getToEmp5()));
        this.setValueDate(object.getCreationDate());
        super.updateData(object);
    }

    public Boolean getSent() {
        return this.sent;
    }

    @Override
    public void setSent(Boolean sent) {
        this.sent = sent;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }

    @Override
    public DTONamaPOSInternalMessage toDTO() {
        DTONamaPOSInternalMessage dtoMsg = new DTONamaPOSInternalMessage();
        dtoMsg.setId(this.getId().toString());
        dtoMsg.setCode(this.getCode());
        dtoMsg.setMessageBody(this.getMessageBody());
        POSEmployee toEmp1 = this.getToEmp1();
        dtoMsg.setToEmp1(POSMasterFile.toRef(toEmp1));
        POSEmployee toEmp2 = this.getToEmp2();
        dtoMsg.setToEmp2(POSMasterFile.toRef(toEmp2));
        POSEmployee toEmp3 = this.getToEmp3();
        dtoMsg.setToEmp3(POSMasterFile.toRef(toEmp3));
        POSEmployee toEmp4 = this.getToEmp4();
        dtoMsg.setToEmp4(POSMasterFile.toRef(toEmp4));
        POSEmployee toEmp5 = this.getToEmp5();
        dtoMsg.setToEmp5(POSMasterFile.toRef(toEmp5));
        dtoMsg.setValueDate(this.getValueDate());
        dtoMsg.setPosCreationTime(this.convertDateToDateTimeString(this.getValueDate()));
        return dtoMsg;
    }
}

