/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSShiftOpenClose;
import com.namasoft.modules.namapos.contracts.entities.DTOPOSCashDrawer;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSShiftInventoryScreen;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.details.POSInventoryLine;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSResult;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity
public class POSInventory
extends AbsPOSShiftInventory<DTOPOSCashDrawer> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="inventory")
    @OrderColumn(name="lineNumber")
    private List<POSInventoryLine> details;
    @Transient
    private POSShiftInventoryScreen view;
    private String shiftCode;

    public POSInventory() {
    }

    public POSInventory(String code, Date date, String time, String registeryCode) {
        super(code);
        this.setShiftDate(date);
        this.setTime(time);
        this.updateRegistery(registeryCode);
        this.setDetails(new ArrayList<POSInventoryLine>());
        this.setPosUser(POSResourcesUtil.currentSetting.getCurrentUser());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    @Override
    protected void updateShiftOrInventory(AbsPOSInventoryLine l) {
        ((POSInventoryLine)l).setInventory(this);
    }

    public List<POSInventoryLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSInventoryLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSInventoryLine> details) {
        this.details = details;
    }

    @Override
    public List<? extends AbsPOSInventoryLine> fetchDetails() {
        return this.getDetails();
    }

    public void save() {
        POSResult posResult = POSPersister.saveAndCreateActionHistoryEntry(this);
        if (posResult.isFailed().booleanValue()) {
            POSErrorAndInfoMessagesUtil.showError(posResult, POSResourcesUtil.currentScreen.fetchStage());
            return;
        }
    }

    @Override
    public void updateDetails(List<? extends AbsPOSInventoryLine> list) {
        this.getDetails().clear();
        for (AbsPOSInventoryLine absPOSInventoryLine : list) {
            POSInventoryLine posInventoryLine = new POSInventoryLine();
            posInventoryLine.setPaymentWay(absPOSInventoryLine.getPaymentWay());
            posInventoryLine.setPaymentMethodId(absPOSInventoryLine.getPaymentMethodId());
            posInventoryLine.setCurrency(absPOSInventoryLine.getCurrency());
            posInventoryLine.setCurrencyId(absPOSInventoryLine.getCurrencyId());
            posInventoryLine.setInventory(this);
            posInventoryLine.setAccountantRemaining(absPOSInventoryLine.getAccountantRemaining());
            posInventoryLine.setDifference(absPOSInventoryLine.getDifference());
            if (ObjectChecker.isEmptyOrZero((BigDecimal)absPOSInventoryLine.getActualRemaining())) {
                absPOSInventoryLine.setActualRemaining(BigDecimal.ZERO);
            }
            posInventoryLine.setActualRemaining(absPOSInventoryLine.getActualRemaining());
            posInventoryLine.setDisableActualBalance(absPOSInventoryLine.getDisableActualBalance());
            this.getDetails().add(posInventoryLine);
        }
    }

    @Override
    public AbsPOSInventoryLine createLine() {
        return new POSInventoryLine();
    }

    @Override
    public String calcNamaEntityType() {
        return "POSCashDrawer";
    }

    public String getShiftCode() {
        return this.shiftCode;
    }

    public void setShiftCode(String shiftCode) {
        this.shiftCode = shiftCode;
    }

    @Override
    public DTOPOSCashDrawer toDTO() {
        DTOPOSCashDrawer dtoCashDrawer = new DTOPOSCashDrawer();
        POSActualDTOConverter.copyBasicData(this, (DTOAbsPOSShiftOpenClose)dtoCashDrawer);
        dtoCashDrawer.setId(this.getId().toString());
        POSActualDTOConverter.addLinesToCashDrawer(this.getDetails(), dtoCashDrawer);
        return dtoCashDrawer;
    }
}

