/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSItemBarcodeParser;
import com.namasoft.modules.namapos.contracts.valueobjects.DTONamaPOSItemBarcodeSpecs;
import com.namasoft.modules.supplychain.contracts.details.DTOAbsItemBarcodePart;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSItemBarcodePart;
import com.namasoft.pos.domain.details.POSItemBarcodePart1;
import com.namasoft.pos.domain.details.POSItemBarcodePart2;
import com.namasoft.pos.domain.details.POSItemBarcodePart3;
import com.namasoft.pos.domain.details.POSItemBarcodePart4;
import com.namasoft.pos.domain.details.POSItemBarcodePart5;
import com.namasoft.pos.domain.entities.POSItemBarcodeSpecs;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Entity
public class POSItemBarcodeParser
extends POSMasterFile<DTONamaPOSItemBarcodeParser> {
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="prefix", column=@Column(name="specs1Prefix")), @AttributeOverride(name="separator", column=@Column(name="specs1Separator")), @AttributeOverride(name="minCodeLength", column=@Column(name="specs1MinCodeLength")), @AttributeOverride(name="maxCodeLength", column=@Column(name="specs1MaxCodeLength")), @AttributeOverride(name="treatPrefixAsPartOfFirstProperty", column=@Column(name="specs1PrefixAsPartOfProperty")), @AttributeOverride(name="parts", column=@Column(name="specs1Parts"))})
    private POSItemBarcodeSpecs specs1;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="prefix", column=@Column(name="specs2Prefix")), @AttributeOverride(name="separator", column=@Column(name="specs2Separator")), @AttributeOverride(name="minCodeLength", column=@Column(name="specs2MinCodeLength")), @AttributeOverride(name="maxCodeLength", column=@Column(name="specs2MaxCodeLength")), @AttributeOverride(name="treatPrefixAsPartOfFirstProperty", column=@Column(name="specs2PrefixAsPartOfProperty")), @AttributeOverride(name="parts", column=@Column(name="specs2Parts"))})
    private POSItemBarcodeSpecs specs2;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="prefix", column=@Column(name="specs3Prefix")), @AttributeOverride(name="separator", column=@Column(name="specs3Separator")), @AttributeOverride(name="minCodeLength", column=@Column(name="specs3MinCodeLength")), @AttributeOverride(name="maxCodeLength", column=@Column(name="specs3MaxCodeLength")), @AttributeOverride(name="treatPrefixAsPartOfFirstProperty", column=@Column(name="specs3PrefixAsPartOfProperty")), @AttributeOverride(name="parts", column=@Column(name="specs3Parts"))})
    private POSItemBarcodeSpecs specs3;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="prefix", column=@Column(name="specs4Prefix")), @AttributeOverride(name="separator", column=@Column(name="specs4Separator")), @AttributeOverride(name="minCodeLength", column=@Column(name="specs4MinCodeLength")), @AttributeOverride(name="maxCodeLength", column=@Column(name="specs4MaxCodeLength")), @AttributeOverride(name="treatPrefixAsPartOfFirstProperty", column=@Column(name="specs4PrefixAsPartOfProperty")), @AttributeOverride(name="parts", column=@Column(name="specs4Parts"))})
    private POSItemBarcodeSpecs specs4;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="prefix", column=@Column(name="specs5Prefix")), @AttributeOverride(name="separator", column=@Column(name="specs5Separator")), @AttributeOverride(name="minCodeLength", column=@Column(name="specs5MinCodeLength")), @AttributeOverride(name="maxCodeLength", column=@Column(name="specs5MaxCodeLength")), @AttributeOverride(name="treatPrefixAsPartOfFirstProperty", column=@Column(name="specs5PrefixAsPartOfProperty")), @AttributeOverride(name="parts", column=@Column(name="specs5Parts"))})
    private POSItemBarcodeSpecs specs5;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="parser")
    @OrderColumn(name="lineNumber")
    private List<POSItemBarcodePart1> parts1;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="parser")
    @OrderColumn(name="lineNumber")
    private List<POSItemBarcodePart2> parts2;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="parser")
    @OrderColumn(name="lineNumber")
    private List<POSItemBarcodePart3> parts3;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="parser")
    @OrderColumn(name="lineNumber")
    private List<POSItemBarcodePart4> parts4;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="parser")
    @OrderColumn(name="lineNumber")
    private List<POSItemBarcodePart5> parts5;

    public List<POSItemBarcodePart2> getParts2() {
        if (this.parts2 == null) {
            this.parts2 = new ArrayList<POSItemBarcodePart2>();
        }
        return this.parts2;
    }

    public void setParts2(List<POSItemBarcodePart2> parts2) {
        this.parts2 = parts2;
    }

    public List<POSItemBarcodePart3> getParts3() {
        if (this.parts3 == null) {
            this.parts3 = new ArrayList<POSItemBarcodePart3>();
        }
        return this.parts3;
    }

    public void setParts3(List<POSItemBarcodePart3> parts3) {
        this.parts3 = parts3;
    }

    public List<POSItemBarcodePart4> getParts4() {
        if (this.parts4 == null) {
            this.parts4 = new ArrayList<POSItemBarcodePart4>();
        }
        return this.parts4;
    }

    public void setParts4(List<POSItemBarcodePart4> parts4) {
        this.parts4 = parts4;
    }

    public List<POSItemBarcodePart5> getParts5() {
        if (this.parts5 == null) {
            this.parts5 = new ArrayList<POSItemBarcodePart5>();
        }
        return this.parts5;
    }

    public void setParts5(List<POSItemBarcodePart5> parts5) {
        this.parts5 = parts5;
    }

    public List<POSItemBarcodePart1> getParts1() {
        if (this.parts1 == null) {
            this.parts1 = new ArrayList<POSItemBarcodePart1>();
        }
        return this.parts1;
    }

    public void setParts1(List<POSItemBarcodePart1> parts) {
        this.parts1 = parts;
    }

    public POSItemBarcodeSpecs getSpecs1() {
        if (this.specs1 == null) {
            this.specs1 = new POSItemBarcodeSpecs();
        }
        return this.specs1;
    }

    public void setSpecs1(POSItemBarcodeSpecs specs1) {
        this.specs1 = specs1;
    }

    public POSItemBarcodeSpecs getSpecs2() {
        if (this.specs2 == null) {
            this.specs2 = new POSItemBarcodeSpecs();
        }
        return this.specs2;
    }

    public void setSpecs2(POSItemBarcodeSpecs specs2) {
        this.specs2 = specs2;
    }

    public POSItemBarcodeSpecs getSpecs3() {
        if (this.specs3 == null) {
            this.specs3 = new POSItemBarcodeSpecs();
        }
        return this.specs3;
    }

    public void setSpecs3(POSItemBarcodeSpecs specs3) {
        this.specs3 = specs3;
    }

    public POSItemBarcodeSpecs getSpecs4() {
        if (this.specs4 == null) {
            this.specs4 = new POSItemBarcodeSpecs();
        }
        return this.specs4;
    }

    public void setSpecs4(POSItemBarcodeSpecs specs4) {
        this.specs4 = specs4;
    }

    public POSItemBarcodeSpecs getSpecs5() {
        if (this.specs5 == null) {
            this.specs5 = new POSItemBarcodeSpecs();
        }
        return this.specs5;
    }

    public void setSpecs5(POSItemBarcodeSpecs specs5) {
        this.specs5 = specs5;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSItemBarcodeParser";
    }

    @Override
    public void initializeLists() {
        this.getParts1().size();
        this.getParts2().size();
        this.getParts3().size();
        this.getParts4().size();
        this.getParts5().size();
    }

    @Override
    public void updateData(DTONamaPOSItemBarcodeParser object) {
        this.copyFromTo(object.getSpecs1(), this.getSpecs1());
        this.copyFromTo(object.getSpecs2(), this.getSpecs2());
        this.copyFromTo(object.getSpecs3(), this.getSpecs3());
        this.copyFromTo(object.getSpecs4(), this.getSpecs4());
        this.copyFromTo(object.getSpecs5(), this.getSpecs5());
        this.getParts1().clear();
        this.getParts1().addAll(CollectionsUtility.convert((Collection)object.getParts1(), obj -> {
            POSItemBarcodePart1 part = new POSItemBarcodePart1();
            this.converterCopier((DTOAbsItemBarcodePart)obj, part);
            return part;
        }));
        this.getParts2().clear();
        this.getParts2().addAll(CollectionsUtility.convert((Collection)object.getParts2(), obj -> {
            POSItemBarcodePart2 part = new POSItemBarcodePart2();
            this.converterCopier((DTOAbsItemBarcodePart)obj, part);
            return part;
        }));
        this.getParts3().clear();
        this.getParts3().addAll(CollectionsUtility.convert((Collection)object.getParts3(), obj -> {
            POSItemBarcodePart3 part = new POSItemBarcodePart3();
            this.converterCopier((DTOAbsItemBarcodePart)obj, part);
            return part;
        }));
        this.getParts4().clear();
        this.getParts4().addAll(CollectionsUtility.convert((Collection)object.getParts4(), obj -> {
            POSItemBarcodePart4 part = new POSItemBarcodePart4();
            this.converterCopier((DTOAbsItemBarcodePart)obj, part);
            return part;
        }));
        this.getParts5().clear();
        this.getParts5().addAll(CollectionsUtility.convert((Collection)object.getParts5(), obj -> {
            POSItemBarcodePart5 part = new POSItemBarcodePart5();
            this.converterCopier((DTOAbsItemBarcodePart)obj, part);
            return part;
        }));
        super.updateData(object);
    }

    public void converterCopier(DTOAbsItemBarcodePart obj, AbsPOSItemBarcodePart part) {
        part.setSeparator(obj.getSeparator());
        part.setDivideOn(obj.getDivideOn());
        part.setFormat(obj.getFormat());
        part.setLength(obj.getLength());
        part.setMultiplyBy(obj.getMultiplyBy());
        part.setProperty(obj.getProperty());
        part.setParser(this);
        part.assignIds();
    }

    public void copyFromTo(DTONamaPOSItemBarcodeSpecs dtoSpecs, POSItemBarcodeSpecs specs) {
        specs.setMinCodeLength(dtoSpecs.getMinCodeLength());
        specs.setMaxCodeLength(dtoSpecs.getMaxCodeLength());
        specs.setPrefix(dtoSpecs.getPrefix());
        specs.setSeparator(dtoSpecs.getSeparator());
        specs.setTreatPrefixAsPartOfFirstProperty(dtoSpecs.getAsPartOfFirstProperty());
    }
}

