/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.modules.supplychain.contracts.entities.DTOItemClass3;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSHasImage;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemSection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import org.hibernate.annotations.Index;

@Entity
public class POSItemClass3
extends POSMasterFile<DTOItemClass3>
implements POSHasImage {
    @Index(name="index_section")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemSection section;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass2 parent;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass1 itemClass1;
    private Boolean hasImage;

    @Override
    public Boolean isHasImage() {
        if (this.hasImage == null) {
            return true;
        }
        return this.hasImage;
    }

    @Override
    public void setHasImage(Boolean hasImage) {
        this.hasImage = hasImage;
    }

    @Override
    public String calcNamaEntityType() {
        return "ItemClass3";
    }

    public POSItemSection getSection() {
        this.section = POSPersister.materialize(POSItemSection.class, this.section);
        return this.section;
    }

    public void setSection(POSItemSection section) {
        this.section = section;
    }

    public POSItemClass2 getParent() {
        this.parent = POSPersister.materialize(POSItemClass2.class, this.parent);
        return this.parent;
    }

    public void setParent(POSItemClass2 parent) {
        this.parent = parent;
    }

    public POSItemClass1 getItemClass1() {
        this.itemClass1 = POSPersister.materialize(POSItemClass1.class, this.itemClass1);
        return this.itemClass1;
    }

    public void setItemClass1(POSItemClass1 itemClass1) {
        this.itemClass1 = itemClass1;
    }

    @Override
    public void updateData(DTOItemClass3 itemClass) {
        super.updateData(itemClass);
        this.setSection((POSItemSection)this.fromReference(itemClass.getSection()));
        this.setParent((POSItemClass2)this.fromReference(itemClass.getParent()));
        this.setItemClass1((POSItemClass1)this.fromReference(itemClass.getItemClass1()));
        POSResourcesUtil.deleteOldImg(this.getId());
        if (itemClass.getMainFile() == null || itemClass.getMainFile().getDataLength() == 0L) {
            this.setHasImage(false);
        } else {
            this.setHasImage(true);
        }
        POSResourcesUtil.clearCachedFavourites();
    }
}

