/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemCodeType;
import com.namasoft.pos.domain.entities.POSUnit;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.util.UUID;
import org.hibernate.annotations.Index;

@Entity
public class POSItemCode
extends POSMasterFile {
    @Enumerated(value=EnumType.STRING)
    private POSItemCodeType codeType;
    @Column(length=16)
    @Index(name="index_itemId")
    private UUID itemId;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSUnit unit;
    private String color;
    private String size;
    private String colorName;
    private String sizeName;
    private String revision;
    @Transient
    private POSItem item;

    public POSItemCodeType getCodeType() {
        return this.codeType;
    }

    public void setCodeType(POSItemCodeType codeType) {
        this.codeType = codeType;
    }

    public UUID getItemId() {
        return this.itemId;
    }

    public void setItemId(UUID itemId) {
        this.itemId = itemId;
    }

    public POSUnit getUnit() {
        this.unit = POSPersister.materialize(POSUnit.class, this.unit);
        return this.unit;
    }

    public void setUnit(POSUnit unit) {
        this.unit = unit;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getColorName() {
        return this.colorName;
    }

    public void setColorName(String colorName) {
        this.colorName = colorName;
    }

    public String getSizeName() {
        return this.sizeName;
    }

    public void setSizeName(String sizeName) {
        this.sizeName = sizeName;
    }

    @Override
    public String calcNamaEntityType() {
        return "";
    }

    public POSItem fetchItem() {
        if (this.item != null) {
            return this.item;
        }
        this.item = POSPersister.findByID(POSItem.class, this.itemId);
        return this.item;
    }

    public BigDecimal getCurrentPrice() {
        return this.fetchItem().getCurrentPrice(this);
    }
}

