/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.supplychain.contracts.details.DTOItemRevision;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.domain.details.AbsPOSSpecialItemCode;
import com.namasoft.pos.domain.entities.POSUnit;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.UUID;

@Entity
public class POSItemRevision
extends AbsPOSSpecialItemCode {
    private String revisionId;
    private String name1;
    private String name2;
    private boolean defaultRevision;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSUnit defaultUnit;
    @Column(precision=20, scale=10)
    private BigDecimal defaultPrice;
    private String revisionName;

    public BigDecimal getDefaultPrice() {
        return this.defaultPrice;
    }

    public void setDefaultPrice(BigDecimal defaultPrice) {
        this.defaultPrice = defaultPrice;
    }

    public String getName1() {
        return this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public boolean isDefaultRevision() {
        return this.defaultRevision;
    }

    public void setDefaultRevision(boolean defaultRevision) {
        this.defaultRevision = defaultRevision;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public POSUnit getDefaultUnit() {
        this.defaultUnit = POSPersister.materialize(POSUnit.class, this.defaultUnit);
        return this.defaultUnit;
    }

    public void setDefaultUnit(POSUnit defaultUnit) {
        this.defaultUnit = defaultUnit;
    }

    public String getRevisionName() {
        return this.revisionName;
    }

    public void setRevisionName(String revisionName) {
        this.revisionName = revisionName;
    }

    public void updateRevision(DTOItemRevision dtoRevision) {
        this.setId(UUID.fromString(dtoRevision.getId()));
        this.setRevisionId(dtoRevision.getRevisionId());
        this.setCode(dtoRevision.getCode());
        this.setDefaultRevision(dtoRevision.getDefaultRevision());
        this.setName1(dtoRevision.getName1());
        this.setName2(dtoRevision.getName2());
        this.setDefaultUnit((POSUnit)POSSavable.staticFromReference(dtoRevision.getDefaultUOM()));
        this.setDefaultPrice(dtoRevision.getDefaultPrice());
        this.setRevisionName(dtoRevision.getRevisionName());
    }

    public String nameByLanguage() {
        return (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{this.getRevisionName(), POSResourcesUtil.name(this.getName1(), this.getName2())});
    }
}

