/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.supplychain.contracts.entities.DTOItemSection;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSHasImage;
import com.namasoft.pos.domain.entities.POSItemCategory;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;

@Entity
public class POSItemSection
extends POSMasterFile<DTOItemSection>
implements POSHasImage {
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory defaultCategory1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory defaultCategory2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory defaultCategory3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory defaultCategory4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory defaultCategory5;
    private Boolean replaceable;
    private Boolean hasImage;

    @Override
    public Boolean isHasImage() {
        if (this.hasImage == null) {
            return true;
        }
        return this.hasImage;
    }

    @Override
    public void setHasImage(Boolean hasImage) {
        this.hasImage = hasImage;
    }

    public POSItemCategory getDefaultCategory1() {
        this.defaultCategory1 = POSPersister.materialize(POSItemCategory.class, this.defaultCategory1);
        return this.defaultCategory1;
    }

    public void setDefaultCategory1(POSItemCategory defaultCategory1) {
        this.defaultCategory1 = defaultCategory1;
    }

    public POSItemCategory getDefaultCategory2() {
        this.defaultCategory2 = POSPersister.materialize(POSItemCategory.class, this.defaultCategory2);
        return this.defaultCategory2;
    }

    public void setDefaultCategory2(POSItemCategory defaultCategory2) {
        this.defaultCategory2 = defaultCategory2;
    }

    public POSItemCategory getDefaultCategory3() {
        this.defaultCategory3 = POSPersister.materialize(POSItemCategory.class, this.defaultCategory3);
        return this.defaultCategory3;
    }

    public void setDefaultCategory3(POSItemCategory defaultCategory3) {
        this.defaultCategory3 = defaultCategory3;
    }

    public POSItemCategory getDefaultCategory4() {
        this.defaultCategory4 = POSPersister.materialize(POSItemCategory.class, this.defaultCategory4);
        return this.defaultCategory4;
    }

    public void setDefaultCategory4(POSItemCategory defaultCategory4) {
        this.defaultCategory4 = defaultCategory4;
    }

    public POSItemCategory getDefaultCategory5() {
        this.defaultCategory5 = POSPersister.materialize(POSItemCategory.class, this.defaultCategory5);
        return this.defaultCategory5;
    }

    public void setDefaultCategory5(POSItemCategory defaultCategory5) {
        this.defaultCategory5 = defaultCategory5;
    }

    @Override
    public void updateData(DTOItemSection dtoItemSection) {
        super.updateData(dtoItemSection);
        this.setDefaultCategory1((POSItemCategory)this.fromReference(dtoItemSection.getDefaultCategory1()));
        this.setDefaultCategory2((POSItemCategory)this.fromReference(dtoItemSection.getDefaultCategory2()));
        this.setDefaultCategory3((POSItemCategory)this.fromReference(dtoItemSection.getDefaultCategory3()));
        this.setDefaultCategory4((POSItemCategory)this.fromReference(dtoItemSection.getDefaultCategory4()));
        this.setDefaultCategory5((POSItemCategory)this.fromReference(dtoItemSection.getDefaultCategory5()));
        this.setReplaceable(dtoItemSection.getReplaceable());
        POSResourcesUtil.deleteOldImg(this.getId());
        if (dtoItemSection.getMainFile() == null || dtoItemSection.getMainFile().getDataLength() == 0L) {
            this.setHasImage(false);
        } else {
            this.setHasImage(true);
        }
        POSResourcesUtil.clearCachedFavourites();
    }

    @Override
    public String calcNamaEntityType() {
        return "ItemSection";
    }

    public Boolean getReplaceable() {
        if (ObjectChecker.isEmptyOrNull((Object)this.replaceable)) {
            return false;
        }
        return this.replaceable;
    }

    public void setReplaceable(Boolean replaceable) {
        this.replaceable = replaceable;
    }
}

