/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSOrderReservation;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.AbsPOSSalesTableLine;
import com.namasoft.pos.domain.details.POSOrderReservationLine;
import com.namasoft.pos.domain.details.POSReservationPaymentLine;
import com.namasoft.pos.domain.details.POSReservationTableLine;
import com.namasoft.pos.domain.entities.IHasReservationAmount;
import com.namasoft.pos.domain.entities.IPosDocWithoutPayment;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosTableEntry;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hibernate.Session;

@Entity
public class POSOrderReservation
extends AbsPOSSales
implements IPosDocWithoutPayment,
IHasReservationAmount {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="reservation")
    @OrderColumn(name="lineNumber")
    private List<POSOrderReservationLine> details;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="reservation")
    @OrderColumn(name="lineNumber")
    private List<POSReservationPaymentLine> paymentLines;
    private Boolean delivered;
    private Boolean canceled;
    @Temporal(value=TemporalType.DATE)
    private Date reservationDate;
    @Temporal(value=TemporalType.TIME)
    private Date fromTime;
    @Temporal(value=TemporalType.TIME)
    private Date toTime;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSReservationTableLine> tableLines;
    private BigDecimal reservationAmount;

    @Override
    public BigDecimal getReservationAmount() {
        return this.reservationAmount;
    }

    public void setReservationAmount(BigDecimal reservationAmount) {
        this.reservationAmount = reservationAmount;
    }

    public Date getReservationDate() {
        return this.reservationDate;
    }

    public void setReservationDate(Date reservationDate) {
        this.reservationDate = reservationDate;
    }

    @Override
    public <T extends AbsPOSSalesTableLine> T createTableLine() {
        return (T)new POSReservationTableLine();
    }

    @Override
    public <T extends AbsPOSSalesTableLine> List<T> fetchTables() {
        return this.getTableLines();
    }

    @Override
    public <T extends AbsPOSSalesTableLine> void updateTableLines(List<T> tableLines) {
        this.setTableLines(tableLines);
    }

    public List<POSReservationTableLine> getTableLines() {
        if (this.tableLines == null) {
            this.tableLines = new ArrayList<POSReservationTableLine>();
        }
        return this.tableLines;
    }

    public void setTableLines(List<POSReservationTableLine> tableLines) {
        this.tableLines = tableLines;
    }

    public Date getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(Date fromTime) {
        this.fromTime = fromTime;
    }

    public Date getToTime() {
        return this.toTime;
    }

    public void setToTime(Date toTime) {
        this.toTime = toTime;
    }

    public POSOrderReservation() {
    }

    public POSOrderReservation(AbsPosSalesScreen screen) {
        this.setDetails(new ArrayList<POSOrderReservationLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public Boolean getDelivered() {
        if (this.delivered == null) {
            this.delivered = false;
        }
        return this.delivered;
    }

    public void setDelivered(Boolean delivered) {
        this.delivered = delivered;
    }

    public Boolean getCanceled() {
        if (this.canceled == null) {
            this.canceled = false;
        }
        return this.canceled;
    }

    public void setCanceled(Boolean canceled) {
        this.canceled = canceled;
    }

    public List<POSOrderReservationLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSOrderReservationLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSOrderReservationLine> details) {
        this.details = details;
    }

    public List<POSReservationPaymentLine> getPaymentLines() {
        if (this.paymentLines == null) {
            this.paymentLines = new ArrayList<POSReservationPaymentLine>();
        }
        return this.paymentLines;
    }

    public void setPaymentLines(List<POSReservationPaymentLine> paymentLines) {
        this.paymentLines = paymentLines;
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public List<? extends AbsPOSPaymentLine> fetchPayments() {
        return this.getPaymentLines();
    }

    @Override
    public List<? extends IPOSFinancialEffect> effects() {
        ArrayList<IPOSFinancialEffect> effects = new ArrayList<IPOSFinancialEffect>();
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getPaidCash())) {
            effects.add(new POSSalesInvoice.InvoiceCashPart(this));
        }
        effects.addAll(this.getPaymentLines());
        return effects;
    }

    @Override
    public String fromInvoiceCode() {
        return "";
    }

    @Override
    public void updateDetails(List<? extends AbsPOSSalesLine> list) {
        this.setDetails(list);
    }

    @Override
    public <T extends AbsPOSPaymentLine> T createPaymentLine(String methodName, UUID methodId, BigDecimal value, String authorizationNumber, Boolean cash) {
        return (T)new POSReservationPaymentLine(methodName, methodId, value, authorizationNumber, cash);
    }

    @Override
    public <T extends AbsPOSSalesLine> T createBasicLine() {
        POSOrderReservationLine line = new POSOrderReservationLine();
        line.setReservation(this);
        return (T)line;
    }

    @Override
    public BigDecimal calcCashValue() {
        return new POSSalesInvoice.InvoiceCashPart(this).getAmount();
    }

    @Override
    public BigDecimal calcDebitValue() {
        return BigDecimal.ZERO;
    }

    @Override
    public POSDocumentType docType() {
        return POSDocumentType.POSOrderReservation;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "customer", "netPrice", "valueDate", "paymentMethods", "shiftCode", "delivered");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public List<String> screenFieldsToUpdate() {
        return CollectionsUtility.join((List[])new List[]{SalesDocCommonFieldIds, Arrays.asList("invoiceCode", "times", "reservationAmount")});
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSOrderReservation";
    }

    @Override
    public void initializeLists() {
        super.initializeLists();
        this.getTableLines().size();
    }

    @Override
    public void updateFieldsAndSave(String code, String warehouse, String location, String receiptSrcType, UUID receiptSrcId) {
        this.setCode(code);
        this.setWarehouse(POSPersister.findByID(POSWarehouse.class, warehouse));
        this.setLocation(POSPersister.findByID(POSLocation.class, location));
        this.assignIds();
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        this.updateShiftData(register);
        this.setValueDate(new Date());
        this.setValueTime(new Date());
        POSPersister.saveOrUpdateWithActionHistory(this, null);
        if (POSResourcesUtil.currentSetting != null) {
            if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) {
                POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeReservations(register, Arrays.asList(this))));
            }
        }
        this.setCurrentUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
    }

    @Override
    public void postCommitAction(Session session) {
        POSSalesInvoice.deleteTableEntries(this.getId());
        if (ObjectChecker.areAllFalseOrNull((Boolean[])new Boolean[]{this.getDelivered(), this.getCanceled()})) {
            this.addTableEntries();
        }
        super.postCommitAction(session);
    }

    private void addTableEntries() {
        List<POSTable> tables = this.calcTables();
        if (ObjectChecker.isEmptyOrNull(tables)) {
            return;
        }
        for (POSTable table : tables) {
            try {
                PosTableEntry entry = new PosTableEntry();
                entry.assignIds();
                entry.setPosTable(table);
                entry.setDocumentCode(this.getCode());
                entry.setReservationFrom(new SimpleDateFormat("yyyyMMddHHmmssSSS").parse(new SimpleDateFormat("yyyyMMdd").format(this.getReservationDate()) + new SimpleDateFormat("HHmmssSSS").format(this.getFromTime())));
                entry.setReservationTo(new SimpleDateFormat("yyyyMMddHHmmssSSS").parse(new SimpleDateFormat("yyyyMMdd").format(this.getReservationDate()) + new SimpleDateFormat("HHmmssSSS").format(this.getToTime())));
                entry.setDocumentId(this.getId());
                POSPersister.saveOrUpdate(entry);
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
            }
        }
    }

    @Override
    public void postDeleteActions() {
        POSSalesInvoice.deleteTableEntries(this.getId());
    }

    @Override
    public POSResult writeDocToServer(POSRegistery register, List<PaymentInfo> couponsInfoInPayments, List<PaymentInfo> creditNoteInfos, Callback callback, boolean preventDraft) {
        boolean sent;
        POSResult posResult = new POSResult();
        if (this.getHold()) {
            return posResult;
        }
        if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue() && !(sent = POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeReservations(register, Arrays.asList(this)))))) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        return posResult;
    }

    @Override
    public POSResult writeDocToServerFirst(POSRegistery register, List<PaymentInfo> creditNoteInfos) {
        POSResult posResult = new POSResult();
        List<ServiceResponse> serviceResponses = POSDataWriterUtil.writeOrderReservationToNamaFirst(register, Arrays.asList(this));
        if (ObjectChecker.isNotEmptyOrNull(serviceResponses) && !serviceResponses.get(0).succeded()) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        return posResult;
    }

    @Override
    public NaMaDTO toDTO() {
        DTONamaPOSOrderReservation dtoNamaPOSOrderReservation = new DTONamaPOSOrderReservation();
        dtoNamaPOSOrderReservation.setDeliveryDate(this.getDeliveryDate());
        dtoNamaPOSOrderReservation.setDeliveryTime(new Date(this.calcMilliSecFromString(this.getStrDeliveryTime())));
        dtoNamaPOSOrderReservation.setFromTime(this.adjustTimeForTimeZoneDiff(this.getFromTime()));
        dtoNamaPOSOrderReservation.setToTime(this.adjustTimeForTimeZoneDiff(this.getToTime()));
        dtoNamaPOSOrderReservation.setReservationDate(this.getReservationDate());
        dtoNamaPOSOrderReservation.setReservationAmount(this.getReservationAmount());
        POSActualDTOConverter.convertToDTO(this, (DTOAbsPOSSalesDoc)dtoNamaPOSOrderReservation);
        return dtoNamaPOSOrderReservation;
    }
}

