/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.HasDTODimensionsRef;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import com.namasoft.modules.supplychain.contracts.details.DTOAbsPricingRangeInvoiceLine;
import com.namasoft.modules.supplychain.contracts.details.DTOAbsPricingRangeItemLine;
import com.namasoft.modules.supplychain.contracts.entities.DTOPricingRange;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSPricingRangeInvoiceLine;
import com.namasoft.pos.domain.details.AbsPOSPricingRangeItemLine;
import com.namasoft.pos.domain.details.POSPricingRangeExcludedInvoiceLine;
import com.namasoft.pos.domain.details.POSPricingRangeExcludedItemLine;
import com.namasoft.pos.domain.details.POSPricingRangeIncludedInvoiceLine;
import com.namasoft.pos.domain.details.POSPricingRangeIncludedItemLine;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemBrand;
import com.namasoft.pos.domain.entities.POSItemCategory;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass10;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemClass3;
import com.namasoft.pos.domain.entities.POSItemClass4;
import com.namasoft.pos.domain.entities.POSItemClass5;
import com.namasoft.pos.domain.entities.POSItemClass6;
import com.namasoft.pos.domain.entities.POSItemClass7;
import com.namasoft.pos.domain.entities.POSItemClass8;
import com.namasoft.pos.domain.entities.POSItemClass9;
import com.namasoft.pos.domain.entities.POSItemSection;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.valueobjects.POSEntityRefData;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.List;

@Entity
public class POSPricingRange
extends POSMasterFile<DTOPricingRange> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    private List<POSPricingRangeIncludedItemLine> includedItems;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    private List<POSPricingRangeExcludedItemLine> excludedItems;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    private List<POSPricingRangeIncludedInvoiceLine> includedInvoices;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    private List<POSPricingRangeExcludedInvoiceLine> excludedInvoices;

    public List<POSPricingRangeIncludedItemLine> getIncludedItems() {
        if (this.includedItems == null) {
            this.includedItems = new ArrayList<POSPricingRangeIncludedItemLine>();
        }
        return this.includedItems;
    }

    public void setIncludedItems(List<POSPricingRangeIncludedItemLine> includedItems) {
        this.includedItems = includedItems;
    }

    public List<POSPricingRangeExcludedItemLine> getExcludedItems() {
        if (this.excludedItems == null) {
            this.excludedItems = new ArrayList<POSPricingRangeExcludedItemLine>();
        }
        return this.excludedItems;
    }

    public void setExcludedItems(List<POSPricingRangeExcludedItemLine> excludedItems) {
        this.excludedItems = excludedItems;
    }

    public List<POSPricingRangeIncludedInvoiceLine> getIncludedInvoices() {
        if (this.includedInvoices == null) {
            this.includedInvoices = new ArrayList<POSPricingRangeIncludedInvoiceLine>();
        }
        return this.includedInvoices;
    }

    public void setIncludedInvoices(List<POSPricingRangeIncludedInvoiceLine> includedInvoices) {
        this.includedInvoices = includedInvoices;
    }

    public List<POSPricingRangeExcludedInvoiceLine> getExcludedInvoices() {
        if (this.excludedInvoices == null) {
            this.excludedInvoices = new ArrayList<POSPricingRangeExcludedInvoiceLine>();
        }
        return this.excludedInvoices;
    }

    public void setExcludedInvoices(List<POSPricingRangeExcludedInvoiceLine> excludedInvoices) {
        this.excludedInvoices = excludedInvoices;
    }

    @Override
    public void initializeLists() {
        this.getIncludedItems().size();
        this.getExcludedItems().size();
        this.getIncludedInvoices().size();
        this.getExcludedInvoices().size();
    }

    @Override
    public void updateData(DTOPricingRange dtoPricingRange) {
        int i;
        super.updateData(dtoPricingRange);
        CollectionsUtility.makeSecondSameSize((List)dtoPricingRange.getIncludedItems(), this.getIncludedItems(), POSPricingRangeIncludedItemLine::new);
        for (i = 0; i < dtoPricingRange.getIncludedItems().size(); ++i) {
            DTOAbsPricingRangeItemLine dtoPricingRangeIncludedItemLine = (DTOAbsPricingRangeItemLine)dtoPricingRange.getIncludedItems().get(i);
            this.updateItemLine(this.getIncludedItems(), i, dtoPricingRangeIncludedItemLine);
        }
        CollectionsUtility.makeSecondSameSize((List)dtoPricingRange.getExcludedItems(), this.getExcludedItems(), POSPricingRangeExcludedItemLine::new);
        for (i = 0; i < dtoPricingRange.getExcludedItems().size(); ++i) {
            DTOAbsPricingRangeItemLine dtoPricingRangeExcludedItemLine = (DTOAbsPricingRangeItemLine)dtoPricingRange.getExcludedItems().get(i);
            this.updateItemLine(this.getExcludedItems(), i, dtoPricingRangeExcludedItemLine);
        }
        CollectionsUtility.makeSecondSameSize((List)dtoPricingRange.getIncludedInvoices(), this.getIncludedInvoices(), POSPricingRangeIncludedInvoiceLine::new);
        for (i = 0; i < dtoPricingRange.getIncludedInvoices().size(); ++i) {
            DTOAbsPricingRangeInvoiceLine dtoPricingRangeIncludedInvoiceLine = (DTOAbsPricingRangeInvoiceLine)dtoPricingRange.getIncludedInvoices().get(i);
            this.updateInvoiceLine(this.getIncludedInvoices(), i, dtoPricingRangeIncludedInvoiceLine, dtoPricingRange);
        }
        CollectionsUtility.makeSecondSameSize((List)dtoPricingRange.getExcludedInvoices(), this.getExcludedInvoices(), POSPricingRangeExcludedInvoiceLine::new);
        for (i = 0; i < dtoPricingRange.getExcludedInvoices().size(); ++i) {
            DTOAbsPricingRangeInvoiceLine dtoPricingRangeExcludedInvoiceLine = (DTOAbsPricingRangeInvoiceLine)dtoPricingRange.getExcludedInvoices().get(i);
            this.updateInvoiceLine(this.getExcludedInvoices(), i, dtoPricingRangeExcludedInvoiceLine, dtoPricingRange);
        }
    }

    public void updateItemLine(List<? extends AbsPOSPricingRangeItemLine> itemLines, int i, DTOAbsPricingRangeItemLine dtoPricingRangeItemLine) {
        itemLines.get(i).setItemCode(dtoPricingRangeItemLine.getItemCode());
        itemLines.get(i).setItem((POSItem)this.fromReference(dtoPricingRangeItemLine.getItem()));
        itemLines.get(i).setBrand((POSItemBrand)this.fromReference(dtoPricingRangeItemLine.getBrand()));
        itemLines.get(i).setCategory1((POSItemCategory)this.fromReference(dtoPricingRangeItemLine.getCategory1()));
        itemLines.get(i).setCategory2((POSItemCategory)this.fromReference(dtoPricingRangeItemLine.getCategory2()));
        itemLines.get(i).setCategory3((POSItemCategory)this.fromReference(dtoPricingRangeItemLine.getCategory3()));
        itemLines.get(i).setCategory4((POSItemCategory)this.fromReference(dtoPricingRangeItemLine.getCategory4()));
        itemLines.get(i).setCategory5((POSItemCategory)this.fromReference(dtoPricingRangeItemLine.getCategory5()));
        itemLines.get(i).setItemClass1((POSItemClass1)this.fromReference(dtoPricingRangeItemLine.getItemClass1()));
        itemLines.get(i).setItemClass2((POSItemClass2)this.fromReference(dtoPricingRangeItemLine.getItemClass2()));
        itemLines.get(i).setItemClass3((POSItemClass3)this.fromReference(dtoPricingRangeItemLine.getItemClass3()));
        itemLines.get(i).setItemClass4((POSItemClass4)this.fromReference(dtoPricingRangeItemLine.getItemClass4()));
        itemLines.get(i).setItemClass5((POSItemClass5)this.fromReference(dtoPricingRangeItemLine.getItemClass5()));
        itemLines.get(i).setItemClass6((POSItemClass6)this.fromReference(dtoPricingRangeItemLine.getItemClass6()));
        itemLines.get(i).setItemClass7((POSItemClass7)this.fromReference(dtoPricingRangeItemLine.getItemClass7()));
        itemLines.get(i).setItemClass8((POSItemClass8)this.fromReference(dtoPricingRangeItemLine.getItemClass8()));
        itemLines.get(i).setItemClass9((POSItemClass9)this.fromReference(dtoPricingRangeItemLine.getItemClass9()));
        itemLines.get(i).setItemClass10((POSItemClass10)this.fromReference(dtoPricingRangeItemLine.getItemClass10()));
        itemLines.get(i).setItemSection((POSItemSection)this.fromReference(dtoPricingRangeItemLine.getItemSection()));
        POSItemSpecificDimensions.fromDTOItemSpecificDimensions(dtoPricingRangeItemLine.getSpecificDimensions());
    }

    public void updateInvoiceLine(List<? extends AbsPOSPricingRangeInvoiceLine> invoiceLines, int i, DTOAbsPricingRangeInvoiceLine dtoPricingRangeInvoiceLine, DTOPricingRange dtoPricingRange) {
        invoiceLines.get(i).setCustomer(POSEntityRefData.fromEntityRefData(dtoPricingRangeInvoiceLine.getCustomer()));
        invoiceLines.get(i).setInvoiceClassification((POSInvoiceClassification)this.fromReference(dtoPricingRangeInvoiceLine.getInvoiceClassification()));
        invoiceLines.get(i).setPriceClassifier1((POSSalesPriceClassifier1)this.fromReference(dtoPricingRangeInvoiceLine.getPriceClassifier1()));
        invoiceLines.get(i).setPriceClassifier2((POSSalesPriceClassifier2)this.fromReference(dtoPricingRangeInvoiceLine.getPriceClassifier2()));
        invoiceLines.get(i).setPriceClassifier3((POSSalesPriceClassifier3)this.fromReference(dtoPricingRangeInvoiceLine.getPriceClassifier3()));
        invoiceLines.get(i).setPriceClassifier4((POSSalesPriceClassifier4)this.fromReference(dtoPricingRangeInvoiceLine.getPriceClassifier4()));
        invoiceLines.get(i).setPriceClassifier5((POSSalesPriceClassifier5)this.fromReference(dtoPricingRangeInvoiceLine.getPriceClassifier5()));
        if (dtoPricingRangeInvoiceLine.getDimensions() == null) {
            dtoPricingRangeInvoiceLine.setDimensions(new DTOGenericDimensions());
        }
        POSGenericDims.fromNamaGenericDims(dtoPricingRangeInvoiceLine.getDimensions().updateDimensionsIfNull((HasDTODimensionsRef)dtoPricingRange));
    }

    @Override
    public String calcNamaEntityType() {
        return "PricingRange";
    }

    @Override
    public void assignIds() {
        this.getIncludedItems().forEach(AbsPOSPricingRangeItemLine::getId);
        this.getExcludedItems().forEach(AbsPOSPricingRangeItemLine::getId);
        this.getIncludedInvoices().forEach(AbsPOSPricingRangeInvoiceLine::getId);
        this.getExcludedInvoices().forEach(AbsPOSPricingRangeInvoiceLine::getId);
    }
}

