/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.HasIDUtil;
import com.namasoft.common.constants.AttachmentType;
import com.namasoft.common.constants.Language;
import com.namasoft.common.constants.OutputFormat;
import com.namasoft.common.criteria.DTOFilledQuestionField;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.FieldTypesUtils;
import com.namasoft.common.layout.list.QuestionField;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.layout.metadata.ReportMetadata;
import com.namasoft.common.layout.metadata.ReportMetadataContainer;
import com.namasoft.common.layout.metadata.ReportQuestionFieldMetadata;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.LoggingConfigurator;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.NaMaLayersConnector;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.common.utils.translation.TranslationUtil;
import com.namasoft.contracts.common.dtos.DTOLargeData;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.contracts.common.dtos.requests.ByIdRequest;
import com.namasoft.contracts.common.dtos.requests.ReadAttachmentRequest;
import com.namasoft.contracts.common.dtos.requests.ReportWithSubRepReq;
import com.namasoft.contracts.common.dtos.requests.RunReportRequest;
import com.namasoft.contracts.common.dtos.results.DTORunReportResultWithData;
import com.namasoft.contracts.common.dtos.results.ReadAttachmentResult;
import com.namasoft.contracts.common.services.CoreWS;
import com.namasoft.contracts.common.services.ReportingWS;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.basic.contracts.details.DTOReportRelatedForms;
import com.namasoft.modules.basic.contracts.details.DTOSubReport;
import com.namasoft.modules.basic.contracts.entities.DTOReportDefinition;
import com.namasoft.pos.application.IPOSHasDims;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSReportDefinitionLine;
import com.namasoft.pos.domain.details.POSReportResource;
import com.namasoft.pos.domain.details.POSSubReport;
import com.namasoft.pos.domain.entities.POSHasUpdateDataWithSession;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSLegalEntity;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.domain.reporting.POSJasperReportRunner;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.util.POSDataReaderUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.TableCellCreatorUtil;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import com.namasoft.specialserialization.ReflectionUtils;
import com.namasoft.specialserialization.SimpleXMLMarshaller;
import jakarta.activation.DataHandler;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterName;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import net.sf.jasperreports.swing.JRViewer;
import net.sf.jasperreports.swing.JRViewerController;
import net.sf.jasperreports.swing.JRViewerToolbar;
import net.sf.jasperreports.view.JasperViewer;
import org.hibernate.HibernateException;
import org.hibernate.LobHelper;
import org.hibernate.Session;

@Entity
public class POSReportDefinition
extends POSMasterFile
implements POSHasUpdateDataWithSession<DTOReportDefinition>,
IPOSHasDims {
    private String formEntity;
    private String printerName;
    private Blob englishVersion;
    private Blob arabicVersion;
    private Boolean usedInFullInvoice;
    private Boolean runOnPosServerDB;
    private Boolean posOrderPreparationForm;
    private Boolean usedInCaptainOrder;
    private UUID userId;
    private UUID formDocCategoryId;
    private UUID formInvoiceClassificationId;
    private String repOrder;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="mainReport")
    @OrderColumn(name="lineNumber")
    private List<POSReportDefinitionLine> relatedForms;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="mainReport")
    @OrderColumn(name="lineNumber")
    private List<POSSubReport> subreports;
    private String reportType;
    @Lob
    private String metadataXML;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="mainReport")
    @OrderColumn(name="lineNumber")
    private List<POSReportResource> resources;

    @Override
    public void initializeLists() {
        this.getRelatedForms().size();
        this.getSubreports().size();
        this.getResources().size();
    }

    public <T extends MasterFileDTO> void updateData(DTOReportDefinition object) {
        super.updateData(object);
    }

    @Override
    public void afterCommitSuccessfully() {
        POSDataReaderUtil.cacheReportDefinitions();
    }

    @Override
    public void updateData(DTOReportDefinition object, Session session) {
        super.updateData(object);
        CoreWS coreWS = (CoreWS)ServiceUtility.getServiceClient(CoreWS.class);
        DTOReportDefinition dtoReportDefinition = this.copyBasicData(object, session, coreWS);
        this.copyRelatedReports(dtoReportDefinition);
        this.copySubReports(session, dtoReportDefinition, coreWS);
        this.getResources().clear();
        this.getResources().addAll(CollectionsUtility.convert((Collection)object.getResources(), object1 -> {
            POSReportResource resource = new POSReportResource();
            resource.setMainReport(this);
            resource.getId();
            resource.setReportFileName(object1.getReportFileName());
            resource.setResourceId(object1.getResourceId());
            resource.setReportContent(object1.getReportContent());
            if (ObjectChecker.isNotEmptyOrNull((Object)object1.getResourceFile().getAttachmentInfo().getFileId())) {
                ReadAttachmentRequest attachmentRequest = new ReadAttachmentRequest();
                attachmentRequest.setOwnerEntityType("ReportDefinition");
                attachmentRequest.setFileId(object1.getResourceFile().getAttachmentInfo().getFileId());
                attachmentRequest.setAttachmentType(AttachmentType.ORIGINAL);
                CoreWS corews = (CoreWS)ServiceUtility.getServiceClient(CoreWS.class);
                ReadAttachmentResult readAttachmentResp = corews.readAttachment(attachmentRequest);
                resource.setResourceFile(POSReportDefinition.createBlobFromDataHanler(readAttachmentResp.getData(), (int)object1.getResourceFile().getDataLength(), session));
            }
            return resource;
        }));
        ReportingWS webService = (ReportingWS)ServiceUtility.getUtilityServiceClient(ReportingWS.class, (String)"basic");
        ReportMetadataContainer metadataContainer = (ReportMetadataContainer)webService.getReportMetadata(new ByIdRequest("ReportDefinition", object.getId())).getData();
        this.setMetadataXML(SimpleXMLMarshaller.getInstance().marshal((Object)metadataContainer.getMetadata()));
    }

    private <T extends MasterFileDTO> DTOReportDefinition copyBasicData(DTOReportDefinition object, Session session, CoreWS coreWS) {
        DTOReportDefinition dtoReportDefinition = object;
        this.setFormEntity(dtoReportDefinition.getFormEntity());
        this.setRunOnPosServerDB(dtoReportDefinition.getRunOnPosServerDB());
        if (dtoReportDefinition.getFormDocCategory() != null) {
            this.setFormDocCategoryId(ServerStringUtils.strToUUID((String)dtoReportDefinition.getFormDocCategory().getId()));
        } else {
            this.setFormDocCategoryId(null);
        }
        if (dtoReportDefinition.getFormInvoiceClassification() != null) {
            this.setFormInvoiceClassificationId(ServerStringUtils.strToUUID((String)dtoReportDefinition.getFormInvoiceClassification().getId()));
        } else {
            this.setFormInvoiceClassificationId(null);
        }
        this.setPrinterName(dtoReportDefinition.getPrinterName());
        DTOLargeData arabic = (DTOLargeData)coreWS.getReportArabicVersion(new ReportWithSubRepReq("ReportDefinition", this.getCode())).getData();
        DTOLargeData english = (DTOLargeData)coreWS.getReportEnglishVersion(new ReportWithSubRepReq("ReportDefinition", this.getCode())).getData();
        this.setArabicVersion(POSReportDefinition.createBlobFromDataHanler(arabic.getData(), (int)arabic.getDataLength(), session));
        this.setEnglishVersion(POSReportDefinition.createBlobFromDataHanler(english.getData(), (int)english.getDataLength(), session));
        this.setUsedInFullInvoice(dtoReportDefinition.getUsedInFullInvoice());
        this.setPosOrderPreparationForm(dtoReportDefinition.getPosOrderPreparationForm());
        this.setUsedInCaptainOrder(dtoReportDefinition.getUsedInCaptainOrder());
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoReportDefinition.getForUser())) {
            this.setUserId(ServerStringUtils.strToUUID((String)dtoReportDefinition.getForUser().getId()));
        }
        this.setRepOrder(dtoReportDefinition.getReportOrder());
        this.setReportType(object.getReportType());
        return dtoReportDefinition;
    }

    private void copySubReports(Session session, DTOReportDefinition dtoReportDefinition, CoreWS coreWS) {
        this.getSubreports().clear();
        List subReports = dtoReportDefinition.getSubreports();
        for (DTOSubReport dtoSubReport : subReports) {
            POSSubReport posSubReport = new POSSubReport();
            posSubReport.assignIds();
            posSubReport.setMainReport(this);
            posSubReport.setReportFileName(dtoSubReport.getReportFileName());
            DTOLargeData subArabic = (DTOLargeData)coreWS.getReportArabicVersion(new ReportWithSubRepReq("ReportDefinition", this.getCode(), dtoSubReport.getId())).getData();
            DTOLargeData subEnglish = (DTOLargeData)coreWS.getReportEnglishVersion(new ReportWithSubRepReq("ReportDefinition", this.getCode(), dtoSubReport.getId())).getData();
            posSubReport.setArabicVersion(POSReportDefinition.createBlobFromDataHanler(subArabic.getData(), (int)subArabic.getDataLength(), session));
            posSubReport.setEnglishVersion(POSReportDefinition.createBlobFromDataHanler(subEnglish.getData(), (int)subEnglish.getDataLength(), session));
            posSubReport.setSubreportDefinition(POSReportDefinition.repFromReference(dtoSubReport.getSubreportDefinition()));
            posSubReport.setSubreportFile(POSReportDefinition.createBlobFromDataHanler(dtoSubReport.getSubreportFile().getData(), (int)dtoSubReport.getSubreportFile().getDataLength(), session));
            posSubReport.setSubreportId(dtoSubReport.getSubreportId());
            this.getSubreports().add(posSubReport);
        }
    }

    private void copyRelatedReports(DTOReportDefinition dtoReportDefinition) {
        this.getRelatedForms().clear();
        List relatedForms = dtoReportDefinition.getRelatedForms();
        for (DTOReportRelatedForms form : relatedForms) {
            POSReportDefinitionLine line = new POSReportDefinitionLine();
            line.setMainReport(this);
            line.setRelatedReportId(ServerStringUtils.strToUUID((String)form.getRelatedForm().getId()));
            line.assignIds();
            this.getRelatedForms().add(line);
        }
    }

    public static POSReportDefinition repFromReference(EntityReferenceData ref) {
        POSReportDefinition reportDefinition = null;
        if (ObjectChecker.isNotEmptyOrNull((Object)ref) && (reportDefinition = POSPersister.findByID(POSReportDefinition.class, ref.getId())) == null) {
            reportDefinition = new POSReportDefinition();
            DTOReportDefinition dtoReportDefinition = (DTOReportDefinition)POSPersister.getReference(ref);
            reportDefinition.updateData(dtoReportDefinition);
            POSPersister.saveOrUpdate(reportDefinition);
        }
        return reportDefinition;
    }

    public static Blob createBlobFromDataHanler(DataHandler data, int dataLength, Session session) {
        try {
            if (data == null) {
                return null;
            }
            return POSReportDefinition.createBlobFromStream(data.getInputStream(), dataLength, session);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Blob createBlobFromStream(InputStream stream, int dataLength, Session session) {
        LobHelper lobCreator = session.getLobHelper();
        Blob blob = lobCreator.createBlob(stream, (long)dataLength);
        return blob;
    }

    public String getFormEntity() {
        return this.formEntity;
    }

    public void setFormEntity(String formEntity) {
        this.formEntity = formEntity;
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }

    public Blob getEnglishVersion() {
        return this.englishVersion;
    }

    public void setEnglishVersion(Blob englishVersion) {
        this.englishVersion = englishVersion;
    }

    public Blob getArabicVersion() {
        return this.arabicVersion;
    }

    public void setArabicVersion(Blob arabicVersion) {
        this.arabicVersion = arabicVersion;
    }

    public void viewPrintDialog(POSRegistery register, HashMap<String, Object> parameters, boolean toDialog, Callback<Void> callback, boolean executeCallBack) {
        block9: {
            try {
                JasperPrint jasperPrint;
                ReportMetadata metadata = this.fetchMetadata();
                this.addSubReportParams(parameters, metadata);
                this.addResources(parameters, metadata);
                if (LoggingConfigurator.isInDebugMode()) {
                    toDialog = true;
                }
                if ((jasperPrint = this.fillReport(register, parameters, metadata)) == null || ObjectChecker.isEmptyOrNull((Object)jasperPrint.getPages())) {
                    return;
                }
                if (toDialog) {
                    JasperViewer jv = new JasperViewer(jasperPrint, false);
                    jv.setTitle(this.nameByLanguage());
                    jv.getToolkit().setDynamicLayout(true);
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    jv.setSize((int)(screenSize.getWidth() / 2.0), (int)(screenSize.getHeight() / 1.3));
                    jv.setAlwaysOnTop(true);
                    this.customizePrintBtnAction(callback, jv, executeCallBack);
                    jv.setVisible(true);
                } else {
                    if (ObjectChecker.isNotEmptyOrNull((Object)this.getPrinterName()) || ObjectChecker.toZeroIfNull((Integer)register.getDocumentsPrintCount()) > 1) {
                        this.printReportToPrinter(register, jasperPrint, this.getPrinterName());
                    } else {
                        JasperPrintManager.printReport((JasperPrint)jasperPrint, (boolean)toDialog);
                    }
                    if (executeCallBack) {
                        callback.done(null);
                    }
                }
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
                if (!executeCallBack) break block9;
                callback.done(null);
            }
        }
    }

    private void printReportToPrinter(POSRegistery register, JasperPrint jasperPrint, String selectedPrinter) throws JRException {
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        printRequestAttributeSet.add(new Copies(register.getDocumentsPrintCount()));
        if (jasperPrint.getOrientationValue() == OrientationEnum.LANDSCAPE) {
            printRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        } else {
            printRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        }
        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
        SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
        configuration.setPrintRequestAttributeSet((PrintRequestAttributeSet)printRequestAttributeSet);
        PrintService selectedService = this.getPrintService(selectedPrinter);
        if (ObjectChecker.isNotEmptyOrNull((Object)selectedPrinter) && selectedService != null) {
            HashPrintServiceAttributeSet printServiceAttributeSet = new HashPrintServiceAttributeSet();
            printServiceAttributeSet.add(new PrinterName(selectedService.getName(), null));
            configuration.setPrintServiceAttributeSet((PrintServiceAttributeSet)printServiceAttributeSet);
        }
        configuration.setDisplayPageDialog(Boolean.valueOf(false));
        configuration.setDisplayPrintDialog(Boolean.valueOf(false));
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.setConfiguration((ExporterConfiguration)configuration);
        if (selectedService == null) {
            throw new JRException("Could not find a printer with the name " + selectedPrinter);
        }
        exporter.exportReport();
    }

    private PrintService getPrintService(String selectedPrinter) {
        if (ObjectChecker.isEmptyOrNull((Object)selectedPrinter)) {
            return PrintServiceLookup.lookupDefaultPrintService();
        }
        Object[] selectedPrinters = new String[]{};
        selectedPrinters = StringUtils.csvLineToList((String)selectedPrinter).toArray(selectedPrinters);
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService selectedService = null;
        if (services != null && services.length != 0) {
            for (PrintService service : services) {
                String existingPrinter = service.getName();
                if (!ObjectChecker.isAnyEqualToFirst((Object)existingPrinter, (Object[])selectedPrinters) && selectedPrinters.length != 0) continue;
                selectedService = service;
                break;
            }
        }
        return selectedService;
    }

    public void customizePrintBtnAction(final Callback<Void> callback, JasperViewer jv, boolean executeCallBack) throws NoSuchFieldException, IllegalAccessException {
        jv.addWindowListener((WindowListener)new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                callback.done(null);
            }
        });
        Field viewer = JasperViewer.class.getDeclaredField("viewer");
        viewer.setAccessible(true);
        JRViewer jrViewer = (JRViewer)viewer.get(jv);
        Field toolBarField = JRViewer.class.getDeclaredField("tlbToolBar");
        toolBarField.setAccessible(true);
        JRViewerToolbar toolbar = (JRViewerToolbar)toolBarField.get(jrViewer);
        Field btnField = toolbar.getClass().getDeclaredField("btnPrint");
        btnField.setAccessible(true);
        JButton printBtn = (JButton)btnField.get(toolbar);
        Field viewerContextField = toolbar.getClass().getDeclaredField("viewerContext");
        viewerContextField.setAccessible(true);
        JRViewerController viewerContext = (JRViewerController)viewerContextField.get(toolbar);
        for (ActionListener listener : printBtn.getActionListeners()) {
            printBtn.removeActionListener(listener);
        }
        printBtn.addActionListener(evt -> {
            Thread thread = new Thread(() -> {
                try {
                    jv.setAlwaysOnTop(false);
                    printBtn.setEnabled(false);
                    JasperPrintManager printManager = JasperPrintManager.getInstance((JasperReportsContext)viewerContext.getJasperReportsContext());
                    printManager.print(viewerContext.getJasperPrint(), true);
                }
                catch (Exception ex) {
                    NaMaLogger.error((Throwable)ex);
                    JOptionPane.showMessageDialog((Component)toolbar, viewerContext.getBundleString("error.printing"));
                }
                finally {
                    if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getAutoHidePreviewWithPrintBtnClick())) {
                        jv.hide();
                    } else {
                        printBtn.setEnabled(true);
                        jv.setAlwaysOnTop(true);
                    }
                    if (executeCallBack) {
                        callback.done(null);
                    }
                }
            });
            thread.setName("customizePrintBtnAction");
            thread.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
            thread.setDaemon(true);
            thread.start();
        });
    }

    public JasperPrint fillReport(POSRegistery register, HashMap<String, Object> parameters, ReportMetadata metadata) {
        POSReportDefinition.prepareSystemParameters(register, null, this, parameters);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            entry.setValue(this.sqlValue(entry.getValue()));
        }
        try {
            if (ObjectChecker.isTrue((Boolean)this.getRunOnPosServerDB())) {
                ReportingWS reportingWS = (ReportingWS)ServiceUtility.getUtilityServiceClient(ReportingWS.class);
                RunReportRequest request = new RunReportRequest();
                request.setReportId(ServerStringUtils.toUUIDStr((Object)this.getId()));
                request.setFormat(OutputFormat.JasperPrint);
                ArrayList params = new ArrayList();
                parameters.entrySet().stream().forEach(e -> {
                    QuestionField question = (QuestionField)HasIDUtil.find((String)((String)e.getKey()), (List)metadata.getQuestionFields());
                    params.add(new DTOFilledQuestionField((String)e.getKey(), FieldTypesUtils.toString((FieldType)(question != null ? question.getFieldType() : null), e.getValue()), e.getValue()));
                });
                request.setParameters(params);
                DTORunReportResultWithData result = reportingWS.runReportAndGetResultAsDataHandler(request);
                InputStream inputStream = result.getData().getInputStream();
                return JRLoader.loadJasperPrint((InputStream)inputStream, null);
            }
            Blob englishVersion = this.getEnglishVersion();
            Blob arabicVersion = this.getArabicVersion();
            Blob compiledVersion = POSResourcesUtil.isArabic() ? arabicVersion : englishVersion;
            POSJasperReportRunner instance = POSJasperReportRunner.instance();
            return instance.fillReport(compiledVersion.getBinaryStream(), parameters);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    public static void printForm(POSRegistery register, POSMasterFile o, Callback<Void> callback) {
        POSReportDefinition.printForm(register, o, callback, false);
    }

    public static void printForm(POSRegistery register, POSMasterFile o, Callback<Void> callback, boolean preparationForm) {
        if (POSResourcesUtil.disablePrinting.booleanValue()) {
            return;
        }
        RuntimeException calledFrom = new RuntimeException();
        Thread thread = new Thread(() -> {
            if (ObjectChecker.isEmptyOrNull(POSResourcesUtil.reportDefintions)) {
                callback.done(null);
                return;
            }
            List<POSReportDefinition> posReportDefinitions = POSReportDefinition.fetchReport(o.calcNamaEntityType(), o.fetchDocCategory(), o.getPosInvoiceClassification(), preparationForm, false);
            if (ObjectChecker.isEmptyOrNull(posReportDefinitions)) {
                callback.done(null);
                return;
            }
            for (int i = 0; i < posReportDefinitions.size(); ++i) {
                POSReportDefinition definition = posReportDefinitions.get(i);
                HashMap<String, Object> parameters = POSReportDefinition.prepareSystemParameters(register, o, definition, new HashMap<String, Object>());
                try {
                    POSReportDefinition.printUsingReportDefinition(register, definition, parameters, callback, o, false, i + 1 == posReportDefinitions.size(), preparationForm);
                    continue;
                }
                catch (HibernateException e) {
                    NaMaLogger.error((Throwable)calledFrom);
                    throw e;
                }
            }
        });
        thread.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
        thread.setDaemon(true);
        thread.start();
    }

    private static HashMap<String, Object> prepareSystemParameters(POSRegistery register, POSMasterFile o, POSReportDefinition posReportDefinition, HashMap<String, Object> parameters) {
        POSLegalEntity posLegalEntity;
        POSShiftOpen lastOpenShift;
        POSUser currentUser;
        if (o != null) {
            parameters.put("id", o.getId());
        }
        parameters.put("loginLanguage", ObjectChecker.toStringOrEmpty((Object)POSResourcesUtil.getCurrentLang()));
        parameters.put("guiServerURL", NaMaLayersConnector.getInstance().getGuiServerURL());
        parameters.put("externalServerURL", NaMaLayersConnector.getInstance().getGuiServerURL());
        if (posReportDefinition != null) {
            parameters.put("reportCode", posReportDefinition.getCode());
            parameters.put("reportName1", posReportDefinition.getName1());
            parameters.put("reportName2", posReportDefinition.getName2());
            parameters.put("reportId", posReportDefinition.getId());
        }
        if ((currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser()) != null) {
            parameters.put("loginUserId", currentUser.getId());
            parameters.put("loginUserCode", currentUser.getCode());
            parameters.put("loginUserName1", currentUser.getName1());
            parameters.put("loginUserName2", currentUser.getName2());
            parameters.put("loginEmployeeId", currentUser.getEmpId());
        }
        if ((lastOpenShift = POSResourcesUtil.fetchLastOpenShift(register)) != null) {
            parameters.put("posShiftCode", lastOpenShift.getCode());
        }
        if (register != null && ObjectChecker.isNotEmptyOrNull((Object)(posLegalEntity = register.fetchLegalEntity()))) {
            parameters.put("loginLegalEntityId", posLegalEntity.getId());
            parameters.put("loginLegalEntityCode", posLegalEntity.getCode());
            parameters.put("loginLegalEntityName1", posLegalEntity.getName1());
            parameters.put("loginLegalEntityName2", posLegalEntity.getName2());
            try {
                InputStream logo = register.fetchLogo();
                if (logo != null) {
                    parameters.put("loginLegalEntityLogo", logo);
                }
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
            }
        }
        for (POSSubReport subReport : posReportDefinition.getSubreports()) {
            Blob arabicVersion = subReport.getSubreportDefinition() == null ? subReport.getArabicVersion() : subReport.getSubreportDefinition().getArabicVersion();
            Blob englishVersion = subReport.getSubreportDefinition() == null ? subReport.getEnglishVersion() : subReport.getSubreportDefinition().getEnglishVersion();
            try {
                Blob blob = englishVersion;
                if (POSResourcesUtil.isArabic()) {
                    blob = arabicVersion;
                }
                Object subReportObj = JRLoader.loadObject((InputStream)blob.getBinaryStream());
                parameters.put(subReport.getSubreportId(), subReportObj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return parameters;
    }

    private static void printUsingReportDefinition(POSRegistery register, POSReportDefinition posReportDefinition, HashMap<String, Object> parameters, Callback<Void> callback, POSMasterFile o, boolean fromRelatedForm, boolean executeCallBack, boolean preparationForm) {
        if (ObjectChecker.isEmptyOrNull(posReportDefinition.getRelatedForms())) {
            posReportDefinition.viewPrintDialog(register, parameters, POSReportDefinition.viewPrintDialog(), callback, executeCallBack);
            if (!fromRelatedForm && !preparationForm) {
                o.setPrintCount(o.getPrintCount() + 1);
            }
            if (!fromRelatedForm) {
                if (!o.isOldDoc()) {
                    POSPersister.saveOrUpdate(o);
                } else {
                    POSPersister.execute("UPDATE " + o.getClass().getSimpleName() + " SET printCount=:printCount WHERE id = :id", POSPersister.params("printCount", o.getPrintCount(), "id", o.getId()));
                }
            }
            return;
        }
        posReportDefinition.viewPrintDialog(register, parameters, POSReportDefinition.viewPrintDialog(), (Callback<Void>)((Callback)c -> {
            for (POSReportDefinitionLine reportDefinitionLine : posReportDefinition.getRelatedForms()) {
                POSReportDefinition relatedForm;
                if (ObjectChecker.isEmptyOrNull((Object)reportDefinitionLine.getRelatedReportId()) || ObjectChecker.isEmptyOrNull((Object)(relatedForm = POSPersister.findByID(POSReportDefinition.class, reportDefinitionLine.getRelatedReportId().toString())))) continue;
                POSReportDefinition.printUsingReportDefinition(register, relatedForm, parameters, (Callback<Void>)Callback.NULL, o, true, executeCallBack, preparationForm);
            }
            callback.done(null);
        }), true);
    }

    public static List<String> exportReportTo(POSRegistery register, String fileType, boolean ignorePagination, POSMasterFile entity) {
        if (ObjectChecker.isEmptyOrNull(POSResourcesUtil.reportDefintions)) {
            return new ArrayList<String>();
        }
        List<POSReportDefinition> reportDefinitions = POSReportDefinition.fetchReport(entity.calcNamaEntityType(), entity.fetchDocCategory(), entity.getPosInvoiceClassification(), false, true);
        POSReportDefinition definition = (POSReportDefinition)CollectionsUtility.getFirst(reportDefinitions);
        if (ObjectChecker.isEmptyOrNull((Object)definition) || ObjectChecker.isNotEmptyOrNull(definition.getRelatedForms())) {
            return new ArrayList<String>();
        }
        try {
            List<String> images = POSReportDefinition.exportReportTo(register, fileType, ignorePagination, entity, definition);
            entity.setPrintCount(entity.getPrintCount() + 1);
            POSPersister.saveOrUpdate(entity);
            return images;
        }
        catch (HibernateException e) {
            NaMaLogger.error((Throwable)e);
            throw e;
        }
    }

    public static List<String> exportReportTo(POSRegistery register, String fileType, boolean ignorePagination, POSMasterFile entity, POSReportDefinition reportDefinition) {
        HashMap<String, Object> parameters = POSReportDefinition.prepareSystemParameters(register, entity, reportDefinition, new HashMap<String, Object>());
        ReportMetadata metadata = reportDefinition.fetchMetadata();
        reportDefinition.addSubReportParams(parameters, metadata);
        reportDefinition.addResources(parameters, metadata);
        parameters.put("IS_IGNORE_PAGINATION", ignorePagination);
        JasperPrint jasperPrint = reportDefinition.fillReport(register, parameters, metadata);
        if (jasperPrint == null || ObjectChecker.isEmptyOrNull((Object)jasperPrint.getPages())) {
            return new ArrayList<String>();
        }
        FileOutputStream outputStream = null;
        ArrayList<String> images = new ArrayList<String>();
        try {
            if (ObjectChecker.areEqual((Object)fileType, (Object)"pdf")) {
                File tempFile = File.createTempFile("tmp", "prnt");
                outputStream = new FileOutputStream(tempFile);
                JRPdfExporter pdfExporter = new JRPdfExporter();
                pdfExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                pdfExporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
                pdfExporter.exportReport();
                byte[] bytes = Files.readAllBytes(tempFile.toPath());
                images.add(Base64.getEncoder().encodeToString(bytes));
            } else {
                for (int pageIndex = 0; pageIndex < jasperPrint.getPages().size(); ++pageIndex) {
                    BufferedImage pageImage = new BufferedImage(jasperPrint.getPageWidth(), jasperPrint.getPageHeight(), 1);
                    JRGraphics2DExporter exporter = new JRGraphics2DExporter();
                    exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
                    output.setGraphics2D((Graphics2D)pageImage.getGraphics());
                    exporter.setExporterOutput((ExporterOutput)output);
                    SimpleGraphics2DReportConfiguration configuration = new SimpleGraphics2DReportConfiguration();
                    configuration.setPageIndex(Integer.valueOf(pageIndex));
                    exporter.setConfiguration((ReportExportConfiguration)configuration);
                    exporter.exportReport();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)pageImage, "png", bos);
                    images.add(Base64.getEncoder().encodeToString(bos.toByteArray()));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return images;
    }

    private static List<POSReportDefinition> fetchReport(String entityType, PosDocCategory docCategory, POSInvoiceClassification invoiceClassification, boolean preparationForm, boolean usedInCaptainOrder) {
        ArrayList<POSReportDefinition> reportDefinitions = new ArrayList<POSReportDefinition>();
        for (POSReportDefinition report : POSResourcesUtil.reportDefintions) {
            if (ObjectChecker.areNotEqual((Object)report.getFormEntity(), (Object)entityType) || ObjectChecker.areNotEqual((Object)report.getPosOrderPreparationForm(), (Object)preparationForm) || ObjectChecker.areNotEqual((Object)report.getUsedInCaptainOrder(), (Object)usedInCaptainOrder) || report.getFormDocCategoryId() != null && (docCategory == null || ObjectChecker.areNotEqual((Object)report.getFormDocCategoryId(), (Object)docCategory.getId())) || report.getFormInvoiceClassificationId() != null && (invoiceClassification == null || ObjectChecker.areNotEqual((Object)report.getFormInvoiceClassificationId(), (Object)invoiceClassification.getId()))) continue;
            reportDefinitions.add(report);
            if (preparationForm) continue;
            return reportDefinitions;
        }
        return reportDefinitions;
    }

    public static void printFullForm(POSRegistery register, POSMasterFile o, Callback<Void> callback) {
        POSReportDefinition reportDefinition = POSReportDefinition.fetchReportsForUSer(true, " formEntity =:entity ", POSPersister.params("entity", o.calcNamaEntityType())).stream().filter(r -> ObjectChecker.isFalseOrNull((Boolean)r.getUsedInCaptainOrder())).findFirst().orElse(null);
        if (reportDefinition != null) {
            HashMap<String, Object> parameters = POSReportDefinition.prepareSystemParameters(register, o, reportDefinition, new HashMap<String, Object>());
            reportDefinition.viewPrintDialog(register, parameters, POSReportDefinition.viewPrintDialog(), callback, true);
        }
    }

    public static List<POSReportDefinition> fetchReportsForUSer(boolean fullInvoice, String extraCriteria, HashMap<String, Object> extraParams) {
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        if (ObjectChecker.isEmptyOrNull((Object)currentUser)) {
            return new ArrayList<POSReportDefinition>();
        }
        Object criteria = " WHERE usedInFullInvoice = :usedInFullInvoice and (userId is null or userId = :userId or userId = :userGroupId or userId = :userProfileId ) ";
        if (ObjectChecker.isNotEmptyOrNull((Object)extraCriteria)) {
            criteria = (String)criteria + " and " + extraCriteria;
        }
        criteria = (String)criteria + " order by repOrder";
        String query = "FROM " + POSReportDefinition.class.getSimpleName() + (String)criteria;
        HashMap<String, Object> params = POSPersister.params("usedInFullInvoice", fullInvoice, "userId", currentUser.getId(), "userGroupId", currentUser.getGroupId(), "userProfileId", currentUser.getSecurityProfileId());
        if (ObjectChecker.isNotEmptyOrNull(extraParams)) {
            params.putAll(extraParams);
        }
        return POSPersister.searchFor(query, params);
    }

    public static Boolean viewPrintDialog() {
        String printToDialogProp = POSGeneralSettings.getProperty((String)"printToDialog");
        if (ObjectChecker.isEmptyOrNull((Object)printToDialogProp)) {
            return ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getPrintToDialog());
        }
        return ObjectChecker.areEqual((Object)printToDialogProp.trim(), (Object)"1") || ObjectChecker.isTrue((String)printToDialogProp);
    }

    @Override
    public String calcNamaEntityType() {
        return "ReportDefinition";
    }

    public void setUsedInFullInvoice(Boolean usedInFullInvoice) {
        this.usedInFullInvoice = usedInFullInvoice;
    }

    public Boolean getUsedInFullInvoice() {
        if (ObjectChecker.isEmptyOrNull((Object)this.usedInFullInvoice)) {
            return false;
        }
        return this.usedInFullInvoice;
    }

    public Boolean getPosOrderPreparationForm() {
        if (ObjectChecker.isEmptyOrNull((Object)this.posOrderPreparationForm)) {
            return false;
        }
        return this.posOrderPreparationForm;
    }

    public void setPosOrderPreparationForm(Boolean posOrderPreparationForm) {
        this.posOrderPreparationForm = posOrderPreparationForm;
    }

    public Boolean getUsedInCaptainOrder() {
        if (ObjectChecker.isEmptyOrNull((Object)this.usedInCaptainOrder)) {
            return false;
        }
        return this.usedInCaptainOrder;
    }

    public void setUsedInCaptainOrder(Boolean usedInCaptainOrder) {
        this.usedInCaptainOrder = usedInCaptainOrder;
    }

    public void setRepOrder(String repOrder) {
        this.repOrder = repOrder;
    }

    public String getRepOrder() {
        return this.repOrder;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public UUID getFormDocCategoryId() {
        return this.formDocCategoryId;
    }

    public void setFormDocCategoryId(UUID formDocCategoryId) {
        this.formDocCategoryId = formDocCategoryId;
    }

    public UUID getFormInvoiceClassificationId() {
        return this.formInvoiceClassificationId;
    }

    public void setFormInvoiceClassificationId(UUID formInvoiceClassificationId) {
        this.formInvoiceClassificationId = formInvoiceClassificationId;
    }

    public List<POSReportDefinitionLine> getRelatedForms() {
        if (this.relatedForms == null) {
            this.relatedForms = new ArrayList<POSReportDefinitionLine>();
        }
        return this.relatedForms;
    }

    public void setRelatedForms(List<POSReportDefinitionLine> relatedForms) {
        this.relatedForms = relatedForms;
    }

    public List<POSSubReport> getSubreports() {
        if (this.subreports == null) {
            this.subreports = new ArrayList<POSSubReport>();
        }
        return this.subreports;
    }

    public void setSubreports(List<POSSubReport> subreports) {
        this.subreports = subreports;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public void setMetadataXML(String metadataXML) {
        this.metadataXML = metadataXML;
    }

    public String getMetadataXML() {
        return this.metadataXML;
    }

    public ReportMetadata fetchMetadata() {
        return (ReportMetadata)SimpleXMLMarshaller.getInstance().unmarshal(ReportMetadata.class, this.getMetadataXML());
    }

    public void addResources(HashMap<String, Object> parameters, ReportMetadata metadata) {
        try {
            List<POSReportResource> resources = this.calcResources();
            if (ObjectChecker.isNotEmptyOrNull(resources)) {
                for (POSReportResource reportResource : resources) {
                    if (this.shouldNotAddParameter(reportResource.getResourceId(), metadata)) continue;
                    parameters.put(reportResource.getResourceId(), reportResource.getResourceFile().getBinaryStream());
                }
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Object)"cannot process report resources");
            NaMaLogger.error((Throwable)e);
        }
    }

    private List<POSReportResource> calcResources() {
        return this.calcResources(new ArrayList<POSReportResource>(), new HashSet<String>());
    }

    private List<POSReportResource> calcResources(List<POSReportResource> resources, HashSet<String> added) {
        if (ObjectChecker.isNotEmptyOrNull(this.getResources())) {
            for (POSReportResource resource : this.getResources()) {
                if (!added.add(resource.getResourceId())) continue;
                resources.add(resource);
            }
        }
        return resources;
    }

    public void addSubReportParams(HashMap<String, Object> parameters, ReportMetadata metadata) {
        List<POSSubReport> subReports = this.calcSupReports();
        if (ObjectChecker.isNotEmptyOrNull(subReports)) {
            for (POSSubReport subReport : subReports) {
                if (this.shouldNotAddParameter(subReport.getSubreportId(), metadata)) continue;
                Blob arabicVersion = subReport.getSubreportDefinition() == null ? subReport.getArabicVersion() : subReport.getSubreportDefinition().getArabicVersion();
                Blob englishVersion = subReport.getSubreportDefinition() == null ? subReport.getEnglishVersion() : subReport.getSubreportDefinition().getEnglishVersion();
                try {
                    InputStream stream = ObjectChecker.areEqual((Object)POSResourcesUtil.getCurrentLang(), (Object)Language.Arabic) ? arabicVersion.getBinaryStream() : englishVersion.getBinaryStream();
                    Object reportObject = this.loadCompiledReport(stream);
                    stream.close();
                    parameters.put(subReport.getSubreportId(), reportObject);
                }
                catch (Exception e) {
                    NaMaLogger.error((Throwable)e);
                }
            }
        }
    }

    public Object loadCompiledReport(InputStream stream) throws JRException {
        return JRLoader.loadObject((InputStream)stream);
    }

    private boolean shouldNotAddParameter(String paramId, ReportMetadata metadata) {
        return !this.shouldAddParameter(paramId, metadata);
    }

    private boolean shouldAddParameter(String paramId, ReportMetadata metadata) {
        return metadata.getAllParameterIds() == null || Collections.binarySearch(metadata.getAllParameterIds(), paramId) >= 0;
    }

    public List<POSSubReport> calcSupReports() {
        return this.calcSupReports(new ArrayList<POSSubReport>(), new HashSet<String>());
    }

    private List<POSSubReport> calcSupReports(List<POSSubReport> subReports, HashSet<String> added) {
        if (ObjectChecker.isNotEmptyOrNull(this.getSubreports())) {
            for (POSSubReport subReport : this.getSubreports()) {
                if (!added.add(subReport.getSubreportId())) continue;
                subReports.add(subReport);
            }
        }
        return subReports;
    }

    public void addQuestionFieldMetadataParams(HashMap<String, Object> parameters, List<? extends POSField> fields, ReportMetadata metadata) {
        if (ObjectChecker.isEmptyOrNull((Object)metadata.getMetadata())) {
            return;
        }
        for (ReportQuestionFieldMetadata question : metadata.getMetadata()) {
            if (!ObjectChecker.isNotEmptyOrNull((Object)question.getSourceParameter())) continue;
            Object value = null;
            POSField src = this.find(question.getSourceParameter(), fields);
            if (src != null) {
                value = src.fetchValue();
            }
            this.addParameter(parameters, value, question.getId(), metadata);
        }
    }

    public POSField find(String id, List<? extends POSField> list) {
        if (ObjectChecker.isNotEmptyOrNull(list)) {
            for (POSField pOSField : list) {
                if (!ObjectChecker.areEqual((Object)id, (Object)pOSField.getId())) continue;
                return pOSField;
            }
        }
        return null;
    }

    public void addParameter(HashMap<String, Object> map, Object value, String id, ReportMetadata reportMetadata) {
        ReportQuestionFieldMetadata metadata = reportMetadata == null ? null : (ReportQuestionFieldMetadata)HasIDUtil.find((String)id, (List)reportMetadata.getMetadata());
        if (metadata == null) {
            metadata = new ReportQuestionFieldMetadata();
        }
        if (ObjectChecker.isEmptyOrNull((Object)value)) {
            Object emptyValue = reportMetadata != null ? this.emptyValue(metadata, reportMetadata.getQuestionField(id)) : null;
            map.put(id, this.sqlValue(emptyValue));
            map.put("original_" + id, this.sqlValue(value));
        } else {
            if (value instanceof POSMasterFile) {
                map.put("original_" + id, POSReportDefinition.marshalInString(value));
                value = POSReportDefinition.fetchPropertyIfNeeded(value, metadata);
            } else if (value instanceof List) {
                List l = (List)value;
                map.put(id + "_csv", StringUtils.toCSVLineWithSep((String)", ", (List)CollectionsUtility.convert((Collection)((List)value), v -> TranslationUtil.translateArgument((Language)POSResourcesUtil.getCurrentLang(), (Object)v))));
                for (int i = 0; i < l.size(); ++i) {
                    Object subV = POSReportDefinition.fetchPropertyIfNeeded(l.get(i), metadata);
                    l.set(i, subV);
                }
            }
            map.put(id, this.sqlValue(value));
        }
    }

    private static Object fetchPropertyIfNeeded(Object value, ReportQuestionFieldMetadata metadata) {
        if (!(value instanceof POSMasterFile)) {
            return value;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)metadata.getProperty())) {
            Object property = null;
            switch (metadata.getProperty()) {
                case "id": {
                    property = ((POSMasterFile)value).getId();
                    break;
                }
                case "code": {
                    property = ((POSMasterFile)value).getCode();
                    break;
                }
                case "entityType": {
                    property = ((POSMasterFile)value).calcNamaEntityType();
                }
            }
            if (property == null && (property = ReflectionUtils.getFieldValue((String)metadata.getProperty(), (Object)value)) == null) {
                NaMaLogger.error((Object)("Could not fetch property " + metadata.getProperty() + " for type " + ((POSMasterFile)value).calcNamaEntityType()));
            }
            value = property;
        } else {
            value = ((POSMasterFile)value).getId();
        }
        return value;
    }

    public static <T> String marshalInString(T source) {
        if (ObjectChecker.isEmptyOrNull(source)) {
            return "";
        }
        if (source instanceof POSMasterFile) {
            return String.valueOf(((POSMasterFile)source).getId()) + ":" + ((POSMasterFile)source).calcNamaEntityType() + ":" + ((POSMasterFile)source).getCode() + ":" + ((POSMasterFile)source).getCode();
        }
        return ObjectChecker.toStringOrEmpty(source);
    }

    public Object sqlValue(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof List) {
            List listVal = (List)value;
            for (int i = 0; i < listVal.size(); ++i) {
                listVal.set(i, this.sqlValue(listVal.get(i)));
            }
            return listVal;
        }
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return this.toBytes(uuid);
        }
        if (value instanceof Enum) {
            return value.toString();
        }
        return value;
    }

    public byte[] toBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    private Object emptyValue(ReportQuestionFieldMetadata metadata, QuestionField questionField) {
        if (metadata == null || ObjectChecker.isEmptyOrNull((Object)metadata.getNullType()) || questionField == null) {
            return null;
        }
        if (questionField.getFieldType() == FieldType.Reference && ObjectChecker.isNotEmptyOrNull((Object)metadata.getProperty())) {
            Class fieldClass = null;
            switch (metadata.getProperty()) {
                case "id": {
                    fieldClass = UUID.class;
                    break;
                }
                case "code": {
                    fieldClass = String.class;
                    break;
                }
                case "entityType": {
                    fieldClass = String.class;
                }
            }
            return ObjectCreatorUtil.creator(fieldClass).create();
        }
        if (questionField.getFieldType() == FieldType.Date) {
            return ObjectCreatorUtil.creator(Date.class).create();
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)questionField.getDomainClassName())) {
            try {
                return ObjectCreatorUtil.creator(Class.forName(questionField.getDomainClassName())).create();
            }
            catch (ClassNotFoundException e) {
                NaMaLogger.error((Throwable)e);
            }
        }
        return null;
    }

    public List<POSReportResource> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<POSReportResource>();
        }
        return this.resources;
    }

    public void setResources(List<POSReportResource> resources) {
        this.resources = resources;
    }

    @Override
    public POSGenericDims fetchGenericDims() {
        return this.getGenericDims();
    }

    @Override
    public POSDimInfo getAnalysisSet() {
        return this.getGenericDims().getAnalysisSet();
    }

    @Override
    public POSDimInfo getLegalEntity() {
        return this.getGenericDims().getLegalEntity();
    }

    @Override
    public POSDimInfo getBranch() {
        return this.getGenericDims().getBranch();
    }

    @Override
    public POSDimInfo getSector() {
        return this.getGenericDims().getSector();
    }

    @Override
    public POSDimInfo getDepartment() {
        return this.getGenericDims().getDepartment();
    }

    @Override
    public void setLegalEntity(POSDimInfo legalEntity) {
        this.getGenericDims().setLegalEntity(legalEntity);
    }

    @Override
    public void setBranch(POSDimInfo branch) {
        this.getGenericDims().setBranch(branch);
    }

    @Override
    public void setSector(POSDimInfo sector) {
        this.getGenericDims().setSector(sector);
    }

    @Override
    public void setDepartment(POSDimInfo dept) {
        this.getGenericDims().setDepartment(dept);
    }

    @Override
    public void setAnalysisSet(POSDimInfo analysisSet) {
        this.getGenericDims().setAnalysisSet(analysisSet);
    }

    public Boolean getRunOnPosServerDB() {
        return this.runOnPosServerDB;
    }

    public void setRunOnPosServerDB(Boolean runOnPosServerDB) {
        this.runOnPosServerDB = runOnPosServerDB;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        return creatorUtil.createColumns(Arrays.asList("code", "name1", "name2", "runOnPosServerDB"));
    }
}

