/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.SafeBigDecimal;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSSalesExternalPaymentLine;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSSalesInvoice;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSCreditNoteAndCouponUtil;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.AbsPOSSalesTableLine;
import com.namasoft.pos.domain.details.POSInvoiceTableLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceCouponLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceCreditNoteLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceRemovedLine;
import com.namasoft.pos.domain.details.POSSalesPaymentLine;
import com.namasoft.pos.domain.entities.IHasReservationAmount;
import com.namasoft.pos.domain.entities.IPOSFromReplacement;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSDiscountCoupon;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import com.namasoft.pos.domain.entities.PosTableEntry;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSResult;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hibernate.Session;

@Entity
public class POSSalesInvoice
extends AbsPOSSales
implements IPOSFromReplacement,
IHasReservationAmount {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSSalesInvoiceLine> details;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSSalesInvoiceRemovedLine> removedLines;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSSalesPaymentLine> paymentLines;
    private Boolean returnBefore = false;
    private String replacementCode;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSSalesInvoiceCreditNoteLine> creditNotes;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSSalesInvoiceCouponLine> coupons;
    @Column(length=16)
    private UUID replacementId;
    private UUID heldInvoiceId;
    private Boolean splitInvoice = false;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSInvoiceTableLine> tableLines;
    private BigDecimal reservationAmount;
    private Boolean fromCaptainOrder = false;
    private Boolean fromCallCenter = false;
    private UUID discountApplier;
    private UUID orderRegisterId;
    @Transient
    private boolean writeHeldInvoiceToServer = false;
    @Transient
    private boolean sentHeldToServer = false;

    @Override
    public BigDecimal getReservationAmount() {
        return this.reservationAmount;
    }

    public void setReservationAmount(BigDecimal reservationAmount) {
        this.reservationAmount = reservationAmount;
    }

    public Boolean getFromCaptainOrder() {
        if (this.fromCaptainOrder == null) {
            this.fromCaptainOrder = false;
        }
        return this.fromCaptainOrder;
    }

    public void setFromCaptainOrder(Boolean fromCaptainOrder) {
        this.fromCaptainOrder = fromCaptainOrder;
    }

    public Boolean getFromCallCenter() {
        if (this.fromCallCenter == null) {
            this.fromCallCenter = false;
        }
        return this.fromCallCenter;
    }

    public void setFromCallCenter(Boolean fromCallCenter) {
        this.fromCallCenter = fromCallCenter;
    }

    public UUID getDiscountApplier() {
        return this.discountApplier;
    }

    public void setDiscountApplier(UUID discountApplier) {
        this.discountApplier = discountApplier;
    }

    public UUID getOrderRegisterId() {
        return this.orderRegisterId;
    }

    public void setOrderRegisterId(UUID orderRegisterId) {
        this.orderRegisterId = orderRegisterId;
    }

    public List<POSInvoiceTableLine> getTableLines() {
        if (this.tableLines == null) {
            this.tableLines = new ArrayList<POSInvoiceTableLine>();
        }
        return this.tableLines;
    }

    @Override
    public <T extends AbsPOSSalesTableLine> T createTableLine() {
        return (T)new POSInvoiceTableLine();
    }

    @Override
    public <T extends AbsPOSSalesTableLine> List<T> fetchTables() {
        return this.getTableLines();
    }

    @Override
    public <T extends AbsPOSSalesTableLine> void updateTableLines(List<T> tableLines) {
        this.getTableLines().clear();
        this.getTableLines().addAll(tableLines);
    }

    public void setTableLines(List<POSInvoiceTableLine> tableLines) {
        this.tableLines = tableLines;
    }

    public Boolean getSplitInvoice() {
        return this.splitInvoice;
    }

    public void setSplitInvoice(Boolean splitInvoice) {
        this.splitInvoice = splitInvoice;
    }

    public POSSalesInvoice() {
    }

    public UUID getHeldInvoiceId() {
        return this.heldInvoiceId;
    }

    public void setHeldInvoiceId(UUID heldInvoiceId) {
        this.heldInvoiceId = heldInvoiceId;
    }

    public List<POSSalesInvoiceCouponLine> getCoupons() {
        if (this.coupons == null) {
            this.coupons = new ArrayList<POSSalesInvoiceCouponLine>();
        }
        return this.coupons;
    }

    public void setCoupons(List<POSSalesInvoiceCouponLine> coupons) {
        this.coupons = coupons;
    }

    public void setCreditNotes(List<POSSalesInvoiceCreditNoteLine> creditNotes) {
        this.creditNotes = creditNotes;
    }

    public List<POSSalesInvoiceCreditNoteLine> getCreditNotes() {
        if (this.creditNotes == null) {
            this.creditNotes = new ArrayList<POSSalesInvoiceCreditNoteLine>();
        }
        return this.creditNotes;
    }

    public List<POSSalesPaymentLine> getPaymentLines() {
        if (this.paymentLines == null) {
            this.paymentLines = new ArrayList<POSSalesPaymentLine>();
        }
        return this.paymentLines;
    }

    public void setPaymentLines(List<POSSalesPaymentLine> paymentLines) {
        this.paymentLines = paymentLines;
    }

    public POSSalesInvoice(AbsPosSalesScreen screen) {
        this.setDetails(new ArrayList<POSSalesInvoiceLine>());
        this.setPaymentLines(new ArrayList<POSSalesPaymentLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public List<POSSalesInvoiceLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSSalesInvoiceLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSSalesInvoiceLine> details_) {
        if (ObjectChecker.isEmptyOrNull(this.details)) {
            this.details = new ArrayList<POSSalesInvoiceLine>();
        }
        this.details.clear();
        this.details.addAll(details_);
    }

    public List<POSSalesInvoiceRemovedLine> getRemovedLines() {
        if (this.removedLines == null) {
            this.removedLines = new ArrayList<POSSalesInvoiceRemovedLine>();
        }
        return this.removedLines;
    }

    public void setRemovedLines(List<POSSalesInvoiceRemovedLine> removedLines) {
        this.removedLines = removedLines;
    }

    @Override
    public void postCommitAction(Session session) {
        List<POSTable> tables;
        POSSalesInvoice.deleteTableEntries(this.getId());
        if (ObjectChecker.isTrue((Boolean)this.getHold()) && ObjectChecker.isNotEmptyOrNull(tables = this.calcTables())) {
            for (POSTable table : tables) {
                PosTableEntry entry = new PosTableEntry();
                entry.assignIds();
                entry.setPosTable(table);
                entry.setBusyTable(true);
                entry.setDocumentId(this.getId());
                entry.setDocumentCode(this.getCode());
                entry.setValueDate(this.getValueDate());
                POSPersister.saveOrUpdate(entry);
            }
        }
        super.postCommitAction(session);
    }

    public static void deleteTableEntries(UUID docId) {
        POSPersister.execute("delete from " + PosTableEntry.class.getSimpleName() + " where documentId = :id", "id", docId);
    }

    @Override
    public void postDeleteActions() {
        POSSalesInvoice.deleteTableEntries(this.getId());
    }

    @Override
    public void updateDetails(List<? extends AbsPOSSalesLine> list) {
        this.setDetails(list);
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchRemovedLines() {
        return this.getRemovedLines();
    }

    @Override
    public String fromInvoiceCode() {
        return "";
    }

    @Override
    public List<? extends AbsPOSPaymentLine> fetchPayments() {
        return this.getPaymentLines();
    }

    @Override
    public <T extends AbsPOSPaymentLine> T createPaymentLine(String methodName, UUID method_id, BigDecimal value, String authorizationNumber, Boolean cash) {
        return (T)new POSSalesPaymentLine(methodName, method_id, value, authorizationNumber, cash);
    }

    @Override
    public <T extends AbsPOSSalesLine> T createBasicLine() {
        POSSalesInvoiceLine posSalesInvoiceLine = new POSSalesInvoiceLine();
        posSalesInvoiceLine.setInvoice(this);
        return (T)posSalesInvoiceLine;
    }

    public Boolean getReturnBefore() {
        return this.returnBefore;
    }

    public void setReturnBefore(Boolean returnBefore) {
        this.returnBefore = returnBefore;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSSalesInvoice";
    }

    @Override
    public String getReplacementCode() {
        return this.replacementCode;
    }

    public void setReplacementCode(String replacementCode) {
        this.replacementCode = replacementCode;
    }

    public boolean totalyReturned() {
        for (POSSalesInvoiceLine posSalesInvoiceLine : this.getDetails()) {
            if (!ObjectChecker.areNotEqual((Object)posSalesInvoiceLine.getQty().getValue(), (Object)posSalesInvoiceLine.getReturnedQty())) continue;
            return false;
        }
        return true;
    }

    public void addCreditNoteLine(PaymentInfo creditNotePaymentInfo) {
        POSSalesInvoiceCreditNoteLine creditNoteLine = new POSSalesInvoiceCreditNoteLine();
        creditNoteLine.setCreditNoteCode(creditNotePaymentInfo.getProcessNumber());
        creditNoteLine.setCreditNoteValue(creditNotePaymentInfo.getValue());
        creditNoteLine.setInvoice(this);
        creditNoteLine.assignIds();
        this.getCreditNotes().add(creditNoteLine);
    }

    public void addCouponLine(PaymentInfo couponInfo) {
        POSSalesInvoiceCouponLine couponLine = new POSSalesInvoiceCouponLine();
        couponLine.setCouponCode(couponInfo.getProcessNumber());
        couponLine.setCouponValue(couponInfo.getValue());
        couponLine.setInvoice(this);
        couponLine.assignIds();
        this.getCoupons().add(couponLine);
    }

    public UUID getReplacementId() {
        return this.replacementId;
    }

    public void setReplacementId(UUID replacementId) {
        this.replacementId = replacementId;
    }

    public Date calcValueDateForReplacentAndReturn() {
        if (this.getReplacementId() == null) {
            return this.getValueDate();
        }
        POSSalesReplacement replacement = POSPersister.findByID(POSSalesReplacement.class, this.getReplacementId());
        UUID fromInvoiceId = replacement.getFromInvoiceId();
        if (fromInvoiceId == null) {
            return this.getValueDate();
        }
        POSSalesInvoice srcInvoice = POSPersister.findByID(POSSalesInvoice.class, fromInvoiceId);
        if (srcInvoice == null) {
            return this.getValueDate();
        }
        return srcInvoice.calcValueDateForReplacentAndReturn();
    }

    @Override
    public List<? extends IPOSFinancialEffect> effects() {
        ArrayList<IPOSFinancialEffect> effects = new ArrayList<IPOSFinancialEffect>();
        if (ObjectChecker.isTrue((Boolean)this.getPaymentDelayed())) {
            return effects;
        }
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getPaidCash())) {
            effects.add(new InvoiceCashPart(this));
        }
        effects.add(new InvoiceDebitPart());
        effects.addAll(this.getPaymentLines());
        return effects;
    }

    @Override
    public void initializeLists() {
        super.initializeLists();
        this.fetchPayments().size();
        this.getCreditNotes().size();
        this.getCoupons().size();
        this.getTableLines().size();
        this.getRemovedLines().size();
    }

    @Override
    public POSResult processCreditNotesAndCoupons(POSRegistery register, List<PaymentInfo> creditNoteInfos, List<PaymentInfo> couponsInfoInPayments) {
        POSResult result = new POSResult();
        try {
            if (this.customPaymentInfosHaveValue(creditNoteInfos)) {
                POSCreditNoteAndCouponUtil.processCreditNotes(register, this, creditNoteInfos, result);
                if (result.isFailed().booleanValue()) {
                    return result.failure("Save transaction failed", new Object[0]);
                }
            }
            if (this.customPaymentInfosHaveValue(couponsInfoInPayments)) {
                POSCreditNoteAndCouponUtil.processCoupons(register, this, couponsInfoInPayments, result);
                if (result.isFailed().booleanValue()) {
                    return result.failure("Save transaction failed", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            if (e instanceof NaMaServiceExcepption) {
                NaMaServiceExcepption nse = (NaMaServiceExcepption)e;
                result.accumulate(ResultDTO.findLeafFailureResults((ResultDTO)nse.getFaultInfo()));
            }
            NaMaLogger.error((Object)result);
        }
        return result;
    }

    private boolean customPaymentInfosHaveValue(List<PaymentInfo> customPaymentInfos) {
        if (customPaymentInfos == null) {
            return false;
        }
        List methodsWithValues = CollectionsUtility.filter(customPaymentInfos, object -> ObjectChecker.isNotEmptyOrZero((BigDecimal)object.getValue()));
        if (ObjectChecker.isEmptyOrNull((Object)methodsWithValues)) {
            return false;
        }
        return methodsWithValues.size() > 0;
    }

    @Override
    public POSResult writeDocToServer(POSRegistery register, List<PaymentInfo> couponsInfoInPayments, List<PaymentInfo> creditNoteInfos, Callback callback, boolean preventDraft) {
        POSResult posResult = new POSResult();
        if (this.getHold()) {
            return posResult;
        }
        if (this.getCoupons().size() > 0 || this.getCreditNotes().size() > 0 || POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) {
            return this.writeInvoiceToServer(register, posResult, preventDraft);
        }
        return posResult;
    }

    public POSResult writeInvoiceToServer(POSRegistery register, POSResult posResult, boolean saveAsDraft) {
        boolean sent = POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeInvoices(register, Arrays.asList(this))));
        if (!sent) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        return posResult;
    }

    public POSResult writeDocToServerFirst(POSRegistery register) {
        POSResult posResult = new POSResult();
        List<ServiceResponse> serviceResponses = POSDataWriterUtil.writeInvoicesToNamaFirst(register, Arrays.asList(this));
        if (ObjectChecker.isNotEmptyOrNull(serviceResponses) && !serviceResponses.get(0).succeded()) {
            posResult.failure(ResultDTO.findLeafFailureResults((ResultDTO)serviceResponses.get(0).getResult()));
        }
        return posResult;
    }

    public BigDecimal usedNotePart() {
        BigDecimal amount = BigDecimal.ZERO;
        if (this.getCreditNotes().size() == 0) {
            return amount;
        }
        for (POSSalesInvoiceCreditNoteLine noteLine : this.getCreditNotes()) {
            amount = amount.add(noteLine.getCreditNoteValue());
        }
        return amount;
    }

    public BigDecimal usedCouponPart() {
        BigDecimal amount = BigDecimal.ZERO;
        if (this.getCoupons().size() == 0) {
            return amount;
        }
        for (POSSalesInvoiceCouponLine couponLine : this.getCoupons()) {
            amount = amount.add(couponLine.getCouponValue());
        }
        return amount;
    }

    @Override
    public BigDecimal calcCashValue() {
        return new InvoiceCashPart(this).getAmount();
    }

    @Override
    public BigDecimal calcDebitValue() {
        return new InvoiceDebitPart().getAmount();
    }

    public POSRegistery fetchInvoiceRegister() {
        UUID srcInvoiceRegisterId = this.getRegisterId();
        if (srcInvoiceRegisterId == null) {
            return null;
        }
        return POSPersister.findByID(POSRegistery.class, srcInvoiceRegisterId);
    }

    @Override
    public POSDocumentType docType() {
        return POSDocumentType.Invoice;
    }

    @Override
    public List<String> screenFieldsToUpdate() {
        return CollectionsUtility.join((List[])new List[]{SalesDocCommonFieldIds, Arrays.asList("invoiceCode", "reservation", "reservationAmount")});
    }

    @Override
    public List<String> filterByFields() {
        List<String> list = super.filterByFields();
        list.add("fromCaptainOrder");
        return list;
    }

    public void setWriteHeldInvoiceToServer(boolean writeHeldInvoiceToServer) {
        this.writeHeldInvoiceToServer = writeHeldInvoiceToServer;
    }

    public boolean isWriteHeldInvoiceToServer() {
        return this.writeHeldInvoiceToServer;
    }

    @Override
    public DTONamaPOSSalesInvoice toDTO() {
        DTONamaPOSSalesInvoice dtoNamaPOSSalesInvoice = new DTONamaPOSSalesInvoice();
        dtoNamaPOSSalesInvoice.setPosReplacementCode(this.getReplacementCode());
        dtoNamaPOSSalesInvoice.setPosReplacementId(ServerStringUtils.toUUIDStr((Object)this.getReplacementId()));
        dtoNamaPOSSalesInvoice.setDiscountApplier(new EntityReferenceData("Employee", ServerStringUtils.toUUIDStr((Object)this.getDiscountApplier())));
        dtoNamaPOSSalesInvoice.setFromCaptainOrder(this.getFromCaptainOrder());
        POSActualDTOConverter.convertToDTO(this, (DTOAbsPOSSalesDoc)dtoNamaPOSSalesInvoice);
        for (POSSalesInvoiceCreditNoteLine pOSSalesInvoiceCreditNoteLine : this.getCreditNotes()) {
            POSCreditNote creditNote = (POSCreditNote)POSPersister.findByCode(POSCreditNote.class, pOSSalesInvoiceCreditNoteLine.getCreditNoteCode());
            POSSalesInvoice.addExternalPaymentLine(dtoNamaPOSSalesInvoice, POSMasterFile.toRef(creditNote), pOSSalesInvoiceCreditNoteLine.getCreditNoteValue(), this.getCode());
        }
        for (POSSalesInvoiceCouponLine pOSSalesInvoiceCouponLine : this.getCoupons()) {
            POSDiscountCoupon coupon = (POSDiscountCoupon)POSPersister.findByCode(POSDiscountCoupon.class, pOSSalesInvoiceCouponLine.getCouponCode());
            POSSalesInvoice.addExternalPaymentLine(dtoNamaPOSSalesInvoice, POSMasterFile.toRef(coupon), pOSSalesInvoiceCouponLine.getCouponValue(), this.getCode());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getReservation())) {
            EntityReferenceData reservation = POSMasterFile.toRef(this.getReservation());
            dtoNamaPOSSalesInvoice.setOrderReservation(reservation);
            POSSalesInvoice.addExternalPaymentLine(dtoNamaPOSSalesInvoice, reservation, this.getReservation().getTotalPaid(), this.getCode());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getHeldInvoiceId())) {
            dtoNamaPOSSalesInvoice.setHeldInvoiceId(ServerStringUtils.toUUIDStr((Object)this.getHeldInvoiceId()));
        }
        return dtoNamaPOSSalesInvoice;
    }

    private static void addExternalPaymentLine(DTONamaPOSSalesInvoice dtoNamaPOSSalesInvoice, EntityReferenceData paymentDocument, BigDecimal value, String invoiceCode) {
        DTONamaPOSSalesExternalPaymentLine payLine = new DTONamaPOSSalesExternalPaymentLine();
        payLine.setPaymentDocument(paymentDocument);
        payLine.setPaymentValue(value);
        payLine.setInvCode(invoiceCode);
        dtoNamaPOSSalesInvoice.getExternalPaymentLines().add(payLine);
    }

    public boolean isSentHeldToServer() {
        return this.sentHeldToServer;
    }

    public void setSentHeldToServer(boolean sentHeldToServer) {
        this.sentHeldToServer = sentHeldToServer;
    }

    public static class InvoiceCashPart
    implements IPOSFinancialEffect {
        private AbsPOSSales sales;

        public InvoiceCashPart(AbsPOSSales posSalesInvoice) {
            this.sales = posSalesInvoice;
        }

        @Override
        public String getShiftCode() {
            return this.sales.getShiftCode();
        }

        @Override
        public BigDecimal getAmount() {
            if (this.sales instanceof POSOrderReservation) {
                return this.sales.getPaidCash();
            }
            if (this.sales instanceof PosCancelReservation) {
                return this.sales.getPaidCash().negate();
            }
            return this.sales.getPaidCash().subtract(this.sales.getChange());
        }

        @Override
        public UUID getPaymentMethodId() {
            return MultiplePaymentDialog.cashMethodID();
        }

        @Override
        public String getPaymentMethodName() {
            return MultiplePaymentDialog.searchForCashMethodName();
        }

        @Override
        public POSCurrency fetchCurrency() {
            return this.sales.getCurrency();
        }

        @Override
        public Boolean isCash() {
            return true;
        }

        @Override
        public Boolean isDebit() {
            return false;
        }

        @Override
        public POSMasterFile origin() {
            return this.sales;
        }

        @Override
        public Date fetchValueDate() {
            return this.sales.getValueDate();
        }
    }

    public class InvoiceDebitPart
    implements IPOSFinancialEffect {
        @Override
        public String getShiftCode() {
            return POSSalesInvoice.this.getShiftCode();
        }

        @Override
        public BigDecimal getAmount() {
            BigDecimal creditNoteAndCouponVal = BigDecimal.ZERO;
            if (ObjectChecker.isNotEmptyOrNull(POSSalesInvoice.this.getCreditNotes())) {
                for (POSSalesInvoiceCreditNoteLine creditNoteLine : POSSalesInvoice.this.getCreditNotes()) {
                    creditNoteAndCouponVal = creditNoteAndCouponVal.add(creditNoteLine.getCreditNoteValue());
                }
            }
            if (ObjectChecker.isNotEmptyOrNull(POSSalesInvoice.this.getCoupons())) {
                for (POSSalesInvoiceCouponLine line : POSSalesInvoice.this.getCoupons()) {
                    creditNoteAndCouponVal = creditNoteAndCouponVal.add(line.getCouponValue());
                }
            }
            BigDecimal reservationTotalPaid = BigDecimal.ZERO;
            if (ObjectChecker.isNotEmptyOrNull((Object)POSSalesInvoice.this.getReservation())) {
                reservationTotalPaid = POSSalesInvoice.this.getReservation().getTotalPaid();
            }
            return SafeBigDecimal.n((BigDecimal)POSSalesInvoice.this.getNetPrice()).subtract(POSSalesInvoice.this.getTotalPaid()).subtract(creditNoteAndCouponVal).subtract(reservationTotalPaid).v();
        }

        @Override
        public UUID getPaymentMethodId() {
            return null;
        }

        @Override
        public POSCurrency fetchCurrency() {
            return POSSalesInvoice.this.getCurrency();
        }

        @Override
        public Boolean isCash() {
            return false;
        }

        @Override
        public Boolean isDebit() {
            return true;
        }

        @Override
        public POSMasterFile origin() {
            return POSSalesInvoice.this;
        }

        @Override
        public Date fetchValueDate() {
            return POSSalesInvoice.this.getValueDate();
        }

        @Override
        public String getPaymentMethodName() {
            return POSResourcesUtil.id("debitValue", new Object[0]);
        }
    }
}

