/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.supplychain.contracts.details.DTOFreeItemLine;
import com.namasoft.modules.supplychain.contracts.details.DTOInvoiceDiscountLine;
import com.namasoft.modules.supplychain.contracts.details.DTOInvoiceFreeItemLine;
import com.namasoft.modules.supplychain.contracts.details.DTOItemDiscountLine;
import com.namasoft.modules.supplychain.contracts.details.DTOOfferCouponLine;
import com.namasoft.modules.supplychain.contracts.details.DTOOfferOnItemsCountLine;
import com.namasoft.modules.supplychain.contracts.entities.DTOSalesOffers;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSFreeItemLine;
import com.namasoft.pos.domain.details.POSInvoiceDiscountLine;
import com.namasoft.pos.domain.details.POSInvoiceFreeItemLine;
import com.namasoft.pos.domain.details.POSItemDiscountLine;
import com.namasoft.pos.domain.details.POSOfferCouponLine;
import com.namasoft.pos.domain.details.POSOfferOnItemsCountLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.util.POSPricesCachingUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
public class POSSalesOffers
extends POSMasterFile<DTOSalesOffers> {
    private Date fromDate;
    private Date toDate;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency currency;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="salesOffer")
    @OrderColumn(name="lineNumber")
    List<POSItemDiscountLine> details;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="salesOffer")
    @OrderColumn(name="lineNumber")
    List<POSFreeItemLine> freeItems;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="salesOffer")
    @OrderColumn(name="lineNumber")
    List<POSInvoiceDiscountLine> invDiscountLines;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="salesOffer")
    @OrderColumn(name="lineNumber")
    List<POSInvoiceFreeItemLine> invOffersLines;
    private Long priority;
    private Boolean deactivatePriceList;
    private Boolean stopOtherDiscounts;
    @Lob
    private String freeItemsIds;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="salesOffer")
    @OrderColumn(name="lineNumber")
    private List<POSOfferOnItemsCountLine> itemsCountOffers;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="salesOffer")
    @OrderColumn(name="lineNumber")
    private List<POSOfferCouponLine> coupons;

    public Boolean getStopOtherDiscounts() {
        return this.stopOtherDiscounts;
    }

    public void setStopOtherDiscounts(Boolean stopOtherDiscounts) {
        this.stopOtherDiscounts = stopOtherDiscounts;
    }

    public String getFreeItemsIds() {
        return this.freeItemsIds;
    }

    public void setFreeItemsIds(String freeItemsIds) {
        this.freeItemsIds = freeItemsIds;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public POSCurrency getCurrency() {
        this.currency = POSPersister.materialize(POSCurrency.class, this.currency);
        return this.currency;
    }

    public void setCurrency(POSCurrency currency) {
        this.currency = currency;
    }

    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
        this.getFreeItems().size();
        this.getInvOffersLines().size();
        this.getInvDiscountLines().size();
        this.getItemsCountOffers().size();
        this.getCoupons().size();
    }

    public List<POSItemDiscountLine> getDetails() {
        return this.details;
    }

    public void setDetails(List<POSItemDiscountLine> details) {
        this.details = details;
    }

    public List<POSFreeItemLine> getFreeItems() {
        return this.freeItems;
    }

    public void setFreeItems(List<POSFreeItemLine> freeItems) {
        this.freeItems = freeItems;
    }

    public List<POSInvoiceDiscountLine> getInvDiscountLines() {
        return this.invDiscountLines;
    }

    public void setInvDiscountLines(List<POSInvoiceDiscountLine> invDiscountLines) {
        this.invDiscountLines = invDiscountLines;
    }

    public List<POSInvoiceFreeItemLine> getInvOffersLines() {
        return this.invOffersLines;
    }

    public void setInvOffersLines(List<POSInvoiceFreeItemLine> invOffersLines) {
        this.invOffersLines = invOffersLines;
    }

    public Boolean getDeactivatePriceList() {
        return this.deactivatePriceList;
    }

    public void setDeactivatePriceList(Boolean deactivatePriceList) {
        this.deactivatePriceList = deactivatePriceList;
    }

    @Override
    public void updateData(DTOSalesOffers dtoSalesOffer) {
        int i;
        POSPricesCachingUtil.clearCache();
        this.setId(UUID.fromString(dtoSalesOffer.getId()));
        this.setCode(dtoSalesOffer.getCode());
        this.setCurrency((POSCurrency)this.fromReference(dtoSalesOffer.getCurrency()));
        this.setName1(dtoSalesOffer.getName1());
        this.setName2(dtoSalesOffer.getName2());
        this.setDeactivatePriceList(dtoSalesOffer.getDeactivatePriceList());
        this.setFromDate(dtoSalesOffer.getFromDate());
        this.setToDate(dtoSalesOffer.getToDate());
        this.setPriority(dtoSalesOffer.getPriority());
        this.setStopOtherDiscounts(dtoSalesOffer.getStopOtherDiscounts());
        this.setFreeItemsIds(dtoSalesOffer.getFreeItemsIds());
        if (this.getItemsCountOffers() == null) {
            this.setItemsCountOffers(new ArrayList<POSOfferOnItemsCountLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)dtoSalesOffer.getItemsCountOffers(), this.getItemsCountOffers(), () -> new POSOfferOnItemsCountLine());
        POSPersister.execute("delete from " + POSOfferOnItemsCountLine.class.getSimpleName() + " where salesOffer_id = 0x" + ServerStringUtils.toUUIDStr((Object)this.getId()));
        for (i = 0; i < dtoSalesOffer.getItemsCountOffers().size(); ++i) {
            POSOfferOnItemsCountLine line = this.getItemsCountOffers().get(i);
            line.setSalesOffer(this);
            line.updateData((DTOOfferOnItemsCountLine)dtoSalesOffer.getItemsCountOffers().get(i), dtoSalesOffer);
        }
        if (this.getDetails() == null) {
            this.setDetails(new ArrayList<POSItemDiscountLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)dtoSalesOffer.getDetails(), this.getDetails(), () -> new POSItemDiscountLine());
        POSPersister.execute("delete from " + POSItemDiscountLine.class.getSimpleName() + " where salesOffer_id = 0x" + ServerStringUtils.toUUIDStr((Object)this.getId()));
        for (i = 0; i < dtoSalesOffer.getDetails().size(); ++i) {
            POSItemDiscountLine posItemDiscountLine = this.getDetails().get(i);
            posItemDiscountLine.setSalesOffer(this);
            posItemDiscountLine.updateData((DTOItemDiscountLine)dtoSalesOffer.getDetails().get(i), dtoSalesOffer, i);
        }
        if (this.getFreeItems() == null) {
            this.setFreeItems(new ArrayList<POSFreeItemLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)dtoSalesOffer.getFreeItems(), this.getFreeItems(), POSFreeItemLine::new);
        POSPersister.execute("delete from " + POSFreeItemLine.class.getSimpleName() + " where salesOffer_id = 0x" + ServerStringUtils.toUUIDStr((Object)this.getId()));
        for (i = 0; i < dtoSalesOffer.getFreeItems().size(); ++i) {
            POSFreeItemLine posFreeItemLine = this.getFreeItems().get(i);
            posFreeItemLine.setSalesOffer(this);
            posFreeItemLine.updateData((DTOFreeItemLine)dtoSalesOffer.getFreeItems().get(i), dtoSalesOffer, i);
        }
        if (this.getInvDiscountLines() == null) {
            this.setInvDiscountLines(new ArrayList<POSInvoiceDiscountLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)dtoSalesOffer.getInvDiscountLines(), this.getInvDiscountLines(), () -> new POSInvoiceDiscountLine());
        POSPersister.execute("delete from " + POSInvoiceDiscountLine.class.getSimpleName() + " where salesOffer_id = 0x" + ServerStringUtils.toUUIDStr((Object)this.getId()));
        for (i = 0; i < dtoSalesOffer.getInvDiscountLines().size(); ++i) {
            POSInvoiceDiscountLine posInvoiceDiscountLine = this.getInvDiscountLines().get(i);
            posInvoiceDiscountLine.setSalesOffer(this);
            posInvoiceDiscountLine.updateDate((DTOInvoiceDiscountLine)dtoSalesOffer.getInvDiscountLines().get(i), dtoSalesOffer, i);
        }
        if (this.getInvOffersLines() == null) {
            this.setInvOffersLines(new ArrayList<POSInvoiceFreeItemLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)dtoSalesOffer.getInvOffersLines(), this.getInvOffersLines(), POSInvoiceFreeItemLine::new);
        POSPersister.execute("delete from " + POSInvoiceFreeItemLine.class.getSimpleName() + " where salesOffer_id = 0x" + ServerStringUtils.toUUIDStr((Object)this.getId()));
        for (i = 0; i < dtoSalesOffer.getInvOffersLines().size(); ++i) {
            POSInvoiceFreeItemLine posInvoiceFreeItemLine = this.getInvOffersLines().get(i);
            posInvoiceFreeItemLine.setSalesOffer(this);
            posInvoiceFreeItemLine.updateDate((DTOInvoiceFreeItemLine)dtoSalesOffer.getInvOffersLines().get(i), dtoSalesOffer);
        }
        CollectionsUtility.makeSecondSameSize((List)dtoSalesOffer.getCoupons(), this.getCoupons(), POSOfferCouponLine::new);
        for (i = 0; i < dtoSalesOffer.getCoupons().size(); ++i) {
            POSOfferCouponLine offerCouponLine = this.getCoupons().get(i);
            offerCouponLine.setSalesOffer(this);
            offerCouponLine.updateDate(dtoSalesOffer, (DTOOfferCouponLine)dtoSalesOffer.getCoupons().get(i));
        }
    }

    @Override
    public void assignIds() {
        super.assignIds();
        this.getDetails().forEach(l -> l.getId());
        this.getFreeItems().forEach(l -> l.getId());
        this.getInvDiscountLines().forEach(l -> l.getId());
        this.getInvOffersLines().forEach(l -> l.getId());
        this.getItemsCountOffers().forEach(l -> l.getId());
        this.getCoupons().forEach(l -> l.getId());
    }

    @Override
    public String calcNamaEntityType() {
        return "SalesOffers";
    }

    public List<POSOfferOnItemsCountLine> getItemsCountOffers() {
        return this.itemsCountOffers;
    }

    public void setItemsCountOffers(List<POSOfferOnItemsCountLine> itemsCountOffers) {
        this.itemsCountOffers = itemsCountOffers;
    }

    public List<POSOfferCouponLine> getCoupons() {
        if (this.coupons == null) {
            this.coupons = new ArrayList<POSOfferCouponLine>();
        }
        return this.coupons;
    }

    public void setCoupons(List<POSOfferCouponLine> coupons) {
        this.coupons = coupons;
    }
}

