/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.supplychain.contracts.details.DTOSalesPriceListLine;
import com.namasoft.modules.supplychain.contracts.entities.DTOSalesPriceList;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSSalesPriceListLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.util.POSPricesCachingUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
public class POSSalesPriceList
extends POSMasterFile<DTOSalesPriceList> {
    private Date fromDate;
    private Date toDate;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency currency;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="priceList")
    @OrderColumn(name="lineNumber")
    private List<POSSalesPriceListLine> details;
    private Long priority;
    private Boolean deactivatePriceList;

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public POSCurrency getCurrency() {
        this.currency = POSPersister.materialize(POSCurrency.class, this.currency);
        return this.currency;
    }

    public void setCurrency(POSCurrency currency) {
        this.currency = currency;
    }

    public List<POSSalesPriceListLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSSalesPriceListLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSSalesPriceListLine> details) {
        this.details = details;
    }

    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    public Boolean getDeactivatePriceList() {
        return this.deactivatePriceList;
    }

    public void setDeactivatePriceList(Boolean deactivatePriceList) {
        this.deactivatePriceList = deactivatePriceList;
    }

    @Override
    public void updateData(DTOSalesPriceList dtoSalesPriceList) {
        POSPricesCachingUtil.clearCache();
        this.setPriority(dtoSalesPriceList.getPriority());
        this.setId(UUID.fromString(dtoSalesPriceList.getId()));
        this.setName1(dtoSalesPriceList.getName1());
        this.setName2(dtoSalesPriceList.getName2());
        this.setCode(dtoSalesPriceList.getCode());
        this.setFromDate(dtoSalesPriceList.getFromDate());
        this.setToDate(dtoSalesPriceList.getToDate());
        this.setDeactivatePriceList(dtoSalesPriceList.getDeactivatePriceList());
        this.setCurrency((POSCurrency)this.fromReference(dtoSalesPriceList.getCurrency()));
        POSPersister.saveOrUpdate(this);
        CollectionsUtility.makeSecondSameSize((List)dtoSalesPriceList.getDetails(), this.getDetails(), POSSalesPriceListLine::new);
        POSPersister.execute("delete from " + POSSalesPriceListLine.class.getSimpleName() + " where priceList_id is null");
        POSPersister.execute("delete from " + POSSalesPriceListLine.class.getSimpleName() + " where priceList_id = 0x" + ServerStringUtils.toUUIDStr((Object)this.getId()));
        for (int i = 0; i < dtoSalesPriceList.getDetails().size(); ++i) {
            DTOSalesPriceListLine dtoSalesPriceListLine = (DTOSalesPriceListLine)dtoSalesPriceList.getDetails().get(i);
            POSSalesPriceListLine posSalesPriceListLine = this.getDetails().get(i);
            posSalesPriceListLine.setPriceList(this);
            posSalesPriceListLine.updateData(dtoSalesPriceListLine, dtoSalesPriceList, i);
        }
    }

    @Override
    public void assignIds() {
        super.assignIds();
        for (POSSalesPriceListLine list : this.getDetails()) {
            list.getId();
        }
    }

    @Override
    public String calcNamaEntityType() {
        return "SalesPriceList";
    }
}

