/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.entities.DTOPOSSecurityProfile;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSSecurityLine;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;

@Entity
public class POSSecurity
extends POSMasterFile<DTOPOSSecurityProfile> {
    private Boolean allCapabilities;
    private Boolean canEditItemCode;
    private Boolean canCancelSalesLine;
    private Boolean canDepreciateSalesLine;
    private Boolean canEditItemPrice;
    private Boolean canEditDeliveryCost;
    private Boolean canEditLineQty;
    private Boolean canMakeLineDisc;
    private Boolean canMakeDocDisc;
    private Boolean canDeleteHeldInvoices;
    private Boolean canCancelInvoiceBeforeSave;
    private Boolean canMakePaymentDoc;
    private Boolean canMakeReceiptDoc;
    private Boolean canOpenCloseShifts;
    private Boolean canMakeCashCount;
    private Boolean canEditSettings;
    private Boolean canReturnWithoutInvoice;
    private Boolean canInquireForPrices;
    private Boolean canEditSalesUom;
    private Boolean canHoldInvoice;
    private Boolean canOpenCashDrawer;
    private Boolean canAddCustomer;
    private Boolean canOpenOldInvoice;
    private Boolean canPayWithCreditVal;
    private Boolean canEditItemDims;
    private Boolean canReplaceWithoutInvoice;
    private Boolean canViewAccountantBalance;
    private Boolean canPrintFullInvoice;
    private Boolean canEditSalesMan;
    private Boolean canMakeLineTaxes;
    private Boolean canCloseAnotherUserShift;
    private Boolean canEditInvoiceClassification;
    private Boolean canSearchOnItemCode;
    private Boolean canSearchOnInvInRetAndRepl;
    private Boolean canMakeReplacement;
    private Boolean canMakeReturn;
    private Boolean canShowDataTransferErrors;
    private Boolean canSearchByInvoiceCodePart;
    private Boolean canUseCalculator;
    private Boolean canUseKeyBoard;
    private Boolean canShowPaymentsDetails;
    private Boolean canMakeStockTransferReq;
    private Boolean canGiveFreeItems;
    private Boolean canRemoveSalesReturnFreeItems;
    private Boolean canShowFieldIds;
    private Boolean canEditServiceItemPrice;
    private Boolean canCancelTaxes;
    private Boolean canSearchOnCustomers;
    private Boolean canRePrintDocuments;
    private Boolean canEditReturnUnitPrice;
    private Boolean canEditReturnDiscOrTax;
    private Boolean forceMinPriceWithDiscounts;
    private Boolean preventResizeColumns;
    private Boolean preventReorderColumns;
    private Boolean preventViewNotifications;
    private Boolean canReturnInAnotherUserShift;
    private Boolean canReplaceInAnotherUserShift;
    private Boolean canUseAnotherUserShift;
    private Boolean deactivateShortcuts;
    private Boolean preventUsingCriticalMethods;
    private Boolean preventFractionDiscount;
    private Boolean canEditCustomer;
    private Boolean canDelayInvoicePayment;
    private Boolean canReceiptFromStockTransfer;
    private Boolean canReceiptFromPurchaseInv;
    private Boolean canReceiptWithoutOriginDoc;
    private Boolean showCurrentShiftInvoicesOnly;
    private Boolean showCurrentShiftPaymentsOnly;
    private Boolean showCurrentShiftReceiptsOnly;
    private Boolean allowSalesmanUpdate;
    private Boolean allowHideOffersDialog;
    private Boolean canPrintHeldInvoice;
    private Boolean canMakeScrapDoc;
    private Boolean canMakeShortfallsDoc;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="posSecurity")
    @OrderColumn(name="lineNumber")
    private List<POSSecurityLine> capabilities;

    public Boolean getCanReceiptFromStockTransfer() {
        if (this.canReceiptFromStockTransfer == null) {
            this.canReceiptFromStockTransfer = false;
        }
        return this.canReceiptFromStockTransfer;
    }

    public void setCanReceiptFromStockTransfer(Boolean canReceiptFromStockTransfer) {
        this.canReceiptFromStockTransfer = canReceiptFromStockTransfer;
    }

    public Boolean getCanReceiptFromPurchaseInv() {
        if (this.canReceiptFromPurchaseInv == null) {
            this.canReceiptFromPurchaseInv = false;
        }
        return this.canReceiptFromPurchaseInv;
    }

    public void setCanReceiptFromPurchaseInv(Boolean canReceiptFromPurchaseInv) {
        this.canReceiptFromPurchaseInv = canReceiptFromPurchaseInv;
    }

    public Boolean getCanReceiptWithoutOriginDoc() {
        if (this.canReceiptWithoutOriginDoc == null) {
            this.canReceiptWithoutOriginDoc = false;
        }
        return this.canReceiptWithoutOriginDoc;
    }

    public void setCanReceiptWithoutOriginDoc(Boolean canReceiptWithoutOriginDoc) {
        this.canReceiptWithoutOriginDoc = canReceiptWithoutOriginDoc;
    }

    public Boolean getShowCurrentShiftInvoicesOnly() {
        if (this.showCurrentShiftInvoicesOnly == null) {
            this.showCurrentShiftInvoicesOnly = false;
        }
        return this.showCurrentShiftInvoicesOnly;
    }

    public void setShowCurrentShiftInvoicesOnly(Boolean showCurrentShiftInvoicesOnly) {
        this.showCurrentShiftInvoicesOnly = showCurrentShiftInvoicesOnly;
    }

    public Boolean getShowCurrentShiftPaymentsOnly() {
        return ObjectChecker.isTrue((Boolean)this.showCurrentShiftPaymentsOnly);
    }

    public void setShowCurrentShiftPaymentsOnly(Boolean showCurrentShiftPaymentsOnly) {
        this.showCurrentShiftPaymentsOnly = showCurrentShiftPaymentsOnly;
    }

    public Boolean getShowCurrentShiftReceiptsOnly() {
        return ObjectChecker.isTrue((Boolean)this.showCurrentShiftReceiptsOnly);
    }

    public void setShowCurrentShiftReceiptsOnly(Boolean showCurrentShiftReceiptsOnly) {
        this.showCurrentShiftReceiptsOnly = showCurrentShiftReceiptsOnly;
    }

    public Boolean getAllowSalesmanUpdate() {
        if (this.allowSalesmanUpdate == null) {
            this.allowSalesmanUpdate = false;
        }
        return this.allowSalesmanUpdate;
    }

    public void setAllowSalesmanUpdate(Boolean allowSalesmanUpdate) {
        this.allowSalesmanUpdate = allowSalesmanUpdate;
    }

    public Boolean getAllowHideOffersDialog() {
        if (this.allowHideOffersDialog == null) {
            this.allowHideOffersDialog = false;
        }
        return this.allowHideOffersDialog;
    }

    public void setAllowHideOffersDialog(Boolean allowHideOffersDialog) {
        this.allowHideOffersDialog = allowHideOffersDialog;
    }

    public Boolean getCanPrintHeldInvoice() {
        return this.canPrintHeldInvoice;
    }

    public Boolean getCanMakeScrapDoc() {
        if (this.canMakeScrapDoc == null) {
            this.canMakeScrapDoc = false;
        }
        return this.canMakeScrapDoc;
    }

    public void setCanMakeScrapDoc(Boolean canMakeScrapDoc) {
        this.canMakeScrapDoc = canMakeScrapDoc;
    }

    public Boolean getCanMakeShortfallsDoc() {
        if (this.canMakeShortfallsDoc == null) {
            this.canMakeShortfallsDoc = false;
        }
        return this.canMakeShortfallsDoc;
    }

    public void setCanMakeShortfallsDoc(Boolean canMakeShortfallsDoc) {
        this.canMakeShortfallsDoc = canMakeShortfallsDoc;
    }

    public void setCanPrintHeldInvoice(Boolean canPrintHeldInvoice) {
        this.canPrintHeldInvoice = canPrintHeldInvoice;
    }

    public Boolean getCanDelayInvoicePayment() {
        if (this.canDelayInvoicePayment == null) {
            this.canDelayInvoicePayment = false;
        }
        return this.canDelayInvoicePayment;
    }

    public void setCanDelayInvoicePayment(Boolean canDelayInvoicePayment) {
        this.canDelayInvoicePayment = canDelayInvoicePayment;
    }

    public Boolean getCanEditCustomer() {
        if (this.canEditCustomer == null) {
            this.canEditCustomer = false;
        }
        return this.canEditCustomer;
    }

    public void setCanEditCustomer(Boolean canEditCustomer) {
        this.canEditCustomer = canEditCustomer;
    }

    public Boolean getPreventUsingCriticalMethods() {
        if (this.preventUsingCriticalMethods == null) {
            this.preventUsingCriticalMethods = false;
        }
        return this.preventUsingCriticalMethods;
    }

    public void setPreventUsingCriticalMethods(Boolean preventUsingCriticalMethods) {
        this.preventUsingCriticalMethods = preventUsingCriticalMethods;
    }

    public Boolean getDeactivateShortcuts() {
        if (this.deactivateShortcuts == null) {
            this.deactivateShortcuts = false;
        }
        return this.deactivateShortcuts;
    }

    public void setDeactivateShortcuts(Boolean deactivateShortcuts) {
        this.deactivateShortcuts = deactivateShortcuts;
    }

    public Boolean getCanReturnInAnotherUserShift() {
        if (this.canReturnInAnotherUserShift == null) {
            this.canReturnInAnotherUserShift = false;
        }
        return this.canReturnInAnotherUserShift;
    }

    public void setCanReturnInAnotherUserShift(Boolean canReturnInAnotherUserShift) {
        this.canReturnInAnotherUserShift = canReturnInAnotherUserShift;
    }

    public Boolean getCanReplaceInAnotherUserShift() {
        if (this.canReplaceInAnotherUserShift == null) {
            this.canReplaceInAnotherUserShift = false;
        }
        return this.canReplaceInAnotherUserShift;
    }

    public void setCanReplaceInAnotherUserShift(Boolean canReplaceInAnotherUserShift) {
        this.canReplaceInAnotherUserShift = canReplaceInAnotherUserShift;
    }

    public Boolean getCanUseAnotherUserShift() {
        return ObjectChecker.isTrue((Boolean)this.canUseAnotherUserShift);
    }

    public void setCanUseAnotherUserShift(Boolean canUserAnotherUserShift) {
        this.canUseAnotherUserShift = canUserAnotherUserShift;
    }

    public Boolean getPreventViewNotifications() {
        if (this.preventViewNotifications == null) {
            this.preventViewNotifications = false;
        }
        return this.preventViewNotifications;
    }

    public void setPreventViewNotifications(Boolean preventViewNotifications) {
        this.preventViewNotifications = preventViewNotifications;
    }

    public Boolean getPreventResizeColumns() {
        if (this.preventResizeColumns == null) {
            return false;
        }
        return this.preventResizeColumns;
    }

    public void setPreventResizeColumns(Boolean preventResizeColumns) {
        this.preventResizeColumns = preventResizeColumns;
    }

    public Boolean getAllCapabilities() {
        if (this.allCapabilities == null) {
            return false;
        }
        return this.allCapabilities;
    }

    public void setAllCapabilities(Boolean allCapabilities) {
        this.allCapabilities = allCapabilities;
    }

    public Boolean getPreventReorderColumns() {
        if (this.preventReorderColumns == null) {
            return false;
        }
        return this.preventReorderColumns;
    }

    public void setPreventReorderColumns(Boolean preventReorderColumns) {
        this.preventReorderColumns = preventReorderColumns;
    }

    public Boolean getForceMinPriceWithDiscounts() {
        if (this.forceMinPriceWithDiscounts == null) {
            return false;
        }
        return this.forceMinPriceWithDiscounts;
    }

    public void setForceMinPriceWithDiscounts(Boolean forceMinPriceWithDiscounts) {
        this.forceMinPriceWithDiscounts = forceMinPriceWithDiscounts;
    }

    public Boolean getCanCancelTaxes() {
        if (this.canCancelTaxes == null) {
            return false;
        }
        return this.canCancelTaxes;
    }

    public void setCanCancelTaxes(Boolean canCancelTaxes) {
        this.canCancelTaxes = canCancelTaxes;
    }

    public POSSecurity() {
    }

    public POSSecurity(String code, String name1, String name2) {
        super(code, name1, name2);
    }

    @Override
    public void initializeLists() {
        this.getCapabilities().size();
    }

    public Boolean getCanShowFieldIds() {
        if (this.canShowFieldIds == null) {
            return false;
        }
        return this.canShowFieldIds;
    }

    public void setCanShowFieldIds(Boolean canShowFieldIds) {
        this.canShowFieldIds = canShowFieldIds;
    }

    public Boolean getCanReplaceWithoutInvoice() {
        if (this.canReplaceWithoutInvoice == null) {
            return false;
        }
        return this.canReplaceWithoutInvoice;
    }

    public void setCanReplaceWithoutInvoice(Boolean canReplaceWithoutInvoice) {
        this.canReplaceWithoutInvoice = canReplaceWithoutInvoice;
    }

    public Boolean getCanViewAccountantBalance() {
        if (this.canViewAccountantBalance == null) {
            return false;
        }
        return this.canViewAccountantBalance;
    }

    public void setCanViewAccountantBalance(Boolean canViewAccountantBalance) {
        this.canViewAccountantBalance = canViewAccountantBalance;
    }

    public Boolean getCanOpenCashDrawer() {
        if (this.canOpenCashDrawer == null) {
            return false;
        }
        return this.canOpenCashDrawer;
    }

    public void setCanOpenCashDrawer(Boolean canOpenCashDrawer) {
        this.canOpenCashDrawer = canOpenCashDrawer;
    }

    public Boolean getCanAddCustomer() {
        if (this.canAddCustomer == null) {
            return false;
        }
        return this.canAddCustomer;
    }

    public void setCanAddCustomer(Boolean canAddCustomer) {
        this.canAddCustomer = canAddCustomer;
    }

    public Boolean getCanOpenOldInvoice() {
        if (this.canOpenOldInvoice == null) {
            return false;
        }
        return this.canOpenOldInvoice;
    }

    public void setCanOpenOldInvoice(Boolean canOpenOldInvoice) {
        this.canOpenOldInvoice = canOpenOldInvoice;
    }

    public Boolean getCanPayWithCreditVal() {
        if (this.canPayWithCreditVal == null) {
            return false;
        }
        return this.canPayWithCreditVal;
    }

    public void setCanPayWithCreditVal(Boolean canPayWithCreditVal) {
        this.canPayWithCreditVal = canPayWithCreditVal;
    }

    public Boolean getCanEditItemDims() {
        if (this.canEditItemDims == null) {
            return false;
        }
        return this.canEditItemDims;
    }

    public void setCanEditItemDims(Boolean canEditItemDims) {
        this.canEditItemDims = canEditItemDims;
    }

    public Boolean getCanEditItemCode() {
        if (this.canEditItemCode == null) {
            return false;
        }
        return this.canEditItemCode;
    }

    public void setCanEditItemCode(Boolean canEditItemCode) {
        this.canEditItemCode = canEditItemCode;
    }

    public Boolean getCanCancelSalesLine() {
        if (this.canCancelSalesLine == null) {
            return false;
        }
        return this.canCancelSalesLine;
    }

    public void setCanCancelSalesLine(Boolean canCancelSalesLine) {
        this.canCancelSalesLine = canCancelSalesLine;
    }

    public Boolean getCanDepreciateSalesLine() {
        if (this.canDepreciateSalesLine == null) {
            return false;
        }
        return this.canDepreciateSalesLine;
    }

    public void setCanDepreciateSalesLine(Boolean canDepreciateSalesLine) {
        this.canDepreciateSalesLine = canDepreciateSalesLine;
    }

    public Boolean getCanEditItemPrice() {
        if (this.canEditItemPrice == null) {
            return false;
        }
        return this.canEditItemPrice;
    }

    public void setCanEditItemPrice(Boolean canEditItemPrice) {
        this.canEditItemPrice = canEditItemPrice;
    }

    public Boolean getCanEditDeliveryCost() {
        if (this.canEditDeliveryCost == null) {
            return false;
        }
        return this.canEditDeliveryCost;
    }

    public void setCanEditDeliveryCost(Boolean canEditDeliveryCost) {
        this.canEditDeliveryCost = canEditDeliveryCost;
    }

    public Boolean getCanEditLineQty() {
        if (this.canEditLineQty == null) {
            return false;
        }
        return this.canEditLineQty;
    }

    public void setCanEditLineQty(Boolean canEditLineQty) {
        this.canEditLineQty = canEditLineQty;
    }

    public Boolean getCanMakeLineDisc() {
        if (this.canMakeLineDisc == null) {
            return false;
        }
        return this.canMakeLineDisc;
    }

    public void setCanMakeLineDisc(Boolean canMakeLineDisc) {
        this.canMakeLineDisc = canMakeLineDisc;
    }

    public Boolean getCanMakeDocDisc() {
        if (this.canMakeDocDisc == null) {
            return false;
        }
        return this.canMakeDocDisc;
    }

    public void setCanMakeDocDisc(Boolean canMakeDocDisc) {
        this.canMakeDocDisc = canMakeDocDisc;
    }

    public Boolean getCanDeleteHeldInvoices() {
        if (this.canDeleteHeldInvoices == null) {
            return false;
        }
        return this.canDeleteHeldInvoices;
    }

    public void setCanDeleteHeldInvoices(Boolean canDeleteHeldInvoices) {
        this.canDeleteHeldInvoices = canDeleteHeldInvoices;
    }

    public Boolean getCanCancelInvoiceBeforeSave() {
        if (this.canCancelInvoiceBeforeSave == null) {
            return false;
        }
        return this.canCancelInvoiceBeforeSave;
    }

    public void setCanCancelInvoiceBeforeSave(Boolean canCancelInvoiceBeforeSave) {
        this.canCancelInvoiceBeforeSave = canCancelInvoiceBeforeSave;
    }

    public Boolean getCanMakePaymentDoc() {
        if (this.canMakePaymentDoc == null) {
            return false;
        }
        return this.canMakePaymentDoc;
    }

    public void setCanMakePaymentDoc(Boolean canMakePaymentDoc) {
        this.canMakePaymentDoc = canMakePaymentDoc;
    }

    public Boolean getCanMakeReceiptDoc() {
        if (this.canMakeReceiptDoc == null) {
            return false;
        }
        return this.canMakeReceiptDoc;
    }

    public void setCanMakeReceiptDoc(Boolean canMakeReceiptDoc) {
        this.canMakeReceiptDoc = canMakeReceiptDoc;
    }

    public Boolean getCanOpenCloseShifts() {
        if (this.canOpenCloseShifts == null) {
            return false;
        }
        return this.canOpenCloseShifts;
    }

    public void setCanOpenCloseShifts(Boolean canOpenCloseShifts) {
        this.canOpenCloseShifts = canOpenCloseShifts;
    }

    public Boolean getCanMakeCashCount() {
        if (this.canMakeCashCount == null) {
            return false;
        }
        return this.canMakeCashCount;
    }

    public void setCanMakeCashCount(Boolean canMakeCashCount) {
        this.canMakeCashCount = canMakeCashCount;
    }

    public Boolean getCanEditSettings() {
        if (this.canEditSettings == null) {
            return false;
        }
        return this.canEditSettings;
    }

    public void setCanEditSettings(Boolean canEditSettings) {
        this.canEditSettings = canEditSettings;
    }

    public Boolean getCanReturnWithoutInvoice() {
        if (this.canReturnWithoutInvoice == null) {
            return false;
        }
        return this.canReturnWithoutInvoice;
    }

    public void setCanReturnWithoutInvoice(Boolean canReturnWithoutInvoice) {
        this.canReturnWithoutInvoice = canReturnWithoutInvoice;
    }

    public Boolean getCanInquireForPrices() {
        if (this.canInquireForPrices == null) {
            return false;
        }
        return this.canInquireForPrices;
    }

    public void setCanInquireForPrices(Boolean canInquireForPrices) {
        this.canInquireForPrices = canInquireForPrices;
    }

    @Override
    public void updateData(DTOPOSSecurityProfile dtoposSecurityProfile) {
        this.getCapabilities().clear();
        this.getCapabilities().addAll(CollectionsUtility.convert((Collection)dtoposSecurityProfile.getCapabilities(), POSSecurityLine::new));
        this.getCapabilities().forEach(c -> {
            c.assignIds();
            c.setPosSecurity(this);
        });
        this.setAllCapabilities(dtoposSecurityProfile.getAllCapabilities());
        this.setCanCancelInvoiceBeforeSave(dtoposSecurityProfile.getCanCancelInvoiceBeforeSave());
        this.setCanCancelSalesLine(dtoposSecurityProfile.getCanCancelSalesLine());
        this.setCanDepreciateSalesLine(dtoposSecurityProfile.getCanDepreciateSalesLine());
        this.setCanDeleteHeldInvoices(dtoposSecurityProfile.getCanDeleteHeldInvoices());
        this.setCanEditItemCode(dtoposSecurityProfile.getCanEditItemCode());
        this.setCanEditItemPrice(dtoposSecurityProfile.getCanEditItemPrice());
        this.setCanEditLineQty(dtoposSecurityProfile.getCanEditLineQty());
        this.setCanEditSettings(dtoposSecurityProfile.getCanEditSettings());
        this.setCanEditCustomer(dtoposSecurityProfile.getCanEditCustomer());
        this.setCanInquireForPrices(dtoposSecurityProfile.getCanInquireForPrices());
        this.setCanReceiptFromPurchaseInv(dtoposSecurityProfile.getCanReceiptFromPurchaseInv());
        this.setCanReceiptFromStockTransfer(dtoposSecurityProfile.getCanReceiptFromStockTransfer());
        this.setCanReceiptWithoutOriginDoc(dtoposSecurityProfile.getCanReceiptWithoutOriginDoc());
        this.setShowCurrentShiftInvoicesOnly(dtoposSecurityProfile.getShowCurrentShiftInvoicesOnly());
        this.setShowCurrentShiftPaymentsOnly(dtoposSecurityProfile.getShowCurrentShiftPaymentsOnly());
        this.setShowCurrentShiftReceiptsOnly(dtoposSecurityProfile.getShowCurrentShiftReceiptsOnly());
        this.setAllowSalesmanUpdate(dtoposSecurityProfile.getAllowSalesmanUpdate());
        this.setCanMakeCashCount(dtoposSecurityProfile.getCanMakeCashCount());
        this.setCanMakeDocDisc(dtoposSecurityProfile.getCanMakeDocDisc());
        this.setCanMakeLineDisc(dtoposSecurityProfile.getCanMakeLineDisc());
        this.setCanMakePaymentDoc(dtoposSecurityProfile.getCanMakePaymentDoc());
        this.setCanMakeReceiptDoc(dtoposSecurityProfile.getCanMakeReceiptDoc());
        this.setCanOpenCloseShifts(dtoposSecurityProfile.getCanOpenCloseShifts());
        this.setCanReturnWithoutInvoice(dtoposSecurityProfile.getCanReturnWithoutInvoice());
        this.setCanEditSalesUom(dtoposSecurityProfile.getCanEditSalesUom());
        this.setCanHoldInvoice(dtoposSecurityProfile.getCanHoldInvoice());
        this.setCanOpenCashDrawer(dtoposSecurityProfile.getCanOpenCashDrawer());
        this.setCanAddCustomer(dtoposSecurityProfile.getCanAddCustomer());
        this.setCanOpenOldInvoice(dtoposSecurityProfile.getCanOpenOldInvoice());
        this.setCanPayWithCreditVal(dtoposSecurityProfile.getCanPayWithCreditVal());
        this.setCanEditItemDims(dtoposSecurityProfile.getCanEditItemDims());
        this.setCanReplaceWithoutInvoice(dtoposSecurityProfile.getCanReplaceWithoutInvoice());
        this.setCanViewAccountantBalance(dtoposSecurityProfile.getCanViewAccountantBalance());
        this.setCanPrintFullInvoice(dtoposSecurityProfile.getCanPrintFullInvoice());
        this.setCanEditSalesMan(dtoposSecurityProfile.getCanEditSalesMan());
        this.setCanDelayInvoicePayment(dtoposSecurityProfile.getCanDelayInvoicePayment());
        this.setCanMakeLineTaxes(dtoposSecurityProfile.getCanMakeLineTaxes());
        this.setCanCloseAnotherUserShift(dtoposSecurityProfile.getCanCloseAnotherUserShift());
        this.setCanEditInvoiceClassification(dtoposSecurityProfile.getCanEditInvoiceClassification());
        this.setCanSearchOnItemCode(dtoposSecurityProfile.getCanSearchOnItemCode());
        this.setCanSearchOnInvInRetAndRepl(dtoposSecurityProfile.getCanSearchOnInvInRetAndRepl());
        this.setCanMakeReplacement(dtoposSecurityProfile.getCanMakeReplacement());
        this.setCanMakeReturn(dtoposSecurityProfile.getCanMakeReturn());
        this.setCanShowDataTransferErrors(dtoposSecurityProfile.getCanShowDataTransferErrors());
        this.setCanSearchByInvoiceCodePart(dtoposSecurityProfile.getCanSearchByInvoiceCodePart());
        this.setCanUseCalculator(dtoposSecurityProfile.getCanUseCalculator());
        this.setCanUseKeyBoard(dtoposSecurityProfile.getCanUseKeyBoard());
        this.setCanShowPaymentsDetails(dtoposSecurityProfile.getCanShowPaymentsDetails());
        this.setCanMakeStockTransferReq(dtoposSecurityProfile.getCanMakeStockTransferReq());
        this.setCanGiveFreeItems(dtoposSecurityProfile.getCanGiveFreeItems());
        this.setCanRemoveSalesReturnFreeItems(dtoposSecurityProfile.getCanRemoveSalesReturnFreeItems());
        this.setCanShowFieldIds(dtoposSecurityProfile.getCanShowFieldIds());
        this.setCanEditServiceItemPrice(dtoposSecurityProfile.getCanEditServiceItemPrice());
        this.setCanCancelTaxes(dtoposSecurityProfile.getCanCancelTaxes());
        this.setCanSearchOnCustomers(dtoposSecurityProfile.getCanSearchOnCustomers());
        this.setCanRePrintDocuments(dtoposSecurityProfile.getCanRePrintDocuments());
        this.setCanEditReturnDiscOrTax(dtoposSecurityProfile.getCanEditReturnDiscOrTax());
        this.setCanEditReturnUnitPrice(dtoposSecurityProfile.getCanEditReturnUnitPrice());
        this.setForceMinPriceWithDiscounts(dtoposSecurityProfile.getForceMinPriceWithDiscounts());
        this.setPreventReorderColumns(dtoposSecurityProfile.getPreventReorderColumns());
        this.setPreventResizeColumns(dtoposSecurityProfile.getPreventResizeColumns());
        this.setPreventViewNotifications(dtoposSecurityProfile.getPreventViewNotifications());
        this.setCanReplaceInAnotherUserShift(dtoposSecurityProfile.getCanReplaceInAnotherUserShift());
        this.setCanReturnInAnotherUserShift(dtoposSecurityProfile.getCanReturnInAnotherUserShift());
        this.setCanUseAnotherUserShift(dtoposSecurityProfile.getCanUseAnotherUserShift());
        this.setDeactivateShortcuts(dtoposSecurityProfile.getDeactivateShortcuts());
        this.setPreventUsingCriticalMethods(dtoposSecurityProfile.getPreventUsingCriticalMethods());
        this.setPreventFractionDiscount(dtoposSecurityProfile.getPreventFractionDiscount());
        this.setAllowHideOffersDialog(dtoposSecurityProfile.getAllowHideOffersDialog());
        this.setCanPrintHeldInvoice(dtoposSecurityProfile.getCanPrintHeldInvoice());
        this.setCanMakeScrapDoc(dtoposSecurityProfile.getCanMakeScrapDoc());
        this.setCanMakeShortfallsDoc(dtoposSecurityProfile.getCanMakeShortfallsDoc());
        super.updateData(dtoposSecurityProfile);
    }

    public void setCanPrintFullInvoice(Boolean canPrintFullInvoice) {
        this.canPrintFullInvoice = canPrintFullInvoice;
    }

    public Boolean getCanPrintFullInvoice() {
        if (ObjectChecker.isEmptyOrNull((Object)this.canPrintFullInvoice)) {
            return false;
        }
        return this.canPrintFullInvoice;
    }

    public Boolean getCanEditSalesUom() {
        if (this.canEditSalesUom == null) {
            return false;
        }
        return this.canEditSalesUom;
    }

    public void setCanEditSalesUom(Boolean canEditSalesUom) {
        this.canEditSalesUom = canEditSalesUom;
    }

    @Override
    public String calcNamaEntityType() {
        return "POSSecurityProfile";
    }

    public Boolean getCanHoldInvoice() {
        if (this.canHoldInvoice == null) {
            return false;
        }
        return this.canHoldInvoice;
    }

    public void setCanHoldInvoice(Boolean canHoldInvoice) {
        this.canHoldInvoice = canHoldInvoice;
    }

    public Boolean getCanEditSalesMan() {
        if (this.canEditSalesMan == null) {
            return false;
        }
        return this.canEditSalesMan;
    }

    public void setCanEditSalesMan(Boolean canEditSalesMan) {
        this.canEditSalesMan = canEditSalesMan;
    }

    public Boolean getCanMakeLineTaxes() {
        if (this.canMakeLineTaxes == null) {
            return false;
        }
        return this.canMakeLineTaxes;
    }

    public void setCanMakeLineTaxes(Boolean canMakeLineTaxes) {
        this.canMakeLineTaxes = canMakeLineTaxes;
    }

    public Boolean getCanCloseAnotherUserShift() {
        if (this.canCloseAnotherUserShift == null) {
            return false;
        }
        return this.canCloseAnotherUserShift;
    }

    public void setCanCloseAnotherUserShift(Boolean canCloseAnotherUserShift) {
        this.canCloseAnotherUserShift = canCloseAnotherUserShift;
    }

    public Boolean getCanEditInvoiceClassification() {
        if (this.canEditInvoiceClassification == null) {
            return false;
        }
        return this.canEditInvoiceClassification;
    }

    public void setCanEditInvoiceClassification(Boolean canEditInvoiceClassification) {
        this.canEditInvoiceClassification = canEditInvoiceClassification;
    }

    public Boolean getCanSearchOnItemCode() {
        if (this.canSearchOnItemCode == null) {
            return false;
        }
        return this.canSearchOnItemCode;
    }

    public void setCanSearchOnItemCode(Boolean canSearchOnItemCode) {
        this.canSearchOnItemCode = canSearchOnItemCode;
    }

    public Boolean getCanSearchOnInvInRetAndRepl() {
        if (this.canSearchOnInvInRetAndRepl == null) {
            return false;
        }
        return this.canSearchOnInvInRetAndRepl;
    }

    public void setCanSearchOnInvInRetAndRepl(Boolean canSearchOnInvInRetAndRepl) {
        this.canSearchOnInvInRetAndRepl = canSearchOnInvInRetAndRepl;
    }

    public Boolean getCanMakeReplacement() {
        if (this.canMakeReplacement == null) {
            return false;
        }
        return this.canMakeReplacement;
    }

    public void setCanMakeReplacement(Boolean canMakeReplacement) {
        this.canMakeReplacement = canMakeReplacement;
    }

    public Boolean getCanMakeReturn() {
        if (this.canMakeReturn == null) {
            return false;
        }
        return this.canMakeReturn;
    }

    public void setCanMakeReturn(Boolean canMakeReturn) {
        this.canMakeReturn = canMakeReturn;
    }

    public Boolean getCanShowDataTransferErrors() {
        if (this.canShowDataTransferErrors == null) {
            return false;
        }
        return this.canShowDataTransferErrors;
    }

    public void setCanShowDataTransferErrors(Boolean canShowDataTransferErrors) {
        this.canShowDataTransferErrors = canShowDataTransferErrors;
    }

    public Boolean getCanSearchByInvoiceCodePart() {
        if (this.canSearchByInvoiceCodePart == null) {
            return false;
        }
        return this.canSearchByInvoiceCodePart;
    }

    public void setCanSearchByInvoiceCodePart(Boolean canSearchByInvoiceCodePart) {
        this.canSearchByInvoiceCodePart = canSearchByInvoiceCodePart;
    }

    public Boolean getCanUseCalculator() {
        if (this.canUseCalculator == null) {
            return false;
        }
        return this.canUseCalculator;
    }

    public void setCanUseCalculator(Boolean canUseCalculator) {
        this.canUseCalculator = canUseCalculator;
    }

    public Boolean getCanUseKeyBoard() {
        if (this.canUseKeyBoard == null) {
            return false;
        }
        return this.canUseKeyBoard;
    }

    public void setCanUseKeyBoard(Boolean canUseKeyBoard) {
        this.canUseKeyBoard = canUseKeyBoard;
    }

    public Boolean getCanShowPaymentsDetails() {
        if (this.canShowPaymentsDetails == null) {
            return false;
        }
        return this.canShowPaymentsDetails;
    }

    public void setCanShowPaymentsDetails(Boolean canShowPaymentsDetails) {
        this.canShowPaymentsDetails = canShowPaymentsDetails;
    }

    public Boolean getCanMakeStockTransferReq() {
        if (this.canMakeStockTransferReq == null) {
            return false;
        }
        return this.canMakeStockTransferReq;
    }

    public void setCanMakeStockTransferReq(Boolean canMakeStockTransferReq) {
        this.canMakeStockTransferReq = canMakeStockTransferReq;
    }

    public Boolean getCanGiveFreeItems() {
        if (this.canGiveFreeItems == null) {
            return false;
        }
        return this.canGiveFreeItems;
    }

    public void setCanGiveFreeItems(Boolean canGiveFreeItems) {
        this.canGiveFreeItems = canGiveFreeItems;
    }

    public Boolean getCanRemoveSalesReturnFreeItems() {
        if (this.canRemoveSalesReturnFreeItems == null) {
            this.canRemoveSalesReturnFreeItems = false;
        }
        return this.canRemoveSalesReturnFreeItems;
    }

    public void setCanRemoveSalesReturnFreeItems(Boolean canRemoveSalesReturnFreeItems) {
        this.canRemoveSalesReturnFreeItems = canRemoveSalesReturnFreeItems;
    }

    public Boolean getCanEditServiceItemPrice() {
        if (this.canEditServiceItemPrice == null) {
            return false;
        }
        return this.canEditServiceItemPrice;
    }

    public void setCanEditServiceItemPrice(Boolean canEditServiceItemPrice) {
        this.canEditServiceItemPrice = canEditServiceItemPrice;
    }

    public Boolean getCanSearchOnCustomers() {
        if (this.canSearchOnCustomers == null) {
            return true;
        }
        return this.canSearchOnCustomers;
    }

    public void setCanSearchOnCustomers(Boolean canSearchOnCustomers) {
        this.canSearchOnCustomers = canSearchOnCustomers;
    }

    public Boolean getCanRePrintDocuments() {
        if (this.canRePrintDocuments == null) {
            return false;
        }
        return this.canRePrintDocuments;
    }

    public void setCanRePrintDocuments(Boolean canRePrintDocuments) {
        this.canRePrintDocuments = canRePrintDocuments;
    }

    public Boolean getCanEditReturnDiscOrTax() {
        if (this.canEditReturnDiscOrTax == null) {
            return false;
        }
        return this.canEditReturnDiscOrTax;
    }

    public void setCanEditReturnDiscOrTax(Boolean canEditReturnDiscOrTax) {
        this.canEditReturnDiscOrTax = canEditReturnDiscOrTax;
    }

    public Boolean getCanEditReturnUnitPrice() {
        if (this.canEditReturnUnitPrice == null) {
            return false;
        }
        return this.canEditReturnUnitPrice;
    }

    public void setCanEditReturnUnitPrice(Boolean canEditReturnUnitPrice) {
        this.canEditReturnUnitPrice = canEditReturnUnitPrice;
    }

    public Boolean getPreventFractionDiscount() {
        if (this.preventFractionDiscount == null) {
            this.preventFractionDiscount = false;
        }
        return this.preventFractionDiscount;
    }

    public void setPreventFractionDiscount(Boolean preventFractionDiscount) {
        this.preventFractionDiscount = preventFractionDiscount;
    }

    @Override
    public void postCommitAction(Session session) {
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        if (ObjectChecker.isEmptyOrNull((Object)currentUser) || ObjectChecker.isEmptyOrNull((Object)currentUser.getSecurity())) {
            return;
        }
        currentUser.setSecurity(POSPersister.findByID(POSSecurity.class, currentUser.getSecurity().getId()));
        POSPersister.saveOrUpdate(currentUser);
    }

    public List<POSSecurityLine> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<POSSecurityLine>();
        }
        return this.capabilities;
    }

    public void setCapabilities(List<POSSecurityLine> capabilities) {
        this.capabilities = capabilities;
    }
}

