/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.details.POSShiftLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity
public class POSShift
extends AbsPOSShiftInventory<NaMaDTO> {
    private boolean closed;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="shift")
    @OrderColumn(name="lineNumber")
    private List<POSShiftLine> details;
    private Boolean openingSent = false;

    public POSShift() {
    }

    public POSShift(String code, Date date, String time, String registeryCode) {
        super(code);
        this.setShiftDate(date);
        this.setTime(time);
        this.updateRegistery(registeryCode);
        this.setDetails(new ArrayList<POSShiftLine>());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public List<POSShiftLine> getDetails() {
        return this.details;
    }

    public void setDetails(List<POSShiftLine> details) {
        this.details = details;
    }

    @Override
    public List<? extends AbsPOSInventoryLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    protected void updateShiftOrInventory(AbsPOSInventoryLine l) {
        ((POSShiftLine)l).setShift(this);
    }

    @Override
    public void updateDetails(List<? extends AbsPOSInventoryLine> list) {
        for (AbsPOSInventoryLine absPOSInventoryLine : list) {
            if (!ObjectChecker.isEmptyOrZero((BigDecimal)absPOSInventoryLine.getActualRemaining())) continue;
            absPOSInventoryLine.setActualRemaining(BigDecimal.ZERO);
        }
        if (this.getDetails() == null) {
            this.setDetails(new ArrayList<POSShiftLine>());
        }
        this.getDetails().clear();
        this.getDetails().addAll(list);
    }

    @Override
    public AbsPOSInventoryLine createLine() {
        return new POSShiftLine();
    }

    @Override
    public String calcNamaEntityType() {
        if (this.isClosed()) {
            return "POSShiftClosing";
        }
        return "POSShiftOpening";
    }

    @Override
    public void setSent(Boolean sent) {
        if (!this.isClosed()) {
            this.setOpeningSent(sent);
        } else {
            super.setSent(sent);
        }
    }

    public Boolean getOpeningSent() {
        return this.openingSent;
    }

    public void setOpeningSent(Boolean openingSent) {
        this.openingSent = openingSent;
    }

    @Override
    public NaMaDTO toDTO() {
        return null;
    }
}

