/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.details.DTOAbsNamaPOSShiftTakenElementLine;
import com.namasoft.modules.namapos.contracts.details.DTOAbsPOSShiftLine;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSShiftCloseShiftTakenElement;
import com.namasoft.modules.namapos.contracts.details.DTOPOSShiftCloseLine;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSShiftOpenClose;
import com.namasoft.modules.namapos.contracts.entities.DTOPOSShiftClosing;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.details.AbsPOSShiftTakenElementsPerShiftLine;
import com.namasoft.pos.domain.details.POSShiftCloseLine;
import com.namasoft.pos.domain.details.POSShiftCloseTakenElementsPerShiftLine;
import com.namasoft.pos.domain.details.POSTakenElementsPerShiftLine;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.orm.POSEntityMediator;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Entity
public class POSShiftClose
extends AbsPOSShiftInventory<DTOPOSShiftClosing> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="shift")
    @OrderColumn(name="lineNumber")
    private List<POSShiftCloseLine> details;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="posShiftClose_id")
    @OrderColumn(name="lineNumber")
    private List<POSShiftCloseTakenElementsPerShiftLine> shiftCloseTakenElementsPerShiftLines;
    @Column(length=16)
    private UUID shiftOpenId;

    public POSShiftClose(String code, Date date, String time, String registeryCode) {
        super(code);
        this.setShiftDate(date);
        this.setTime(time);
        this.updateRegistery(registeryCode);
        this.setDetails(new ArrayList<POSShiftCloseLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public POSShiftClose() {
        if (POSResourcesUtil.generatingDataModel) {
            return;
        }
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
        List<POSTakenElementsPerShiftLine> takenElements = this.fetchTakenElementsFor("POSShiftClosing");
        for (POSTakenElementsPerShiftLine takenItem : takenElements) {
            POSShiftCloseTakenElementsPerShiftLine line = new POSShiftCloseTakenElementsPerShiftLine();
            line.assignIds();
            line.setElement(takenItem.getElement());
            line.setDescription(takenItem.getDescription());
            this.getShiftCloseTakenElementsPerShiftLines().add(line);
        }
    }

    public UUID getShiftOpenId() {
        return this.shiftOpenId;
    }

    public void setShiftOpenId(UUID shiftOpenId) {
        this.shiftOpenId = shiftOpenId;
    }

    @Override
    public List<? extends AbsPOSInventoryLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public List<? extends AbsPOSShiftTakenElementsPerShiftLine> fetchTakenElements() {
        return this.getShiftCloseTakenElementsPerShiftLines();
    }

    @Override
    protected void updateShiftOrInventory(AbsPOSInventoryLine l) {
        ((POSShiftCloseLine)l).setShift(this);
    }

    public void recalcDetails(List<? extends AbsPOSInventoryLine> list) {
        Map map = CollectionsUtility.mapList(list, l -> l.getPaymentMethodName() + "@" + l.getCurrency());
        for (POSShiftCloseLine detail : this.getDetails()) {
            AbsPOSInventoryLine newLine = (AbsPOSInventoryLine)CollectionsUtility.getFirst((List)((List)map.get(detail.getPaymentMethodName() + "@" + detail.getCurrency())));
            if (newLine == null) continue;
            detail.setAccountantRemaining(newLine.getAccountantRemaining());
            detail.setDifference(NaMaMath.subtract((BigDecimal)detail.getActualRemaining(), (BigDecimal)detail.getAccountantRemaining()));
        }
    }

    @Override
    public void updateDetails(List<? extends AbsPOSInventoryLine> list) {
        for (AbsPOSInventoryLine absPOSInventoryLine : list) {
            if (!ObjectChecker.isEmptyOrZero((BigDecimal)absPOSInventoryLine.getActualRemaining())) continue;
            absPOSInventoryLine.setActualRemaining(BigDecimal.ZERO);
        }
        if (this.getDetails() == null) {
            this.setDetails(new ArrayList<POSShiftCloseLine>());
        }
        this.getDetails().clear();
        this.getDetails().addAll(list);
    }

    @Override
    public AbsPOSInventoryLine createLine() {
        return new POSShiftCloseLine();
    }

    @Override
    public String calcNamaEntityType() {
        return "POSShiftClosing";
    }

    public List<POSShiftCloseLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSShiftCloseLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSShiftCloseLine> details) {
        this.details = details;
    }

    public List<POSShiftCloseTakenElementsPerShiftLine> getShiftCloseTakenElementsPerShiftLines() {
        if (this.shiftCloseTakenElementsPerShiftLines == null) {
            this.shiftCloseTakenElementsPerShiftLines = new ArrayList<POSShiftCloseTakenElementsPerShiftLine>();
        }
        return this.shiftCloseTakenElementsPerShiftLines;
    }

    public void setShiftCloseTakenElementsPerShiftLines(List<POSShiftCloseTakenElementsPerShiftLine> shiftCloseTakenElementsPerShiftLines) {
        this.shiftCloseTakenElementsPerShiftLines = shiftCloseTakenElementsPerShiftLines;
    }

    public POSResult close(POSRegistery register, POSResult result) {
        boolean anotherUserShift;
        POSSettingsInfo configuration = POSSettingsInfo.fetchConfiguration();
        this.setPosUser(configuration.getCurrentUser());
        POSShiftOpen lastShift = POSResourcesUtil.fetchLastOpenShift(register);
        if (ObjectChecker.isEmptyOrNull((Object)lastShift)) {
            return result.failure("Please open shift firstly", new Object[0]);
        }
        boolean bl = anotherUserShift = ObjectChecker.isNotEmptyOrNull((Object)lastShift.getPosUser()) && ObjectChecker.areNotEqual((Object)lastShift.getPosUser().getId(), (Object)configuration.getCurrentUser().getId());
        if (anotherUserShift) {
            boolean canCloseAnotherUserShift;
            boolean bl2 = canCloseAnotherUserShift = POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanUseAnotherUserShift).isSucceeded() != false || POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanCloseAnotherUserShift).isSucceeded() != false;
            if (ObjectChecker.isFalse((Boolean)canCloseAnotherUserShift)) {
                return result.failure("Another user shift. User: {0} opened shift at: {1} {2}", lastShift.getPosUser().nameByLanguage(), lastShift.getTime(), LocalDateUtils.dateToLocalDate((Date)lastShift.getShiftDate()));
            }
        }
        this.setShiftOpenId(lastShift.getId());
        if (POSEntityMediator.shouldSendToNamaFirst(register, this, false)) {
            List<ServiceResponse> serviceResponses = POSDataWriterUtil.writeShiftCloseDocsToNamaFirst(register, List.of(this));
            if (ObjectChecker.isNotEmptyOrNull(serviceResponses) && !serviceResponses.getFirst().succeded()) {
                result.failure(ResultDTO.findLeafFailureResults((ResultDTO)serviceResponses.getFirst().getResult()));
            }
            if (result.isSucceeded().booleanValue() && ObjectChecker.isTrue((Boolean)this.getSent())) {
                POSPersister.saveAndCreateActionHistoryEntry(this).addToAccumulateResult(result);
            }
        } else {
            POSPersister.saveAndCreateActionHistoryEntry(this).addToAccumulateResult(result);
        }
        if (result.isFailed().booleanValue()) {
            return result;
        }
        String query = " where hold = true and registerId =:registerId";
        HashMap<String, Object> params = POSPersister.params("registerId", register.getId());
        List<POSSalesInvoice> holdInvoices = POSPersister.listAll(POSSalesInvoice.class, query, params, "code");
        List<?> holdReturns = POSPersister.listAll(POSSalesReturn.class, query, params, "code");
        List<?> holdReplacements = POSPersister.listAll(POSSalesReplacement.class, query, params, "code");
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getSendHeldInvoicesOnShiftClosing())) {
            POSDataWriterUtil.writeHeldInvoice(register, holdInvoices, Callback.NULL, false, "");
        }
        if (ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{holdInvoices, holdReturns, holdReplacements}) && ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getDeleteHeldOnShiftClosing())) {
            POSPersister.deleteAllWithActionHistory(CollectionsUtility.join((List[])new List[]{holdInvoices, holdReturns, holdReplacements}));
        }
        if (POSGeneralSettings.canWriteData()) {
            POSDataWriterUtil.writeData(register);
        }
        return result;
    }

    @Override
    public DTOPOSShiftClosing toDTO() {
        DTOPOSShiftCloseLine dtoLine;
        DTOPOSShiftClosing closingDocDTO = new DTOPOSShiftClosing();
        POSActualDTOConverter.copyBasicData(this, (DTOAbsPOSShiftOpenClose)closingDocDTO);
        POSShiftOpen shiftOpen = (POSShiftOpen)POSPersister.findByCode(POSShiftOpen.class, this.getCode());
        if (ObjectChecker.isNotEmptyOrNull((Object)shiftOpen)) {
            closingDocDTO.setShiftOpenDate(shiftOpen.getShiftDate());
            closingDocDTO.setShiftOpenTime(shiftOpen.getShiftTime());
            closingDocDTO.setShiftCode(shiftOpen.getCode());
        }
        closingDocDTO.setDetails(new ArrayList());
        for (POSShiftCloseLine pOSShiftCloseLine : this.getDetails()) {
            dtoLine = new DTOPOSShiftCloseLine();
            closingDocDTO.getDetails().add(dtoLine);
            POSActualDTOConverter.shiftLineCopier(pOSShiftCloseLine, (DTOAbsPOSShiftLine)dtoLine);
        }
        for (POSShiftCloseTakenElementsPerShiftLine pOSShiftCloseTakenElementsPerShiftLine : this.getShiftCloseTakenElementsPerShiftLines()) {
            dtoLine = new DTONamaPOSShiftCloseShiftTakenElement();
            POSActualDTOConverter.copyShiftTakingElementLine(pOSShiftCloseTakenElementsPerShiftLine, (DTOAbsNamaPOSShiftTakenElementLine)dtoLine);
            closingDocDTO.getTakenElementsPerShiftLines().add(dtoLine);
        }
        closingDocDTO.setShiftOpenId(ServerStringUtils.toUUIDStr((Object)this.getShiftOpenId()));
        return closingDocDTO;
    }
}

