/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.details.DTOAbsNamaPOSShiftTakenElementLine;
import com.namasoft.modules.namapos.contracts.details.DTOAbsPOSShiftLine;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSShiftOpenShiftTakenElementLine;
import com.namasoft.modules.namapos.contracts.details.DTOPOSShiftOpenLine;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSShiftOpenClose;
import com.namasoft.modules.namapos.contracts.entities.DTOPOSShiftOpening;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.details.AbsPOSShiftTakenElementsPerShiftLine;
import com.namasoft.pos.domain.details.POSShiftOpenLine;
import com.namasoft.pos.domain.details.POSShiftOpenTakenElementsPerShiftLine;
import com.namasoft.pos.domain.details.POSTakenElementsPerShiftLine;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.orm.POSEntityMediator;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSResult;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Entity
public class POSShiftOpen
extends AbsPOSShiftInventory<DTOPOSShiftOpening> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="shift")
    @OrderColumn(name="lineNumber")
    private List<POSShiftOpenLine> details;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="posShiftOpen_id")
    @OrderColumn(name="lineNumber")
    private List<POSShiftOpenTakenElementsPerShiftLine> shiftOpenTakenElementsPerShiftLines;

    public POSShiftOpen(String code, Date date, String time, String registeryCode) {
        super(code);
        this.setShiftDate(date);
        this.setTime(time);
        this.updateRegistery(registeryCode);
        this.setDetails(new ArrayList<POSShiftOpenLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public POSShiftOpen() {
        if (POSResourcesUtil.generatingDataModel) {
            return;
        }
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
        List<POSTakenElementsPerShiftLine> takenElements = this.fetchTakenElementsFor("POSShiftOpening");
        for (POSTakenElementsPerShiftLine takenItem : takenElements) {
            POSShiftOpenTakenElementsPerShiftLine line = new POSShiftOpenTakenElementsPerShiftLine();
            line.assignIds();
            line.setElement(takenItem.getElement());
            line.setDescription(takenItem.getDescription());
            this.getShiftOpenTakenElementsPerShiftLines().add(line);
        }
    }

    @Override
    public List<? extends AbsPOSInventoryLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public List<? extends AbsPOSShiftTakenElementsPerShiftLine> fetchTakenElements() {
        return this.getShiftOpenTakenElementsPerShiftLines();
    }

    @Override
    protected void updateShiftOrInventory(AbsPOSInventoryLine l) {
        ((POSShiftOpenLine)l).setShift(this);
    }

    @Override
    public void updateDetails(List<? extends AbsPOSInventoryLine> list) {
        for (AbsPOSInventoryLine absPOSInventoryLine : list) {
            if (!ObjectChecker.isEmptyOrZero((BigDecimal)absPOSInventoryLine.getActualRemaining())) continue;
            absPOSInventoryLine.setActualRemaining(BigDecimal.ZERO);
        }
        if (this.getDetails() == null) {
            this.setDetails(new ArrayList<POSShiftOpenLine>());
        }
        this.getDetails().clear();
        this.getDetails().addAll(list);
    }

    @Override
    public AbsPOSInventoryLine createLine() {
        return new POSShiftOpenLine();
    }

    @Override
    public String calcNamaEntityType() {
        return "POSShiftOpening";
    }

    public List<POSShiftOpenLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSShiftOpenLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSShiftOpenLine> details) {
        this.details = details;
    }

    public List<POSShiftOpenTakenElementsPerShiftLine> getShiftOpenTakenElementsPerShiftLines() {
        if (this.shiftOpenTakenElementsPerShiftLines == null) {
            this.shiftOpenTakenElementsPerShiftLines = new ArrayList<POSShiftOpenTakenElementsPerShiftLine>();
        }
        return this.shiftOpenTakenElementsPerShiftLines;
    }

    public void setShiftOpenTakenElementsPerShiftLines(List<POSShiftOpenTakenElementsPerShiftLine> shiftOpenTakenElementsPerShiftLines) {
        this.shiftOpenTakenElementsPerShiftLines = shiftOpenTakenElementsPerShiftLines;
    }

    public POSResult open(POSRegistery register, POSResult result) {
        this.setPosUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
        boolean shouldSendToNamaFirst = POSEntityMediator.shouldSendToNamaFirst(register, this, false);
        if (shouldSendToNamaFirst) {
            List<ServiceResponse> serviceResponses = POSDataWriterUtil.writeShiftOpenDocsToNamaFirst(register, List.of(this));
            if (ObjectChecker.isNotEmptyOrNull(serviceResponses) && !serviceResponses.getFirst().succeded()) {
                result.failure(ResultDTO.findLeafFailureResults((ResultDTO)serviceResponses.getFirst().getResult()));
            }
            if (result.isSucceeded().booleanValue() && ObjectChecker.isTrue((Boolean)this.getSent())) {
                POSPersister.saveAndCreateActionHistoryEntry(this).addToAccumulateResult(result);
            }
        } else {
            POSPersister.saveAndCreateActionHistoryEntry(this).addToAccumulateResult(result);
        }
        if (result.isFailed().booleanValue()) {
            return result;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)this.getSent())) {
            if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) {
                POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeShiftsOpenDocs(register, Arrays.asList(this))));
            }
        }
        return result;
    }

    @Override
    public DTOPOSShiftOpening toDTO() {
        DTOPOSShiftOpenLine dtoLine;
        DTOPOSShiftOpening openDocDTO = new DTOPOSShiftOpening();
        POSActualDTOConverter.copyBasicData(this, (DTOAbsPOSShiftOpenClose)openDocDTO);
        openDocDTO.setDetails(new ArrayList());
        for (POSShiftOpenLine pOSShiftOpenLine : this.getDetails()) {
            dtoLine = new DTOPOSShiftOpenLine();
            openDocDTO.getDetails().add(dtoLine);
            POSActualDTOConverter.shiftLineCopier(pOSShiftOpenLine, (DTOAbsPOSShiftLine)dtoLine);
        }
        for (POSShiftOpenTakenElementsPerShiftLine pOSShiftOpenTakenElementsPerShiftLine : this.getShiftOpenTakenElementsPerShiftLines()) {
            dtoLine = new DTONamaPOSShiftOpenShiftTakenElementLine();
            POSActualDTOConverter.copyShiftTakingElementLine(pOSShiftOpenTakenElementsPerShiftLine, (DTOAbsNamaPOSShiftTakenElementLine)dtoLine);
            openDocDTO.getTakenElementsPerShiftLines().add(dtoLine);
        }
        return openDocDTO;
    }
}

