/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSShortfallsDoc;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSShortfallsDocLine;
import com.namasoft.pos.domain.details.POSShortfallsDocRemovedLine;
import com.namasoft.pos.domain.entities.IHasReservationAmount;
import com.namasoft.pos.domain.entities.IPOSFromReplacement;
import com.namasoft.pos.domain.entities.IPosDocWithoutPayment;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.valueobjects.POSReference;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
public class POSShortfallsDoc
extends AbsPOSSales
implements IPOSFromReplacement,
IHasReservationAmount,
IPosDocWithoutPayment {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="shortfalls")
    @OrderColumn(name="lineNumber")
    private List<POSShortfallsDocLine> details;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="shortfalls")
    @OrderColumn(name="lineNumber")
    private List<POSShortfallsDocRemovedLine> removedLines;
    private String shortfallsSrcDocType;
    @Column(length=16)
    private UUID shortfallsSrcDocId;
    @Embedded
    private POSReference ref1;
    private Boolean fromCaptainOrder = false;
    private Boolean returnBefore = false;

    public POSShortfallsDoc() {
    }

    public String getShortfallsSrcDocType() {
        return this.shortfallsSrcDocType;
    }

    public void setShortfallsSrcDocType(String shortfallsSrcDocType) {
        this.shortfallsSrcDocType = shortfallsSrcDocType;
    }

    public UUID getShortfallsSrcDocId() {
        return this.shortfallsSrcDocId;
    }

    public void setShortfallsSrcDocId(UUID shortfallsSrcDocId) {
        this.shortfallsSrcDocId = shortfallsSrcDocId;
    }

    public Boolean getFromCaptainOrder() {
        if (this.fromCaptainOrder == null) {
            this.fromCaptainOrder = false;
        }
        return this.fromCaptainOrder;
    }

    public void updateReference(POSMasterFile ref, String type) {
        if (ref == null) {
            return;
        }
        if (this.ref1 == null) {
            this.ref1 = new POSReference();
        }
        this.ref1.setRefId(ref.getId());
        this.ref1.setRefCode(ref.getCode());
        this.ref1.setRefType(type);
        this.ref1.setRefNamaType(ref.calcNamaEntityType());
    }

    public POSReference getRef1() {
        return this.ref1;
    }

    public void setRef1(POSReference ref1) {
        this.ref1 = ref1;
    }

    public void setFromCaptainOrder(Boolean fromCaptainOrder) {
        this.fromCaptainOrder = fromCaptainOrder;
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public List<? extends AbsPOSPaymentLine> fetchPayments() {
        return null;
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchRemovedLines() {
        return this.getRemovedLines();
    }

    @Override
    public String fromInvoiceCode() {
        return "";
    }

    @Override
    public void updateDetails(List<? extends AbsPOSSalesLine> list) {
        this.setDetails(list);
    }

    @Override
    public <T extends AbsPOSPaymentLine> T createPaymentLine(String methodName, UUID methodId, BigDecimal value, String authorizationNumber, Boolean cash) {
        return null;
    }

    public Boolean getReturnBefore() {
        return this.returnBefore;
    }

    public void setReturnBefore(Boolean returnBefore) {
        this.returnBefore = returnBefore;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSShortfallsDoc";
    }

    @Override
    public BigDecimal calcCashValue() {
        return null;
    }

    @Override
    public BigDecimal calcDebitValue() {
        return null;
    }

    public boolean totalyReturned() {
        for (POSShortfallsDocLine posShortfallsDocLine : this.getDetails()) {
            if (!ObjectChecker.areNotEqual((Object)posShortfallsDocLine.getQty().getValue(), (Object)posShortfallsDocLine.getReturnedQty())) continue;
            return false;
        }
        return true;
    }

    @Override
    public POSDocumentType docType() {
        return POSDocumentType.ShortfallsDoc;
    }

    @Override
    public void initializeLists() {
        this.fetchDetails().size();
        this.fetchDetails().forEach(l -> {
            if (l.getLocation() != null) {
                l.getLocation().getCode();
            }
            if (l.getWarehouse() != null) {
                l.getWarehouse().getCode();
            }
            if (l.getSalesman() != null) {
                l.getSalesman().getCode();
            }
        });
        this.getRemovedLines().size();
    }

    public POSRegistery fetchShortfallsDocRegister() {
        UUID srcShortfallsDocRegisterId = this.getRegisterId();
        if (srcShortfallsDocRegisterId == null) {
            return null;
        }
        return POSPersister.findByID(POSRegistery.class, srcShortfallsDocRegisterId);
    }

    @Override
    public List<String> screenFieldsToUpdate() {
        return CollectionsUtility.join((List[])new List[]{SalesDocCommonFieldIds, Arrays.asList("shortfallsDocCode", "shortfallsRef")});
    }

    @Override
    public BigDecimal getReservationAmount() {
        return null;
    }

    @Override
    public String getReplacementCode() {
        return null;
    }

    public List<POSShortfallsDocLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSShortfallsDocLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSShortfallsDocLine> details_) {
        if (ObjectChecker.isEmptyOrNull(this.details)) {
            this.details = new ArrayList<POSShortfallsDocLine>();
        }
        this.details.clear();
        this.details.addAll(details_);
    }

    public List<POSShortfallsDocRemovedLine> getRemovedLines() {
        if (this.removedLines == null) {
            this.removedLines = new ArrayList<POSShortfallsDocRemovedLine>();
        }
        return this.removedLines;
    }

    public POSShortfallsDoc(AbsPosSalesScreen screen) {
        this.setDetails(new ArrayList<POSShortfallsDocLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    @Override
    public List<String> filterByFields() {
        List<String> list = super.filterByFields();
        list.add("fromCaptainOrder");
        return list;
    }

    @Override
    public <T extends AbsPOSSalesLine> T createBasicLine() {
        POSShortfallsDocLine posShortfallsDocLine = new POSShortfallsDocLine();
        posShortfallsDocLine.setShortfalls(this);
        return (T)posShortfallsDocLine;
    }

    @Override
    public void updateFieldsAndSave(String code, String warehouse, String location, String receiptSrcType, UUID receiptSrcId) {
        this.setCode(code);
        this.setWarehouse(POSPersister.findByID(POSWarehouse.class, warehouse));
        this.setLocation(POSPersister.findByID(POSLocation.class, location));
        this.assignIds();
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        this.updateShiftData(register);
        this.setValueDate(new Date());
        this.setValueTime(new Date());
        POSPersister.saveOrUpdateWithActionHistory(this, null);
        if (POSResourcesUtil.currentSetting != null) {
            if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) {
                POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeShortfallsDocs(register, Arrays.asList(this))));
            }
        }
        this.setCurrentUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "customer", "salesMan", "netPrice", "valueDate", "shiftCode");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public NaMaDTO toDTO() {
        DTONamaPOSShortfallsDoc dtoNamaPOSShortfallsDoc = new DTONamaPOSShortfallsDoc();
        POSActualDTOConverter.convertToDTO(this, (DTOAbsPOSSalesDoc)dtoNamaPOSShortfallsDoc);
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{this.getShortfallsSrcDocType(), this.getShortfallsSrcDocId()})) {
            dtoNamaPOSShortfallsDoc.setFromDoc(new EntityReferenceData(POSShortfallsDoc.shortfallsSourceToDocumentType(this.getShortfallsSrcDocType()), ServerStringUtils.toUUIDStr((Object)this.getShortfallsSrcDocId())));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getRef1())) {
            dtoNamaPOSShortfallsDoc.setRef1(new EntityReferenceData(this.getRef1().getRefNamaType(), ServerStringUtils.toUUIDStr((Object)this.getRef1().getRefId())));
        }
        return dtoNamaPOSShortfallsDoc;
    }

    private static String shortfallsSourceToDocumentType(String shortfallsSrcDocType) {
        if (shortfallsSrcDocType.equals("FromPurchaseInvoice")) {
            return "PurchaseInvoice";
        }
        return null;
    }
}

