/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.modules.basic.contracts.details.DTOReplacementLine;
import com.namasoft.modules.basic.contracts.details.DTOTranslationLine;
import com.namasoft.modules.basic.contracts.entities.DTOTranslationOverRider;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSReplacementLine;
import com.namasoft.pos.domain.details.POSTranslationLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.List;

@Entity
public class POSTranslationOverrider
extends POSMasterFile<DTOTranslationOverRider> {
    private Integer priority;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posTranslation")
    @OrderColumn(name="lineNumber")
    private List<POSTranslationLine> translations;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posTranslation")
    @OrderColumn(name="lineNumber")
    private List<POSReplacementLine> replacments;
    private Boolean inActive;

    @Override
    public void initializeLists() {
        this.getTranslations().size();
        this.getReplacments().size();
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public List<POSTranslationLine> getTranslations() {
        if (this.translations == null) {
            this.translations = new ArrayList<POSTranslationLine>();
        }
        return this.translations;
    }

    public void setTranslations(List<POSTranslationLine> translations) {
        this.translations = translations;
    }

    public List<POSReplacementLine> getReplacments() {
        if (this.replacments == null) {
            this.replacments = new ArrayList<POSReplacementLine>();
        }
        return this.replacments;
    }

    public void setReplacments(List<POSReplacementLine> replacments) {
        this.replacments = replacments;
    }

    public Boolean getInActive() {
        return this.inActive;
    }

    public void setInActive(Boolean inActive) {
        this.inActive = inActive;
    }

    @Override
    public void updateData(DTOTranslationOverRider translation) {
        super.updateData(translation);
        if (ObjectChecker.isNotEmptyOrNull((Object)translation.getPriority())) {
            this.setPriority(translation.getPriority().intValue());
        }
        this.setInActive(translation.getInActive());
        this.getReplacments().clear();
        this.getReplacments().addAll(this.posFromDTOReplacementFactory(translation.getReplacments()));
        this.getTranslations().clear();
        this.getTranslations().addAll(this.posFromDTOTranslationsFactory(translation.getTranslations()));
    }

    private List<POSTranslationLine> posFromDTOTranslationsFactory(List<DTOTranslationLine> dtoTranslations) {
        ArrayList<POSTranslationLine> translationLines = new ArrayList<POSTranslationLine>();
        for (DTOTranslationLine line : dtoTranslations) {
            if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{line.getForType(), line.getEntityTypeList()})) {
                this.createLine(translationLines, line, "");
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)line.getForType())) {
                this.createLine(translationLines, line, line.getForType());
            }
            if (!ObjectChecker.isNotEmptyOrNull((Object)line.getEntityTypeList())) continue;
            List allTypes = StringUtils.csvLineToList((String)((String)line.getEntityTypeList().get("lines.entityType")));
            for (String type : allTypes) {
                this.createLine(translationLines, line, type);
            }
        }
        return translationLines;
    }

    private void createLine(List<POSTranslationLine> translationLines, DTOTranslationLine dtoTranslationLine, String forType) {
        POSTranslationLine line = new POSTranslationLine();
        line.setEntityType(forType);
        line.setLineID(dtoTranslationLine.getLineID());
        line.setArabic(dtoTranslationLine.getArabic());
        line.setEnglish(dtoTranslationLine.getEnglish());
        line.setPosTranslation(this);
        translationLines.add(line);
    }

    private List<POSReplacementLine> posFromDTOReplacementFactory(List<DTOReplacementLine> dtoReplacments) {
        ArrayList<POSReplacementLine> replacementLines = new ArrayList<POSReplacementLine>();
        for (DTOReplacementLine dtoReplacementLine : dtoReplacments) {
            POSReplacementLine line = new POSReplacementLine();
            replacementLines.add(line);
            line.setReplacement(dtoReplacementLine.getReplacement());
            line.setText(dtoReplacementLine.getText());
            line.setPosTranslation(this);
        }
        return replacementLines;
    }

    @Override
    public void assignIds() {
        this.getId();
        for (POSTranslationLine pOSTranslationLine : this.getTranslations()) {
            pOSTranslationLine.getId();
            pOSTranslationLine.setPosTranslation(this);
        }
        for (POSReplacementLine pOSReplacementLine : this.getReplacments()) {
            pOSReplacementLine.getId();
            pOSReplacementLine.setPosTranslation(this);
        }
    }

    @Override
    public String calcNamaEntityType() {
        return "TranslationOverRider";
    }
}

