/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.DTOUser;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSSecurity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import java.util.UUID;

@Entity
public class POSUser
extends POSMasterFile<DTOUser> {
    private String userId;
    private String password;
    @Column(length=16)
    private UUID empId;
    @Column(length=16)
    private UUID empDepartmentId;
    @Column(length=16)
    private UUID empJobPositionId;
    @Column(length=16)
    private UUID empOrgPositionId;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSecurity security;
    @Column(length=16)
    private UUID groupId;
    @Column(length=16)
    private UUID securityProfileId;
    private Boolean preventLogin;
    private String preventedLoginMessage;

    public POSUser() {
    }

    public UUID getSecurityProfileId() {
        return this.securityProfileId;
    }

    public void setSecurityProfileId(UUID securityProfileId) {
        this.securityProfileId = securityProfileId;
    }

    public POSUser(String user, String pass) {
        this.userId = user;
        this.password = pass;
    }

    public UUID getEmpDepartmentId() {
        return this.empDepartmentId;
    }

    public void setEmpDepartmentId(UUID empDepartmentId) {
        this.empDepartmentId = empDepartmentId;
    }

    public UUID getEmpJobPositionId() {
        return this.empJobPositionId;
    }

    public void setEmpJobPositionId(UUID empJobPositionId) {
        this.empJobPositionId = empJobPositionId;
    }

    public UUID getEmpOrgPositionId() {
        return this.empOrgPositionId;
    }

    public void setEmpOrgPositionId(UUID empOrgPositionId) {
        this.empOrgPositionId = empOrgPositionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void initializeLists() {
    }

    @Override
    public void updateData(DTOUser dtoUser) {
        super.updateData(dtoUser);
        this.setUserId(dtoUser.getLoginId());
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoUser.getSettings().getPosSecurityProfile())) {
            this.setSecurity((POSSecurity)this.fromReference(dtoUser.getSettings().getPosSecurityProfile()));
        } else {
            this.setSecurity(null);
        }
        EntityReferenceData employee = dtoUser.getEmployee();
        if (ObjectChecker.isNotEmptyOrNull((Object)employee)) {
            this.setEmpId(ServerStringUtils.strToUUID((String)employee.getId()));
            this.setEmpDepartmentId(ServerStringUtils.strToUUID((String)((String)employee.get("employeeDepartment"))));
            this.setEmpJobPositionId(ServerStringUtils.strToUUID((String)((String)employee.get("jobPosition"))));
            this.setEmpOrgPositionId(ServerStringUtils.strToUUID((String)((String)employee.get("organizationPosition"))));
        } else {
            this.setEmpId(null);
            this.setEmpDepartmentId(null);
            this.setEmpJobPositionId(null);
            this.setEmpOrgPositionId(null);
        }
        String password = dtoUser.getPassword();
        if (password != null && password.startsWith("#**#P")) {
            password = password.substring("#**#P".length());
        }
        this.setPassword(password);
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoUser.getGroup())) {
            this.setGroupId(ServerStringUtils.strToUUID((String)dtoUser.getGroup().getId()));
        } else {
            this.setGroupId(null);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoUser.getSecurityProfile())) {
            this.setSecurityProfileId(ServerStringUtils.strToUUID((String)dtoUser.getSecurityProfile().getId()));
        } else {
            this.setSecurityProfileId(null);
        }
        this.setPreventLogin(dtoUser.getSettings().getPreventLogin());
        this.setPreventedLoginMessage(dtoUser.getSettings().getPreventedLoginMessage());
    }

    public UUID getEmpId() {
        return this.empId;
    }

    public void setEmpId(UUID empId) {
        this.empId = empId;
    }

    public POSSecurity getSecurity() {
        if (ObjectChecker.isEmptyOrNull((Object)this.security)) {
            return new POSSecurity();
        }
        this.security = POSPersister.materialize(POSSecurity.class, this.security);
        return this.security;
    }

    public void setSecurity(POSSecurity security) {
        this.security = security;
    }

    @Override
    public String calcNamaEntityType() {
        return "User";
    }

    public void setGroupId(UUID groupId) {
        this.groupId = groupId;
    }

    public UUID getGroupId() {
        return this.groupId;
    }

    public Boolean getPreventLogin() {
        return this.preventLogin;
    }

    public void setPreventLogin(Boolean preventLogin) {
        this.preventLogin = preventLogin;
    }

    public String getPreventedLoginMessage() {
        return this.preventedLoginMessage;
    }

    public void setPreventedLoginMessage(String preventedLoginMessage) {
        this.preventedLoginMessage = preventedLoginMessage;
    }
}

