/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPosDefaultsTemplate;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.PosDefaultsTemplateLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Entity
public class PosDefaultsTemplate
extends POSMasterFile<DTONamaPosDefaultsTemplate> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="defaultsTemplate")
    @OrderColumn(name="lineNumber")
    private List<PosDefaultsTemplateLine> details;

    @Override
    public void updateData(DTONamaPosDefaultsTemplate object) {
        super.updateData(object);
        this.getDetails().clear();
        this.getDetails().addAll(CollectionsUtility.convert((Collection)object.getDetails(), PosDefaultsTemplateLine::new));
        POSResourcesUtil.defaultsTemplate = null;
    }

    @Override
    public void assignIds() {
        super.assignIds();
        for (PosDefaultsTemplateLine line : this.getDetails()) {
            line.getId();
            line.setDefaultsTemplate(this);
        }
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPosDefaultsTemplate";
    }

    public List<PosDefaultsTemplateLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<PosDefaultsTemplateLine>();
        }
        return this.details;
    }

    public void setDetails(List<PosDefaultsTemplateLine> details) {
        this.details = details;
    }
}

