/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.details.DTOPosMinChargeLine;
import com.namasoft.modules.namapos.contracts.entities.DTOPosMinChargeSettings;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.PosMinChargeLine;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity
public class PosMinCharge
extends POSMasterFile<DTOPosMinChargeSettings> {
    @Temporal(value=TemporalType.DATE)
    private Date fromDate;
    @Temporal(value=TemporalType.DATE)
    private Date toDate;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="minCharge")
    @OrderColumn(name="lineNumber")
    private List<PosMinChargeLine> details;

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public List<PosMinChargeLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<PosMinChargeLine>();
        }
        return this.details;
    }

    public void setDetails(List<PosMinChargeLine> details) {
        this.details = details;
    }

    @Override
    public void assignIds() {
        super.assignIds();
        for (PosMinChargeLine line : this.getDetails()) {
            line.getId();
            line.setMinCharge(this);
        }
    }

    @Override
    public String calcNamaEntityType() {
        return "PosMinChargeSettings";
    }

    @Override
    public void updateData(DTOPosMinChargeSettings object) {
        super.updateData(object);
        this.setFromDate(object.getFromDate());
        this.setToDate(object.getToDate());
        if (this.getDetails() == null) {
            this.setDetails(new ArrayList<PosMinChargeLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)object.getDetails(), this.getDetails(), PosMinChargeLine::new);
        for (int i = 0; i < object.getDetails().size(); ++i) {
            DTOPosMinChargeLine dtoLine = (DTOPosMinChargeLine)object.getDetails().get(i);
            PosMinChargeLine line = this.getDetails().get(i);
            line.setMinCharge(this);
            line.setFromDate(dtoLine.getFromDate());
            line.setToDate(dtoLine.getToDate());
            line.setMinChargeValue(dtoLine.getMinChargeValue());
            line.setInvoiceClassification((POSInvoiceClassification)this.fromReference(dtoLine.getInvoiceClassification()));
        }
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }
}

