/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPosRequiredFields;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.PosRequiredFieldsLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Entity
public class PosRequiredFields
extends POSMasterFile<DTONamaPosRequiredFields> {
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="reqFields")
    @OrderColumn(name="lineNumber")
    private List<PosRequiredFieldsLine> details;

    public List<PosRequiredFieldsLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<PosRequiredFieldsLine>();
        }
        return this.details;
    }

    public void setDetails(List<PosRequiredFieldsLine> details) {
        this.details = details;
    }

    @Override
    public void updateData(DTONamaPosRequiredFields object) {
        super.updateData(object);
        this.getDetails().clear();
        this.getDetails().addAll(CollectionsUtility.convert((Collection)object.getDetails(), PosRequiredFieldsLine::new));
        this.getDetails().stream().forEach(l -> l.setReqFields(this));
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPosRequiredFields";
    }
}

