/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.reporting;

import com.namasoft.common.Pair;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Map;
import javafx.application.Platform;
import javafx.util.Duration;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.controlsfx.control.Notifications;
import org.hibernate.Session;

public class POSJasperReportRunner {
    private static POSJasperReportRunner instance;
    private static Field jasperPrintField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperPrint fillReport(InputStream compiledReport, Map<String, Object> parameters) {
        Pair print = new Pair(null, null);
        try (Session session = POSPersister.openSession();){
            session.doWork(connection -> {
                try {
                    print.setX((Object)JasperFillManager.fillReport((InputStream)compiledReport, (Map)parameters, (Connection)connection));
                    compiledReport.close();
                }
                catch (Throwable e) {
                    this.handleFillReportException(e);
                }
            });
        }
        if (print.getX() == null || ObjectChecker.isEmptyOrNull((Object)((JasperPrint)print.getX()).getPages())) {
            NaMaLogger.error((Object)"The print has no pages");
        }
        return (JasperPrint)print.getX();
    }

    private void handleFillReportException(Throwable e) {
        NaMaLogger.error((Throwable)e);
        String errorMessage = e.getMessage();
        if (e instanceof UnsupportedClassVersionError) {
            errorMessage = POSResourcesUtil.id("Can not run the Report because the java version of the server is more recent than the POS java version. So please upgrade POS java version or downgrade server java version.", new Object[0]);
        }
        String finalMessage = errorMessage != null ? errorMessage : "Failed to generate report";
        Platform.runLater(() -> Notifications.create().title("Report Generation Error").text(finalMessage).darkStyle().hideAfter(Duration.seconds((double)5.0)).showError());
    }

    public static POSJasperReportRunner instance() {
        if (instance == null) {
            instance = new POSJasperReportRunner();
        }
        return instance;
    }

    static {
        try {
            jasperPrintField = JRAbstractExporter.class.getDeclaredField("jasperPrint");
            jasperPrintField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

