/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.valueobjects;

import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.util.POSDataReaderUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.util.UUID;

@Embeddable
public class POSEntityRefData {
    @Column(name="namaGenRefId", length=16)
    private UUID namaGenRefId;
    private String namaEntityType;
    private String code;
    private String name1;
    private String name2;

    public static POSEntityRefData fromEntityRefData(EntityReferenceData ref) {
        if (ref == null) {
            return null;
        }
        POSEntityRefData posRef = new POSEntityRefData();
        posRef.setNamaGenRefId(ServerStringUtils.strToUUID((String)ref.getId()));
        posRef.setNamaEntityType(ref.getEntityType());
        posRef.setCode(ref.getCode());
        posRef.setName1(ref.getName1());
        posRef.setName2(ref.getName2());
        return posRef;
    }

    public EntityReferenceData toEntityRefData() {
        EntityReferenceData data = new EntityReferenceData();
        data.setId(ServerStringUtils.toUUIDStr((Object)this.getNamaGenRefId()));
        data.setEntityType(this.getNamaEntityType());
        data.setCode(this.getCode());
        data.setActualCode(this.getCode());
        data.setAltCode(this.getCode());
        data.setName1(this.getName1());
        data.setName2(this.getName2());
        return data;
    }

    public UUID getNamaGenRefId() {
        return this.namaGenRefId;
    }

    public void setNamaGenRefId(UUID namaGenRefId) {
        this.namaGenRefId = namaGenRefId;
    }

    public String getNamaEntityType() {
        return this.namaEntityType;
    }

    public void setNamaEntityType(String namaEntityType) {
        this.namaEntityType = namaEntityType;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName1() {
        return this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public String calcNamaEntityType() {
        return this.namaEntityType;
    }

    public String nameByLanguage() {
        if (POSResourcesUtil.getCurrentLang().equals((Object)Language.Arabic)) {
            return this.getName1();
        }
        return this.getName2();
    }

    public POSMasterFile<?> toReal() {
        Class klass = POSDataReaderUtil.constructNamaWithPOSTypesMap().get(this.getNamaEntityType());
        return (POSMasterFile)POSPersister.findByID(klass, this.getNamaGenRefId());
    }
}

