/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.valueobjects;

import com.namasoft.common.constants.Operator;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.namacontrols.NamaComboBox;
import com.namasoft.namacontrols.NamaDatePicker;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.OperatorForCombo;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import com.namasoft.specialserialization.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.input.KeyCode;
import javafx.util.StringConverter;

public class POSFieldFilterPart<T extends Node>
extends NamaHBox {
    private NamaLabel fieldLabel;
    private T textField;
    private ComboBox<OperatorForCombo> operator;
    private Class onKlass;
    private FieldType fieldType;

    public POSFieldFilterPart(String fieldId, Consumer<Event> searchAction, Class onKlass, IHasToolBar screen) {
        this.getStyleClass().add((Object)"filter-field");
        this.onKlass = onKlass;
        this.fieldLabel = new NamaLabel(fieldId);
        this.fieldType = FieldType.Text;
        this.textField = new NamaTextField(POSFieldType.Text);
        if (POSMasterFile.fieldIsFromType(fieldId, onKlass, BigDecimal.class)) {
            this.textField = new NamaTextField(POSFieldType.Decimal);
            this.fieldType = FieldType.Decimal;
        }
        if (POSMasterFile.fieldIsFromType(fieldId, onKlass, Date.class)) {
            this.textField = new NamaDatePicker();
            this.fieldType = FieldType.Date;
        }
        if (POSMasterFile.fieldIsFromType(fieldId, onKlass, Boolean.class)) {
            this.textField = new NamaComboBox<Serializable>(Arrays.asList(true, false, ""), screen, fieldId);
            ((NamaComboBox)this.textField).setMaxWidth(Double.MAX_VALUE);
            this.fieldType = FieldType.Boolean;
        }
        this.textField.setId(fieldId);
        this.textField.setOnKeyPressed(e -> {
            if (e.getCode().equals((Object)KeyCode.ENTER)) {
                searchAction.accept(e);
            }
        });
        ((POSField)this.textField).textProperty().addListener(e -> searchAction.accept(null));
        this.operator = this.buildOperationCombobox(fieldId);
        this.operator.setMaxWidth(Double.MAX_VALUE);
        this.operator.getSelectionModel().selectFirst();
        this.operator.setConverter((StringConverter)new StringConverter<OperatorForCombo>(){

            public String toString(OperatorForCombo object) {
                return object.getText();
            }

            public OperatorForCombo fromString(String string) {
                return POSFieldFilterPart.this.operator.getItems().stream().filter(ap -> ap.getText().equals(string)).findFirst().orElse(null);
            }
        });
        this.operator.setId(fieldId);
        this.getChildren().addAll((Object[])new Node[]{this.fieldLabel, this.operator, this.textField});
    }

    private NamaComboBox<OperatorForCombo> buildOperationCombobox(String fieldId) {
        return new NamaComboBox<OperatorForCombo>((List<OperatorForCombo>)this.fetchOperatorsForField(fieldId));
    }

    private ObservableList<OperatorForCombo> fetchOperatorsForField(String fieldId) {
        ObservableList operators = FXCollections.observableArrayList((Object[])new OperatorForCombo[]{new OperatorForCombo(Operator.Equal), new OperatorForCombo(Operator.NotEqual)});
        if (POSMasterFile.fieldIsFromType(fieldId, this.onKlass, Boolean.class)) {
            return operators;
        }
        if (POSMasterFile.fieldIsFromType(fieldId, this.onKlass, Date.class) || POSMasterFile.fieldIsFromType(fieldId, this.onKlass, BigDecimal.class)) {
            operators.addAll((Collection)FXCollections.observableArrayList((Object[])new OperatorForCombo[]{new OperatorForCombo(Operator.GreaterThanOrEqual), new OperatorForCombo(Operator.GreaterThan), new OperatorForCombo(Operator.LessThanOrEqual), new OperatorForCombo(Operator.LessThan)}));
            return operators;
        }
        operators.addAll(0, (Collection)FXCollections.observableArrayList((Object[])new OperatorForCombo[]{new OperatorForCombo(Operator.Contains), new OperatorForCombo(Operator.StartsWith), new OperatorForCombo(Operator.EndsWith)}));
        return operators;
    }

    public POSFieldFilterPart(T textField, ComboBox<OperatorForCombo> operation, Class onKlass, FieldType fieldType) {
        this.setTextField(textField);
        this.setOperator(operation);
        this.onKlass = onKlass;
        this.fieldType = fieldType;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public T getTextField() {
        return this.textField;
    }

    public void setTextField(T textField) {
        this.textField = textField;
    }

    public ComboBox<OperatorForCombo> getOperator() {
        return this.operator;
    }

    public void setOperator(ComboBox<OperatorForCombo> operator) {
        this.operator = operator;
    }

    public String fetchCondition() {
        try {
            Class returnType = ReflectionUtils.getMethodActualReturnType((Method)this.onKlass.getMethod("get" + StringUtils.firstLetterUpper((String)this.textField.getId()), new Class[0]));
            if (POSMasterFile.class.isAssignableFrom(returnType)) {
                POSMasterFile object = (POSMasterFile)ObjectCreatorUtil.creator((Class)returnType).create();
                return object.filteringCondition(this.textField.getId(), this.operatorToString(this.getOperator()));
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        return this.textField.getId() + this.operatorToString(this.getOperator()) + " :" + this.textField.getId();
    }

    private String operatorToString(ComboBox<OperatorForCombo> operator) {
        Operator operatorValue = ((OperatorForCombo)operator.getValue()).getOperator();
        switch (operatorValue) {
            case Equal: {
                return "=";
            }
            case NotEqual: {
                return "<>";
            }
            case StartsWith: 
            case EndsWith: 
            case Contains: {
                return " like ";
            }
            case GreaterThan: {
                return ">";
            }
            case GreaterThanOrEqual: {
                return ">=";
            }
            case LessThan: {
                return "<";
            }
            case LessThanOrEqual: {
                return "<=";
            }
        }
        return "=";
    }
}

