/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.valueobjects;

import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.IPOSDocFile;
import com.namasoft.pos.domain.entities.POSCurrency;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.UUID;

@Entity
public class POSFinancialSysLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    private String shiftCode;
    @Column(length=16)
    private UUID paymentMethodId;
    private String paymentMethodName;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency currency;
    @Column(precision=20, scale=10)
    private BigDecimal value;
    private Boolean cash;
    private Boolean debit;
    private String originCode;
    private String originType;
    @Column(length=16)
    private UUID originId;
    private Date valueDate;
    @Column(length=16)
    private UUID registerId;

    public void update(IPOSFinancialEffect iHasFinancialEffect) {
        this.shiftCode = iHasFinancialEffect.getShiftCode();
        this.paymentMethodId = iHasFinancialEffect.getPaymentMethodId();
        this.currency = iHasFinancialEffect.fetchCurrency();
        this.value = iHasFinancialEffect.getAmount();
        this.cash = iHasFinancialEffect.isCash();
        this.debit = iHasFinancialEffect.isDebit();
        this.paymentMethodName = iHasFinancialEffect.getPaymentMethodName();
        if (iHasFinancialEffect.origin() != null) {
            this.originCode = iHasFinancialEffect.origin().getCode();
            this.originId = iHasFinancialEffect.origin().getId();
            this.originType = iHasFinancialEffect.origin().calcNamaEntityType();
            if (iHasFinancialEffect.origin() instanceof IPOSDocFile) {
                LocalDate localDate = LocalDateUtils.dateToLocalDate((Date)((IPOSDocFile)((Object)iHasFinancialEffect.origin())).fetchValueDate());
                LocalTime localTime = LocalDateUtils.dateToLocalTime((Date)((IPOSDocFile)((Object)iHasFinancialEffect.origin())).fetchValueTime());
                this.valueDate = LocalDateUtils.localDateTimeToDateTime((LocalDateTime)localDate.atTime(localTime));
            }
            if (iHasFinancialEffect.origin().register() != null) {
                this.registerId = iHasFinancialEffect.origin().register().getId();
            }
        }
    }

    public String getPaymentMethodName() {
        return this.paymentMethodName;
    }

    public void setPaymentMethodName(String paymentMethodName) {
        this.paymentMethodName = paymentMethodName;
    }

    public String getOriginType() {
        return this.originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public UUID getOriginId() {
        return this.originId;
    }

    public void setOriginId(UUID originId) {
        this.originId = originId;
    }

    public Boolean getCash() {
        return this.cash;
    }

    public void setCash(Boolean cash) {
        this.cash = cash;
    }

    public Boolean getDebit() {
        return this.debit;
    }

    public void setDebit(Boolean debit) {
        this.debit = debit;
    }

    public String getShiftCode() {
        return this.shiftCode;
    }

    public void setShiftCode(String shiftCode) {
        this.shiftCode = shiftCode;
    }

    public POSCurrency getCurrency() {
        this.currency = POSPersister.materialize(POSCurrency.class, this.currency);
        return this.currency;
    }

    public void setCurrency(POSCurrency currency) {
        this.currency = currency;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(UUID paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public String getOriginCode() {
        return this.originCode;
    }

    public void setOriginCode(String originCode) {
        this.originCode = originCode;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }

    public UUID getRegisterId() {
        return this.registerId;
    }

    public void setRegisterId(UUID registerId) {
        this.registerId = registerId;
    }
}

