/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.valueobjects;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOFreeItemData;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AssociationOverrides;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;

@Embeddable
public class POSFreeItemData {
    @Column(precision=20, scale=10)
    private BigDecimal maxQty;
    @Column(precision=20, scale=10)
    private BigDecimal soldQty;
    private Boolean manual;
    private Boolean taxable;
    @AttributeOverrides(value={@AttributeOverride(name="color", column=@Column(name="freeColor")), @AttributeOverride(name="colorName", column=@Column(name="freeColorName")), @AttributeOverride(name="sizeName", column=@Column(name="freeSizeName")), @AttributeOverride(name="lotId", column=@Column(name="freeLotId")), @AttributeOverride(name="revisionId", column=@Column(name="freeRevisionId")), @AttributeOverride(name="serialNumber", column=@Column(name="freeSerialNumber")), @AttributeOverride(name="size", column=@Column(name="freeSize"))})
    private POSItemSpecificDimensions freeItemDimensions;
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="pValue", precision=20, scale=10))})
    @AssociationOverrides(value={@AssociationOverride(name="uom", joinColumns={@JoinColumn(name="pUom_id")})})
    private POSQuantity freeQty;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItem freeItem;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSFreeItemGroup freeGroup;
    private String freePolicy;
    private String replacePolicy;

    public POSFreeItemGroup getFreeGroup() {
        this.freeGroup = POSPersister.materialize(POSFreeItemGroup.class, this.freeGroup);
        return this.freeGroup;
    }

    public void setFreeGroup(POSFreeItemGroup freeGroup) {
        this.freeGroup = freeGroup;
    }

    public BigDecimal getMaxQty() {
        return this.maxQty;
    }

    public void setMaxQty(BigDecimal maxQty) {
        this.maxQty = maxQty;
    }

    public BigDecimal getSoldQty() {
        return this.soldQty;
    }

    public void setSoldQty(BigDecimal soldQty) {
        this.soldQty = soldQty;
    }

    public Boolean getManual() {
        return this.manual;
    }

    public void setManual(Boolean manual) {
        this.manual = manual;
    }

    public Boolean getTaxable() {
        return this.taxable;
    }

    public void setTaxable(Boolean taxable) {
        this.taxable = taxable;
    }

    public POSItemSpecificDimensions getFreeItemDimensions() {
        return this.freeItemDimensions;
    }

    public void setFreeItemDimensions(POSItemSpecificDimensions freeItemDimensions) {
        this.freeItemDimensions = freeItemDimensions;
    }

    public POSQuantity getFreeQty() {
        return this.freeQty;
    }

    public void setFreeQty(POSQuantity freeQty) {
        this.freeQty = freeQty;
    }

    public POSItem getFreeItem() {
        this.freeItem = POSPersister.materialize(POSItem.class, this.freeItem);
        return this.freeItem;
    }

    public void setFreeItem(POSItem freeItem) {
        this.freeItem = freeItem;
    }

    public String getFreePolicy() {
        return this.freePolicy;
    }

    public void setFreePolicy(String freePolicy) {
        this.freePolicy = freePolicy;
    }

    public String getReplacePolicy() {
        return this.replacePolicy;
    }

    public void setReplacePolicy(String replacePolicy) {
        this.replacePolicy = replacePolicy;
    }

    public static POSFreeItemData fromDTO(DTOFreeItemData freeItemData, POSSavable requester) {
        POSFreeItemData data = new POSFreeItemData();
        EntityReferenceData freeItem = freeItemData.getFreeItem();
        if (freeItem != null) {
            if (ObjectChecker.areEqual((Object)freeItem.getEntityType(), (Object)"InvItem")) {
                data.setFreeItem((POSItem)requester.fromReference(freeItem));
            } else {
                data.setFreeGroup(POSPersister.findByID(POSFreeItemGroup.class, freeItem.getId()));
            }
        }
        data.setFreeItemDimensions(POSItemSpecificDimensions.fromDTOItemSpecificDimensions(freeItemData.getFreeItemDimensions()));
        data.setFreePolicy(freeItemData.getFreePolicy());
        data.setFreeQty(POSQuantity.fromDTORawQuantity(freeItemData.getFreeQty(), requester));
        data.setManual(freeItemData.getManual());
        data.setMaxQty(freeItemData.getMaxQty());
        data.setReplacePolicy(freeItemData.getReplacePolicy());
        data.setSoldQty(freeItemData.getSoldQty());
        data.setTaxable(freeItemData.getTaxable());
        return data;
    }
}

