/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.valueobjects;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;

@Embeddable
public class POSGenericDims {
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="legalEntityId", length=16)), @AttributeOverride(name="code", column=@Column(name="legalEntityCode"))})
    private POSDimInfo legalEntity;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="sectorId", length=16)), @AttributeOverride(name="code", column=@Column(name="sectorCode"))})
    private POSDimInfo sector;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="branchId", length=16)), @AttributeOverride(name="code", column=@Column(name="branchCode"))})
    private POSDimInfo branch;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="departmentId", length=16)), @AttributeOverride(name="code", column=@Column(name="departmentCode"))})
    private POSDimInfo department;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="analysisSetId", length=16)), @AttributeOverride(name="code", column=@Column(name="analysisSetCode"))})
    private POSDimInfo analysisSet;

    public POSGenericDims() {
    }

    public POSGenericDims(POSDimInfo legalEntity, POSDimInfo sector, POSDimInfo branch, POSDimInfo department, POSDimInfo analysisSet) {
        this.setLegalEntity(legalEntity);
        this.setSector(sector);
        this.setBranch(branch);
        this.setAnalysisSet(analysisSet);
        this.setDepartment(department);
    }

    public static POSGenericDims calcDims(BaseEntityDTO object) {
        DTOGenericDimensions dims = new DTOGenericDimensions();
        dims.setLegalEntity(object.getLegalEntity());
        dims.setAnalysisSet(object.getAnalysisSet());
        dims.setDepartment(object.getDepartment());
        dims.setBranch(object.getBranch());
        dims.setSector(object.getSector());
        return POSGenericDims.fromNamaGenericDims(dims);
    }

    public static POSGenericDims fromNamaGenericDims(DTOGenericDimensions dimensions) {
        POSGenericDims posGenericDims = new POSGenericDims();
        posGenericDims.setLegalEntity(new POSDimInfo());
        posGenericDims.getLegalEntity().setCode(dimensions.getLegalEntity().getCode());
        posGenericDims.getLegalEntity().setId(ServerStringUtils.strToUUID((String)dimensions.getLegalEntity().getId()));
        posGenericDims.setBranch(new POSDimInfo());
        posGenericDims.getBranch().setCode(dimensions.getBranch().getCode());
        posGenericDims.getBranch().setId(ServerStringUtils.strToUUID((String)dimensions.getBranch().getId()));
        posGenericDims.setSector(new POSDimInfo());
        posGenericDims.getSector().setCode(dimensions.getSector().getCode());
        posGenericDims.getSector().setId(ServerStringUtils.strToUUID((String)dimensions.getSector().getId()));
        posGenericDims.setAnalysisSet(new POSDimInfo());
        posGenericDims.getAnalysisSet().setCode(dimensions.getAnalysisSet().getCode());
        posGenericDims.getAnalysisSet().setId(ServerStringUtils.strToUUID((String)dimensions.getAnalysisSet().getId()));
        posGenericDims.setDepartment(new POSDimInfo());
        posGenericDims.getDepartment().setCode(dimensions.getDepartment().getCode());
        posGenericDims.getDepartment().setId(ServerStringUtils.strToUUID((String)dimensions.getDepartment().getId()));
        return posGenericDims;
    }

    public static DTOGenericDimensions toNamaGenericDims(POSGenericDims dims) {
        DTOGenericDimensions genDims = new DTOGenericDimensions();
        genDims.setLegalEntity(EntityReferenceData.id((String)"LegalEntity", (String)dims.getLegalEntity().getId().toString()));
        genDims.setAnalysisSet(EntityReferenceData.id((String)"AnalysisSet", (String)dims.getAnalysisSet().getId().toString()));
        genDims.setDepartment(EntityReferenceData.id((String)"Department", (String)dims.getDepartment().getId().toString()));
        genDims.setSector(EntityReferenceData.id((String)"Sector", (String)dims.getSector().getId().toString()));
        genDims.setBranch(EntityReferenceData.id((String)"Branch", (String)dims.getBranch().getId().toString()));
        return genDims;
    }

    public POSDimInfo getAnalysisSet() {
        return this.analysisSet;
    }

    public void setAnalysisSet(POSDimInfo analysisSet) {
        this.analysisSet = analysisSet;
    }

    public POSDimInfo getSector() {
        return this.sector;
    }

    public void setSector(POSDimInfo sector) {
        this.sector = sector;
    }

    public POSDimInfo getBranch() {
        return this.branch;
    }

    public void setBranch(POSDimInfo branch) {
        this.branch = branch;
    }

    public POSDimInfo getDepartment() {
        return this.department;
    }

    public void setDepartment(POSDimInfo department) {
        this.department = department;
    }

    public POSDimInfo getLegalEntity() {
        return this.legalEntity;
    }

    public void setLegalEntity(POSDimInfo legalEntity) {
        this.legalEntity = legalEntity;
    }

    public POSGenericDims cloneData() {
        POSGenericDims posGenericDims = new POSGenericDims();
        posGenericDims.setAnalysisSet(new POSDimInfo());
        posGenericDims.getAnalysisSet().setCode(this.getAnalysisSet().getCode());
        posGenericDims.getAnalysisSet().setId(this.getAnalysisSet().getId());
        posGenericDims.setLegalEntity(new POSDimInfo());
        posGenericDims.getLegalEntity().setCode(this.getLegalEntity().getCode());
        posGenericDims.getLegalEntity().setId(this.getLegalEntity().getId());
        posGenericDims.setBranch(new POSDimInfo());
        posGenericDims.getBranch().setCode(this.getBranch().getCode());
        posGenericDims.getBranch().setId(this.getBranch().getId());
        posGenericDims.setSector(new POSDimInfo());
        posGenericDims.getSector().setCode(this.getSector().getCode());
        posGenericDims.getSector().setId(this.getSector().getId());
        posGenericDims.setDepartment(new POSDimInfo());
        posGenericDims.getDepartment().setId(this.getDepartment().getId());
        posGenericDims.getDepartment().setCode(this.getDepartment().getCode());
        return posGenericDims;
    }
}

